/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Proxy {
    private static int PORT = 6668;
    private static String SERVER_ADDRESS = "localhost:6666";
    private boolean interrupted = false;

    public void run() {
        ServerSocket service = null;
        try {
            service = new ServerSocket(PORT);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Accepting connections");
        int connectionNumber = 0;
        while (!this.interrupted) {
            try {
                final Socket socket = service.accept();
                String connectionName = "Connection" + ++connectionNumber;
                System.out.println(connectionName + ": Client connection accepted.");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Proxy.this.serve(socket);
                            socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                Thread t = new Thread(runnable, connectionName);
                t.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (service != null) {
                service.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void serve(Socket socket) throws IOException {
        String[] split = SERVER_ADDRESS.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        }
        InetSocketAddress dbAddress = new InetSocketAddress(split[0], Integer.parseInt(split[1]));
        Socket dbSocket = new Socket();
        try {
            dbSocket.connect(dbAddress);
        }
        catch (IOException iOException) {
            dbSocket.close();
            System.out.println("serve() Couldn't connect to database '" + SERVER_ADDRESS + "'");
            return;
        }
        String t = Thread.currentThread().getName();
        System.out.println(t + ": Server connection ok.");
        this.proxy(dbSocket, socket, "db", "client");
        dbSocket.close();
        System.out.println(t + ": Client connection closed.");
    }

    private void proxy(final Socket a, final Socket b, String aName, String bName) {
        Runnable ab = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[256];
                    while (a.isConnected() && b.isConnected()) {
                        int n = a.getInputStream().read(buffer);
                        if (n >= 1) {
                            b.getOutputStream().write(buffer, 0, n);
                            b.getOutputStream().flush();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        };
        Runnable ba = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[256];
                    while (b.isConnected() && a.isConnected()) {
                        int n = b.getInputStream().read(buffer);
                        if (n >= 1) {
                            a.getOutputStream().write(buffer, 0, n);
                            a.getOutputStream().flush();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        };
        String t = Thread.currentThread().getName();
        Thread tab = new Thread(ab, t + " " + aName + "->" + bName);
        Thread tba = new Thread(ba, t + " " + bName + "->" + aName);
        tab.start();
        tba.start();
        try {
            while (tba.isAlive() && tab.isAlive()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            a.close();
            b.close();
        }
        catch (IOException iOException) {}
    }

    public static void main(String[] args) {
        Proxy proxy = new Proxy();
        proxy.run();
    }
}

