/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    vtkViewsInfovis("vtkViewsInfovisJava"),
    vtkCommonColor("vtkCommonColorJava"),
    vtkViewsContext2D("vtkViewsContext2DJava"),
    vtkTestingRendering("vtkTestingRenderingJava"),
    vtkRenderingVolumeOpenGL2("vtkRenderingVolumeOpenGL2Java"),
    vtkRenderingLabel("vtkRenderingLabelJava"),
    vtkRenderingLOD("vtkRenderingLODJava"),
    vtkRenderingLICOpenGL2("vtkRenderingLICOpenGL2Java"),
    vtkRenderingImage("vtkRenderingImageJava"),
    vtkRenderingContextOpenGL2("vtkRenderingContextOpenGL2Java"),
    vtkIOVeraOut("vtkIOVeraOutJava"),
    vtkIOTecplotTable("vtkIOTecplotTableJava"),
    vtkIOSegY("vtkIOSegYJava"),
    vtkIOParallelXML("vtkIOParallelXMLJava"),
    vtkIOParallel("vtkIOParallelJava"),
    vtkIOPLY("vtkIOPLYJava"),
    vtkIOOggTheora("vtkIOOggTheoraJava"),
    vtkIONetCDF("vtkIONetCDFJava"),
    vtkIOMotionFX("vtkIOMotionFXJava"),
    vtkIOMINC("vtkIOMINCJava"),
    vtkIOLSDyna("vtkIOLSDynaJava"),
    vtkIOInfovis("vtkIOInfovisJava"),
    vtkIOImport("vtkIOImportJava"),
    vtkIOIOSS("vtkIOIOSSJava"),
    vtkIOVideo("vtkIOVideoJava"),
    vtkIOMovie("vtkIOMovieJava"),
    vtkIOExportPDF("vtkIOExportPDFJava"),
    vtkIOExportGL2PS("vtkIOExportGL2PSJava"),
    vtkRenderingGL2PSOpenGL2("vtkRenderingGL2PSOpenGL2Java"),
    vtkIOExport("vtkIOExportJava"),
    vtkRenderingVtkJS("vtkRenderingVtkJSJava"),
    vtkRenderingSceneGraph("vtkRenderingSceneGraphJava"),
    vtkIOExodus("vtkIOExodusJava"),
    vtkIOEnSight("vtkIOEnSightJava"),
    vtkIOCityGML("vtkIOCityGMLJava"),
    vtkIOChemistry("vtkIOChemistryJava"),
    vtkIOCesium3DTiles("vtkIOCesium3DTilesJava"),
    vtkIOGeometry("vtkIOGeometryJava"),
    vtkIOCONVERGECFD("vtkIOCONVERGECFDJava"),
    vtkIOHDF("vtkIOHDFJava"),
    vtkIOCGNSReader("vtkIOCGNSReaderJava"),
    vtkIOAsynchronous("vtkIOAsynchronousJava"),
    vtkIOAMR("vtkIOAMRJava"),
    vtkInteractionImage("vtkInteractionImageJava"),
    vtkImagingStencil("vtkImagingStencilJava"),
    vtkImagingStatistics("vtkImagingStatisticsJava"),
    vtkImagingMorphological("vtkImagingMorphologicalJava"),
    vtkImagingMath("vtkImagingMathJava"),
    vtkImagingFourier("vtkImagingFourierJava"),
    vtkIOSQL("vtkIOSQLJava"),
    vtkGeovisCore("vtkGeovisCoreJava"),
    vtkInfovisLayout("vtkInfovisLayoutJava"),
    vtkViewsCore("vtkViewsCoreJava"),
    vtkInteractionWidgets("vtkInteractionWidgetsJava"),
    vtkRenderingVolume("vtkRenderingVolumeJava"),
    vtkRenderingAnnotation("vtkRenderingAnnotationJava"),
    vtkImagingHybrid("vtkImagingHybridJava"),
    vtkImagingColor("vtkImagingColorJava"),
    vtkInteractionStyle("vtkInteractionStyleJava"),
    vtkFiltersTopology("vtkFiltersTopologyJava"),
    vtkFiltersSelection("vtkFiltersSelectionJava"),
    vtkFiltersSMP("vtkFiltersSMPJava"),
    vtkFiltersProgrammable("vtkFiltersProgrammableJava"),
    vtkFiltersPoints("vtkFiltersPointsJava"),
    vtkFiltersVerdict("vtkFiltersVerdictJava"),
    vtkFiltersParallelImaging("vtkFiltersParallelImagingJava"),
    vtkFiltersImaging("vtkFiltersImagingJava"),
    vtkImagingGeneral("vtkImagingGeneralJava"),
    vtkFiltersGeneric("vtkFiltersGenericJava"),
    vtkFiltersFlowPaths("vtkFiltersFlowPathsJava"),
    vtkFiltersAMR("vtkFiltersAMRJava"),
    vtkFiltersParallel("vtkFiltersParallelJava"),
    vtkFiltersTexture("vtkFiltersTextureJava"),
    vtkFiltersModeling("vtkFiltersModelingJava"),
    vtkDomainsChemistryOpenGL2("vtkDomainsChemistryOpenGL2Java"),
    vtkRenderingOpenGL2("vtkRenderingOpenGL2Java"),
    vtkRenderingHyperTreeGrid("vtkRenderingHyperTreeGridJava"),
    vtkRenderingUI("vtkRenderingUIJava"),
    vtkFiltersHyperTree("vtkFiltersHyperTreeJava"),
    vtkFiltersHybrid("vtkFiltersHybridJava"),
    vtkDomainsChemistry("vtkDomainsChemistryJava"),
    vtkChartsCore("vtkChartsCoreJava"),
    vtkInfovisCore("vtkInfovisCoreJava"),
    vtkFiltersExtraction("vtkFiltersExtractionJava"),
    vtkIOXML("vtkIOXMLJava"),
    vtkIOXMLParser("vtkIOXMLParserJava"),
    vtkParallelCore("vtkParallelCoreJava"),
    vtkIOLegacy("vtkIOLegacyJava"),
    vtkIOCore("vtkIOCoreJava"),
    vtkFiltersStatistics("vtkFiltersStatisticsJava"),
    vtkImagingSources("vtkImagingSourcesJava"),
    vtkIOImage("vtkIOImageJava"),
    vtkRenderingContext2D("vtkRenderingContext2DJava"),
    vtkRenderingFreeType("vtkRenderingFreeTypeJava"),
    vtkRenderingCore("vtkRenderingCoreJava"),
    vtkFiltersSources("vtkFiltersSourcesJava"),
    vtkImagingCore("vtkImagingCoreJava"),
    vtkFiltersGeometry("vtkFiltersGeometryJava"),
    vtkFiltersGeneral("vtkFiltersGeneralJava"),
    vtkCommonComputationalGeometry("vtkCommonComputationalGeometryJava"),
    vtkFiltersCore("vtkFiltersCoreJava"),
    vtkCommonExecutionModel("vtkCommonExecutionModelJava"),
    vtkCommonDataModel("vtkCommonDataModelJava"),
    vtkCommonSystem("vtkCommonSystemJava"),
    vtkCommonMisc("vtkCommonMiscJava"),
    vtkCommonTransforms("vtkCommonTransformsJava"),
    vtkCommonMath("vtkCommonMathJava"),
    vtkCommonCore("vtkCommonCoreJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean isEveryThingLoaded = true;
        vtkNativeLibrary[] vtkNativeLibraryArray = vtkNativeLibrary.values();
        int n = vtkNativeLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            vtkNativeLibrary lib = vtkNativeLibraryArray[n2];
            try {
                lib.LoadLibrary();
            }
            catch (UnsatisfiedLinkError e) {
                isEveryThingLoaded = false;
                e.printStackTrace();
            }
            ++n2;
        }
        return isEveryThingLoaded;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... nativeLibraries) {
        vtkNativeLibrary[] vtkNativeLibraryArray = nativeLibraries;
        int n = nativeLibraries.length;
        int n2 = 0;
        while (n2 < n) {
            vtkNativeLibrary lib = vtkNativeLibraryArray[n2];
            lib.LoadLibrary();
            ++n2;
        }
    }

    public static void DisableOutputWindow(File logFile) {
        if (logFile == null) {
            logFile = new File("vtkError.txt");
        }
        vtkFileOutputWindow outputError = new vtkFileOutputWindow();
        outputError.SetFileName(logFile.getAbsolutePath());
        outputError.SetInstance(outputError);
    }

    private vtkNativeLibrary(String nativeLibraryName) {
        this.nativeLibraryName = nativeLibraryName;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File dir = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(dir.getAbsolutePath());
                File libPath = new File(dir, System.mapLibraryName(this.nativeLibraryName));
                if (libPath.exists()) {
                    try {
                        Runtime.getRuntime().load(libPath.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError e) {
                        e.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String vtkLibDir) {
        if (vtkLibDir != null) {
            String path_separator = System.getProperty("path.separator");
            Object s = System.getProperty("java.library.path");
            if (!((String)s).contains(vtkLibDir)) {
                s = (String)s + path_separator + vtkLibDir;
                System.setProperty("java.library.path", (String)s);
            }
        }
    }
}

