/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.layer0.Layer0;
import org.simantics.plant3d.ontology.Plant3D;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;
import org.simantics.plant3d.scl.SCLUtil;
import org.simantics.plant3d.utils.Item;

public class P3DUtil {
    public static List<Item> getEquipments() throws DatabaseException {
        return P3DUtil.getEquipments(SCLUtil.getRequestProcessor());
    }

    public static List<Item> getEquipments(RequestProcessor session) throws DatabaseException {
        return P3DUtil.getEquipments(session, "http://www.simantics.org/Plant3D-0.1/Builtin");
    }

    public static List<Item> getEquipments(String libUri) throws DatabaseException {
        return P3DUtil.getEquipments(SCLUtil.getRequestProcessor(), libUri);
    }

    public static List<Item> getEquipments(RequestProcessor session, final String libUri) throws DatabaseException {
        return (List)session.syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                Resource project = (Resource)Simantics.getProject().get();
                Resource builtins = graph.getResource(libUri);
                List<Item> actions = P3DUtil.getItems(graph, project, p3d.Equipment);
                actions.addAll(P3DUtil.getItems(graph, builtins, p3d.Equipment));
                return actions;
            }
        });
    }

    public static List<Item> getNozzles(String libUri) throws DatabaseException {
        return P3DUtil.getNozzles(SCLUtil.getRequestProcessor(), libUri);
    }

    public static List<Item> getNozzles(RequestProcessor session, final String libUri) throws DatabaseException {
        return (List)session.syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.Nozzle, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> getEnds(String libUri) throws DatabaseException {
        return P3DUtil.getEnds(SCLUtil.getRequestProcessor(), libUri);
    }

    public static List<Item> getEnds(RequestProcessor session, final String libUri) throws DatabaseException {
        return (List)session.syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.EndComponent, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> getTurns(String libUri) throws DatabaseException {
        return P3DUtil.getTurns(SCLUtil.getRequestProcessor(), libUri);
    }

    public static List<Item> getTurns(RequestProcessor session, final String libUri) throws DatabaseException {
        return (List)session.syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.TurnComponent, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> getInlines(String libUri) throws DatabaseException {
        return P3DUtil.getInlines(SCLUtil.getRequestProcessor(), libUri);
    }

    public static List<Item> getInlines(RequestProcessor session, final String libUri) throws DatabaseException {
        return (List)session.syncRequest((Read)new Read<List<Item>>(){

            public List<Item> perform(ReadGraph graph) throws DatabaseException {
                Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
                ItemQuery query = new ItemQuery(p3d.InlineComponent, libUri);
                return (List)graph.syncRequest((Read)query);
            }
        });
    }

    public static List<Item> filterUserComponents(List<Item> items) {
        ArrayList<Item> result = new ArrayList<Item>(items.size());
        for (Item i : items) {
            if (i.isCode()) continue;
            result.add(i);
        }
        return result;
    }

    private static List<Item> getItems(ReadGraph graph, Resource lib, Resource type) throws DatabaseException {
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Item> result = new ArrayList<Item>();
        HashSet<Resource> processed = new HashSet<Resource>();
        ArrayDeque stack = new ArrayDeque();
        stack.addAll(graph.getObjects(lib, l0.ConsistsOf));
        stack.addAll(graph.getObjects(lib, p3d.ComponentLibrary_contains));
        while (!stack.isEmpty()) {
            Resource geom;
            Resource r = (Resource)stack.pop();
            if (processed.contains(r)) continue;
            processed.add(r);
            if (graph.isInstanceOf(r, type) && ((geom = graph.getPossibleObject(r, p3d.hasGeometry)) != null || graph.hasStatement(r, p3d.NonVisibleComponent))) {
                result.add(P3DUtil.createItem(graph, r));
                continue;
            }
            if (graph.isInheritedFrom(r, type)) {
                boolean asserts = false;
                for (Resource a : graph.getObjects(r, l0.Asserts)) {
                    if (!p3d.hasGeometry.equals(graph.getPossibleObject(a, l0.HasPredicate))) continue;
                    asserts = true;
                    break;
                }
                if (asserts) {
                    result.add(P3DUtil.createItem(graph, r));
                    continue;
                }
            }
            if (!graph.isInstanceOf(r, p3d.ComponentLibrary)) continue;
            stack.addAll(graph.getObjects(r, l0.ConsistsOf));
            stack.addAll(graph.getObjects(r, p3d.ComponentLibrary_contains));
        }
        Collections.sort(result, (i1, i2) -> {
            String s1 = i1.getLabel();
            String s2 = i2.getLabel();
            s1 = s1.isBlank() ? i1.getName() : s1;
            s2 = s2.isBlank() ? i2.getName() : s2;
            return s1.compareTo(s2);
        });
        return result;
    }

    public static Item createItem(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(r, l0.HasName);
        String uri = graph.getURI(r);
        String label = (String)graph.getPossibleRelatedValue(r, l0.HasLabel);
        Item item = new Item(uri, name, label);
        if (graph.isInstanceOf(r, p3d.Equipment)) {
            item.setType(Item.Type.EQUIPMENT);
        } else if (graph.isInstanceOf(r, p3d.InlineComponent)) {
            item.setType(Item.Type.INLINE);
        } else if (graph.isInstanceOf(r, p3d.EndComponent)) {
            item.setType(Item.Type.END);
        } else if (graph.isInstanceOf(r, p3d.TurnComponent)) {
            item.setType(Item.Type.TURN);
        } else if (graph.isInstanceOf(r, p3d.Nozzle)) {
            item.setType(Item.Type.NOZZLE);
        } else {
            throw new RuntimeException("Cannot detect type for " + String.valueOf(r));
        }
        if (graph.hasStatement(r, p3d.CodeComponent)) {
            item.setCode(true);
        }
        if (graph.hasStatement(r, p3d.VariableAngleTurnComponent) || graph.hasStatement(r, p3d.VariableLengthInlineComponent)) {
            item.setVariable(true);
        }
        if (graph.hasStatement(r, p3d.AdjustableLengthInlineComponent)) {
            item.setModifiable(true);
        }
        if (graph.hasStatement(r, p3d.SizeChangeComponent)) {
            item.setSizeChange(true);
        }
        if (graph.hasStatement(r, p3d.RotateComponent)) {
            item.setRotated(true);
        }
        return item;
    }

    public static Resource createModel(WriteGraph graph, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Plant3D p3d = Plant3D.getInstance((ReadGraph)graph);
        Resource model = graph.newResource();
        graph.claim(model, l0.InstanceOf, p3d.Plant);
        graph.claimLiteral(model, l0.HasName, (Object)name);
        return model;
    }

    public static void finalizeDBLoad(ParentNode<INode> rootNode) throws Exception {
        List children = rootNode.getNodes("http://www.simantics.org/Plant3D-0.1/children");
        for (INode node : children) {
            if (node instanceof PipeRun) {
                for (PipelineComponent pipelineComponent : ((PipeRun)node).getChild()) {
                    pipelineComponent.sync();
                    if (pipelineComponent instanceof TurnComponent) {
                        PipingRules.updateTurnControlPointTurn(pipelineComponent.getControlPoint(), null, null);
                    }
                    pipelineComponent.updateParameters();
                }
                continue;
            }
            if (node instanceof Equipment) {
                for (PipelineComponent pipelineComponent : ((Equipment)node).getChild()) {
                    pipelineComponent.sync();
                    pipelineComponent.updateParameters();
                }
                continue;
            }
            if (!(node instanceof ParentNode)) continue;
            P3DUtil.finalizeDBLoad((ParentNode<INode>)((ParentNode)node));
        }
        for (INode node : children) {
            if (node instanceof PipeRun) {
                for (PipelineComponent pipelineComponent : ((PipeRun)node).getChild()) {
                    pipelineComponent.sync2();
                }
                continue;
            }
            if (!(node instanceof Equipment)) continue;
            for (PipelineComponent pipelineComponent : ((Equipment)node).getChild()) {
                pipelineComponent.sync2();
            }
        }
        if (rootNode instanceof P3DRootNode) {
            for (INode node : children) {
                if (!(node instanceof PipeRun)) continue;
                ((P3DRootNode)rootNode).validate((PipeRun)node);
            }
        }
    }

    public static void finalizeDBLoad2(P3DRootNode rootNode) throws Exception {
        rootNode.enablePipingRules(true);
        P3DUtil.doFinalizeDBLoad2(rootNode);
        rootNode.updatePipingRules();
    }

    private static void doFinalizeDBLoad2(ParentNode<INode> rootNode) {
        List children = rootNode.getNodes("http://www.simantics.org/Plant3D-0.1/children");
        for (INode node : children) {
            if (node instanceof PipeRun) {
                PipeRun run = (PipeRun)node;
                for (PipeControlPoint pcp : run.getControlPoints()) {
                    if (!pcp.asPathLegEnd()) continue;
                    pcp.requestUpdate();
                }
                continue;
            }
            if (!(node instanceof ParentNode)) continue;
            P3DUtil.doFinalizeDBLoad2((ParentNode<INode>)((ParentNode)node));
        }
    }

    public static class ItemQuery
    implements Read<List<Item>> {
        private Resource type;
        private String libUri;

        public ItemQuery(Resource type, String libUri) {
            this.type = type;
            this.libUri = libUri;
        }

        public List<Item> perform(ReadGraph graph) throws DatabaseException {
            Resource builtins = graph.getResource(this.libUri);
            ArrayList<Item> actions = new ArrayList<Item>();
            actions.addAll(P3DUtil.getItems(graph, builtins, this.type));
            return actions;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ItemQuery other = (ItemQuery)obj;
            if (!this.type.equals(other.type)) {
                return false;
            }
            return this.libUri.equals(other.libUri);
        }

        public int hashCode() {
            return this.type.hashCode() + this.libUri.hashCode();
        }
    }
}

