/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph.controlpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipingRules {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipingRules.class);
    private static final boolean DUMMY = false;
    private static double MIN_TURN_ANGLE = 0.001;
    private static double ALLOWED_OFFSET = 0.001;
    private static double MIN_INLINE_LENGTH = 5.0E-4;
    private static final int REMOVE_NONE = 0;
    private static final int REMOVE_START = 1;
    private static final int REMOVE_END = 2;
    private static final int REMOVE_BOTH = 3;
    private boolean enabled = true;
    private boolean updating = false;
    private boolean allowInsertRemove = true;
    private boolean triedIR = false;
    private List<PipeControlPoint> requestUpdates = new ArrayList<PipeControlPoint>();
    private List<PipeControlPoint> currentUpdates = new ArrayList<PipeControlPoint>();
    private Object updateMutex = new Object();
    private Object ruleMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestUpdate(PipeControlPoint pcp) {
        if (!this.enabled) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules request " + String.valueOf(pcp));
        }
        Object object = this.updateMutex;
        synchronized (object) {
            if (!this.requestUpdates.contains(pcp)) {
                this.requestUpdates.add(pcp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() throws Exception {
        ArrayList<PipeControlPoint> temp;
        if (!this.enabled) {
            return false;
        }
        Object object = this.updateMutex;
        synchronized (object) {
            block12: {
                if (this.requestUpdates.size() != 0) break block12;
                return false;
            }
            temp = new ArrayList<PipeControlPoint>(this.requestUpdates.size());
            temp.addAll(this.requestUpdates);
            this.requestUpdates.clear();
        }
        object = this.ruleMutex;
        synchronized (object) {
            this.currentUpdates.clear();
            this.currentUpdates.addAll(temp);
            for (PipeControlPoint pcp : this.currentUpdates) {
                this._positionUpdate(pcp, true);
            }
            this.currentUpdates.clear();
        }
        object = this.updateMutex;
        synchronized (object) {
            this.requestUpdates.removeAll(temp);
        }
        return true;
    }

    public boolean positionUpdate(PipeControlPoint pcp) throws Exception {
        return this.positionUpdate(pcp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean positionUpdate(PipeControlPoint pcp, boolean allowIR) throws Exception {
        Object object = this.ruleMutex;
        synchronized (object) {
            this.currentUpdates.add(pcp);
            boolean b = this._positionUpdate(pcp, allowIR);
            this.currentUpdates.clear();
            return b;
        }
    }

    private boolean _positionUpdate(PipeControlPoint pcp, boolean allowIR) throws Exception {
        if (this.updating || !this.enabled) {
            return true;
        }
        if (pcp.getPipeRun() == null) {
            return false;
        }
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("PipingRules " + String.valueOf(pcp));
            }
            this.updating = true;
            this.allowInsertRemove = allowIR;
            this.triedIR = false;
            this.validate(pcp.getPipeRun());
            if (pcp.getParentPoint() != null) {
                pcp = pcp.getParentPoint();
            }
            if (pcp.asPathLegEnd()) {
                this.updatePathLegEndControlPoint(pcp);
            } else {
                this.updateInlineControlPoint(pcp);
            }
            this.validate(pcp.getPipeRun());
            if (!this.allowInsertRemove) {
                boolean bl = !this.triedIR;
                return bl;
            }
            return true;
        }
        finally {
            this.updating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            Object object = this.ruleMutex;
            synchronized (object) {
                this.currentUpdates.clear();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void updatePathLegEndControlPoint(PipeControlPoint pcp) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updatePathLegEndControlPoint() " + String.valueOf(pcp));
        }
        if (pcp.getNext() != null) {
            this.updatePathLegNext(pcp, pcp, PathLegUpdateType.NEXT_S);
        }
        if (pcp.getPrevious() != null) {
            this.updatePathLegPrev(pcp, pcp, PathLegUpdateType.PREV_S);
        }
    }

    private void updateInlineControlPoint(PipeControlPoint pcp) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateInlineControlPoint() " + String.valueOf(pcp));
        }
        PipeControlPoint start = pcp.findPreviousEnd();
        this.updatePathLegCurr(start, pcp, PathLegUpdateType.NONE);
        if (pcp.isOffset()) {
            PipeControlPoint end = pcp.findNextEnd();
            if (end.isVariableAngle()) {
                this.updatePathLegNext(end, end, PathLegUpdateType.NONE);
            }
            if (start.isVariableAngle()) {
                this.updatePathLegPrev(start, start, PathLegUpdateType.NONE);
            }
        }
    }

    private PipeControlPoint insertElbow(PipeControlPoint pcp1, PipeControlPoint pcp2, Vector3d pos) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.insertElbow() " + String.valueOf(pcp1) + " " + String.valueOf(pcp2) + " " + String.valueOf(pos));
        }
        if (pcp1.getNext() != pcp2 || pcp2.getPrevious() != pcp1) {
            if (pcp1.getNext() == pcp2 && pcp1.isDualInline() && pcp2.getPrevious() == pcp1.getDualSub()) {
                pcp1 = pcp1.getDualSub();
            } else if (pcp1.getPrevious() == pcp2 && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2;
                pcp2 = t;
            } else if (pcp2.isDualInline() && pcp1.getPrevious() == pcp2.getDualSub() && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2.getDualSub();
                pcp2 = t;
            } else {
                throw new RuntimeException();
            }
        }
        TurnComponent elbow = ComponentUtils.createTurn((P3DRootNode)pcp1.getRootNode());
        PipeControlPoint pcp = elbow.getControlPoint();
        if (pcp1.isDualInline()) {
            pcp1 = pcp1.getDualSub();
        }
        String name = pcp1.getPipeRun().getUniqueName("Elbow");
        elbow.setName(name);
        pcp1.getPipeRun().addChild(elbow);
        pcp.insert(pcp1, pcp2);
        pcp.setWorldPosition(pos);
        this.validate(pcp.getPipeRun());
        return pcp;
    }

    private PipeControlPoint insertStraight(PipeControlPoint pcp1, PipeControlPoint pcp2, Vector3d pos, double length) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.insertStraight() " + String.valueOf(pcp1) + " " + String.valueOf(pcp2) + " " + String.valueOf(pos));
        }
        if (pcp1.getNext() != pcp2 || pcp2.getPrevious() != pcp1) {
            if (pcp1.getNext() == pcp2 && pcp1.isDualInline() && pcp2.getPrevious() == pcp1.getDualSub()) {
                pcp1 = pcp1.getDualSub();
            } else if (pcp1.getPrevious() == pcp2 && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2;
                pcp2 = t;
            } else if (pcp2.isDualInline() && pcp1.getPrevious() == pcp2.getDualSub() && pcp2.getNext() == pcp1) {
                t = pcp1;
                pcp1 = pcp2.getDualSub();
                pcp2 = t;
            } else {
                throw new RuntimeException();
            }
        }
        InlineComponent component = ComponentUtils.createStraight((P3DRootNode)pcp1.getRootNode());
        PipeControlPoint scp = component.getControlPoint();
        if (pcp1.isDualInline()) {
            pcp1 = pcp1.getDualSub();
        }
        String name = pcp1.getPipeRun().getUniqueName("Pipe");
        component.setName(name);
        pcp1.getPipeRun().addChild(component);
        scp.insert(pcp1, pcp2);
        scp.setWorldPosition(pos);
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)pcp2.getWorldPosition(), (Tuple3d)pcp1.getWorldPosition());
        scp.orientToDirection(dir);
        scp.setLength(length);
        this.validate(scp.getPipeRun());
        return scp;
    }

    private PipeControlPoint insertStraight(PipeControlPoint pcp, PipeControlPoint.Direction direction, Vector3d pos, double length) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.insertStraight() " + String.valueOf(pcp) + " " + String.valueOf((Object)direction) + " " + String.valueOf(pos));
        }
        InlineComponent component = ComponentUtils.createStraight((P3DRootNode)pcp.getRootNode());
        PipeControlPoint scp = component.getControlPoint();
        if (pcp.isDualInline() && direction == PipeControlPoint.Direction.NEXT) {
            pcp = pcp.getDualSub();
        }
        String name = pcp.getPipeRun().getUniqueName("Pipe");
        component.setName(name);
        pcp.getPipeRun().addChild(component);
        scp.insert(pcp, direction);
        scp.setWorldPosition(pos);
        scp.setLength(length);
        this.validate(scp.getPipeRun());
        return scp;
    }

    private void updatePathLegCurr(PipeControlPoint start, PipeControlPoint updated, PathLegUpdateType lengthChange) throws Exception {
        UpdateStruct2 us = PipingRules.createUS(start, null, 0, new ArrayList<ExpandIterInfo>(), updated);
        if (us == null) {
            LOGGER.trace("Null update struct " + String.valueOf(start));
            return;
        }
        this.updatePathLeg(us, lengthChange);
    }

    private void updatePathLegNext(PipeControlPoint start, PipeControlPoint updated, PathLegUpdateType lengthChange) throws Exception {
        UpdateStruct2 us = PipingRules.createUS(start, PipeControlPoint.Direction.NEXT, 0, new ArrayList<ExpandIterInfo>(), updated);
        if (us == null) {
            LOGGER.trace("Null update struct " + String.valueOf(start));
            return;
        }
        this.updatePathLeg(us, lengthChange);
    }

    private void updatePathLegPrev(PipeControlPoint start, PipeControlPoint updated, PathLegUpdateType lengthChange) throws Exception {
        UpdateStruct2 us = PipingRules.createUS(start, PipeControlPoint.Direction.PREVIOUS, 0, new ArrayList<ExpandIterInfo>(), updated);
        if (us == null) {
            LOGGER.trace("Null update struct " + String.valueOf(start));
            return;
        }
        this.updatePathLeg(us, lengthChange);
    }

    public static boolean calculateDirectedOffset(Vector3d startPoint, Vector3d endPoint, PipeControlPoint start, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d dir, Vector3d leg, Vector3d offset) {
        return PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, leg, offset, true);
    }

    public static boolean calculateOffset(Vector3d startPoint, Vector3d endPoint, PipeControlPoint start, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d dir, Vector3d leg, Vector3d offset) {
        return PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, leg, offset, false);
    }

    private static boolean calculateOffset(Vector3d startPoint, Vector3d endPoint, PipeControlPoint start, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d dir, Vector3d leg, Vector3d offset, boolean directed) {
        double l;
        List<PipeControlPoint> offsets = PipingRules.getOffsetPoints(start, list);
        if (!directed) {
            dir.set((Tuple3d)endPoint);
            dir.sub((Tuple3d)startPoint);
            double l2 = dir.lengthSquared();
            if (l2 > MathTools.NEAR_ZERO) {
                dir.scale(1.0 / Math.sqrt(l2));
            } else if (start.isDirected()) {
                dir = start.getDirectedControlPointDirection();
            } else if (end.isDirected()) {
                dir = end.getDirectedControlPointDirection();
                dir.negate();
            } else {
                offset.set(0.0, 0.0, 0.0);
                leg.set((Tuple3d)dir);
                return offsets.size() > 0;
            }
        }
        if (offsets.size() == 0) {
            offset.set(0.0, 0.0, 0.0);
            leg.set((Tuple3d)dir);
            return false;
        }
        Vector3d sp = new Vector3d(startPoint);
        Point3d ep = new Point3d((Tuple3d)endPoint);
        if (!directed) {
            dir.set((Tuple3d)ep);
            dir.sub((Tuple3d)sp);
        }
        if (!((l = dir.lengthSquared()) > MathTools.NEAR_ZERO)) {
            leg.set((Tuple3d)dir);
            return true;
        }
        dir.scale(1.0 / Math.sqrt(l));
        leg.set((Tuple3d)dir);
        int iter = 100;
        while (true) {
            --iter;
            offset.set(0.0, 0.0, 0.0);
            for (PipeControlPoint icp : offsets) {
                Vector3d v = icp.getSizeChangeOffsetVector(dir, leg);
                offset.add((Tuple3d)v);
            }
            if (directed) break;
            Point3d nep = new Point3d((Tuple3d)endPoint);
            nep.sub((Tuple3d)offset);
            if (nep.distance(ep) < 1.0E-10 || iter <= 0) break;
            ep = nep;
            dir.set((Tuple3d)ep);
            dir.sub((Tuple3d)sp);
            l = dir.lengthSquared();
            if (!(l > MathTools.NEAR_ZERO)) continue;
            dir.scale(1.0 / Math.sqrt(l));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("calcOffset s:" + String.valueOf(startPoint) + " e:" + String.valueOf(endPoint) + " d:" + String.valueOf(dir) + " o:" + String.valueOf(offset));
        }
        return true;
    }

    public static void setZeroOffset(Vector3d startPoint, Vector3d endPoint, Vector3d dir, Vector3d offset) {
        dir.set((Tuple3d)endPoint);
        dir.sub((Tuple3d)startPoint);
        double l = dir.lengthSquared();
        if (l > MathTools.NEAR_ZERO) {
            dir.scale(1.0 / Math.sqrt(l));
        }
        offset.set(0.0, 0.0, 0.0);
    }

    public static List<PipeControlPoint> getOffsetPoints(PipeControlPoint start, ArrayList<PipeControlPoint> list) {
        ArrayList<PipeControlPoint> offsets = new ArrayList<PipeControlPoint>(list.size());
        if (start.isOffset()) {
            offsets.add(start);
        }
        for (PipeControlPoint icp : list) {
            if (icp.isOffset()) {
                offsets.add(icp);
                continue;
            }
            if (!icp.isDualSub()) continue;
            ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + String.valueOf(icp)), (Throwable)new Exception("ASSERT!"));
        }
        return offsets;
    }

    private static UpdateStruct2 createUS(PipeControlPoint start, PipeControlPoint.Direction direction, int iter, ArrayList<ExpandIterInfo> toRemove, PipeControlPoint updated) {
        ArrayList<PipeControlPoint> list = new ArrayList<PipeControlPoint>();
        PipeControlPoint end = null;
        if (direction == null || direction == PipeControlPoint.Direction.NEXT) {
            end = start.findNextEnd(list);
        } else {
            ArrayList<PipeControlPoint> prevList = new ArrayList<PipeControlPoint>();
            PipeControlPoint tend = start.findPreviousEnd(prevList);
            for (PipeControlPoint icp : prevList) {
                if (icp.isDualSub()) {
                    list.add(0, icp.getParentPoint());
                    continue;
                }
                list.add(0, icp);
            }
            end = start;
            start = tend;
        }
        if (start == end) {
            return null;
        }
        boolean hasOffsets = false;
        Vector3d offset = new Vector3d();
        Vector3d startPoint = start.getWorldPosition();
        Vector3d endPoint = end.getWorldPosition();
        Vector3d dir = new Vector3d();
        Vector3d leg = new Vector3d();
        hasOffsets = PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, leg, offset);
        return new UpdateStruct2(start, startPoint, list, end, endPoint, dir, leg, offset, hasOffsets, iter, direction, toRemove, updated);
    }

    private static void refreshUS(UpdateStruct2 us) {
        boolean hasOffsets;
        Vector3d offset = new Vector3d();
        Vector3d startPoint = us.start.getWorldPosition();
        Vector3d endPoint = us.end.getWorldPosition();
        Vector3d dir = new Vector3d();
        Vector3d leg = new Vector3d();
        us.hasOffsets = hasOffsets = PipingRules.calculateOffset(startPoint, endPoint, us.start, us.list, us.end, dir, leg, offset);
        us.dir = dir;
        us.leg = leg;
        us.offset = offset;
    }

    private static Vector3d pathLegDirection(PipeControlPoint start) {
        ArrayList<PipeControlPoint> list = new ArrayList<PipeControlPoint>();
        PipeControlPoint end = start.findNextEnd(list);
        if (start == end) {
            return start.getDirection(PipeControlPoint.Direction.NEXT);
        }
        Vector3d offset = new Vector3d();
        Vector3d startPoint = start.getWorldPosition();
        Vector3d endPoint = end.getWorldPosition();
        Vector3d dir = new Vector3d();
        Vector3d leg = new Vector3d();
        PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, leg, offset);
        return dir;
    }

    private static boolean asDirected(PipeControlPoint pcp, PipeControlPoint.Direction direction) {
        if (pcp.isDirected()) {
            return true;
        }
        if (pcp.asFixedAngle()) {
            if (!pcp._getReversed()) {
                return direction == PipeControlPoint.Direction.NEXT;
            }
            return direction == PipeControlPoint.Direction.PREVIOUS;
        }
        return false;
    }

    private static Vector3d direction(PipeControlPoint pcp, PipeControlPoint.Direction direction) {
        return pcp.getDirection(direction);
    }

    private void updatePathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        boolean rs = true;
        boolean re = true;
        if (lengthChange == PathLegUpdateType.NONE) {
            rs = false;
            re = false;
        }
        this.updatePathLeg(u, lengthChange, rs, re);
    }

    private void updatePathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange, boolean rs, boolean re) throws Exception {
        int directed = 0;
        if (PipingRules.asDirected(u.start, PipeControlPoint.Direction.NEXT)) {
            ++directed;
        }
        if (PipingRules.asDirected(u.end, PipeControlPoint.Direction.PREVIOUS)) {
            ++directed;
        }
        if (rs) {
            PipingRules.setErrorForce(u.start, null);
        }
        if (re) {
            PipingRules.setErrorForce(u.end, null);
        }
        for (PipeControlPoint pcp : u.list) {
            PipingRules.setErrorForce(pcp, null);
        }
        switch (directed) {
            case 0: {
                this.updateFreePathLeg(u, lengthChange);
                break;
            }
            case 1: {
                this.updateDirectedPathLeg(u, lengthChange);
                break;
            }
            case 2: {
                this.updateDualDirectedPathLeg(u, lengthChange);
            }
        }
    }

    private void updateFreePathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateFreePipeRun " + String.valueOf(u) + " " + String.valueOf((Object)lengthChange));
        }
        this.checkExpandPathLeg(u, lengthChange);
        if (u.start.isInline() || u.end.isInline() || u.start.asFixedAngle() || u.end.asFixedAngle()) {
            this.processPathLeg(u, true, false);
        }
    }

    private void updateInlineControlPoints(UpdateStruct2 u, boolean checkSizes) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateInlineControlPoints() " + checkSizes + " " + String.valueOf(u));
        }
        Vector3d start = new Vector3d(u.startPoint);
        Vector3d end = new Vector3d(u.endPoint);
        if (checkSizes) {
            if (u.start.isTurn()) {
                MathTools.mad((Tuple3d)start, (Tuple3d)u.dir, (double)u.start.getInlineLength());
            }
            if (u.end.isTurn()) {
                MathTools.mad((Tuple3d)end, (Tuple3d)u.dir, (double)(-u.end.getInlineLength()));
            }
        }
        boolean recalcline = false;
        Vector3d sp = new Vector3d(start);
        Vector3d ep = new Vector3d(end);
        ep.sub((Tuple3d)u.offset);
        if (u.start.isOffset()) {
            Vector3d offset = u.start.getSizeChangeOffsetVector(u.dir, u.leg);
            PipingRules.updateOffsetPoint(u.start, offset);
            sp.add((Tuple3d)offset);
            ep.add((Tuple3d)offset);
        }
        for (PipeControlPoint icp : u.list) {
            if (icp.isRemoved()) continue;
            PipingRules.updateInlineControlPoint(icp, sp, ep, u.dir, u.leg);
            if (!icp.isOffset()) continue;
            Vector3d offset = icp.getSizeChangeOffsetVector(u.dir, u.leg);
            PipingRules.updateOffsetPoint(icp, offset);
            sp.add((Tuple3d)offset);
            ep.add((Tuple3d)offset);
        }
        if (!checkSizes) {
            return;
        }
        ArrayList<PipeControlPoint> pathLegPoints = new ArrayList<PipeControlPoint>();
        ArrayList<Pair<PipeControlPoint, Vector3d>> fixedLengthPoints = new ArrayList<Pair<PipeControlPoint, Vector3d>>();
        pathLegPoints.add(u.start);
        fixedLengthPoints.add(new Pair((Object)u.start, (Object)new Vector3d()));
        Vector3d off = new Vector3d();
        for (PipeControlPoint icp : u.list) {
            pathLegPoints.add(icp);
            this.updateBranchControlPointBranches(icp);
            if (icp.isOffset()) {
                fixedLengthPoints.add(new Pair((Object)icp, (Object)new Vector3d(off)));
                Vector3d offset = icp.getSizeChangeOffsetVector(u.dir, u.leg);
                off.add((Tuple3d)offset);
                continue;
            }
            if (icp.isVariableLength()) continue;
            fixedLengthPoints.add(new Pair((Object)icp, (Object)new Vector3d(off)));
        }
        pathLegPoints.add(u.end);
        fixedLengthPoints.add(new Pair((Object)u.end, (Object)new Vector3d(off)));
        sp = new Vector3d(start);
        ep = new Vector3d(end);
        ep.sub((Tuple3d)u.offset);
        PipingRules.updateFixedLengths(fixedLengthPoints, sp, ep, u.dir);
        int i = 0;
        while (i < pathLegPoints.size()) {
            PipeControlPoint next;
            PipeControlPoint icp = (PipeControlPoint)pathLegPoints.get(i);
            PipeControlPoint prev = i > 0 ? (PipeControlPoint)pathLegPoints.get(i - 1) : null;
            PipeControlPoint pipeControlPoint = next = i < pathLegPoints.size() - 1 ? (PipeControlPoint)pathLegPoints.get(i + 1) : null;
            if (prev != null && prev.isDualInline()) {
                prev = prev.getDualSub();
            }
            if (icp.isVariableLength()) {
                if (prev != null && next != null) {
                    recalcline |= this.updateVariableLength(icp, prev, next);
                } else {
                    this.updateVariableLengthEnd(icp, prev != null ? prev : next);
                }
            } else if (prev != null && !prev.isVariableLength()) {
                recalcline |= this.possibleVaribleLengthInsert(icp, prev);
            }
            if (icp.isOffset()) {
                Vector3d offset = icp.getSizeChangeOffsetVector(u.dir, u.leg);
                sp.add((Tuple3d)offset);
                ep.add((Tuple3d)offset);
            }
            ++i;
        }
        if (recalcline) {
            u.list.clear();
            u.start.findNextEnd(u.list);
        }
        if (checkSizes) {
            double pathLegLength;
            sp = new Vector3d(u.startPoint);
            ep = new Vector3d(u.endPoint);
            ep.sub((Tuple3d)u.offset);
            double availableLength = pathLegLength = MathTools.distance((Tuple3d)sp, (Tuple3d)ep);
            if (u.start.isTurn()) {
                availableLength -= u.start.getInlineLength();
            }
            if (u.end.isTurn()) {
                availableLength -= u.end.getInlineLength();
            }
            for (PipeControlPoint pcp : u.list) {
                if (pcp.isVariableLength()) continue;
                availableLength -= pcp.getLength();
            }
            if (availableLength < 0.0) {
                PipingRules.setError(u.start, "Not enough available space");
                PipingRules.setError(u.end, "Not enough available space");
                for (PipeControlPoint pcp : u.list) {
                    PipingRules.setError(pcp, "Not enough available space");
                }
            }
        }
    }

    private static void updateFixedLengths(List<Pair<PipeControlPoint, Vector3d>> fixedLengthPoints, Vector3d s, Vector3d e, Vector3d dir) {
        double totalLength = MathTools.distance((Tuple3d)s, (Tuple3d)e);
        double reservedLength = 0.0;
        ArrayList<Double> distances = new ArrayList<Double>(fixedLengthPoints.size());
        distances.add(0.0);
        int i = 1;
        while (i < fixedLengthPoints.size() - 1) {
            Pair<PipeControlPoint, Vector3d> pcp = fixedLengthPoints.get(i);
            reservedLength += ((PipeControlPoint)pcp.first).getLength();
            Vector3d p = ((PipeControlPoint)pcp.first).getWorldPosition();
            p.sub((Tuple3d)pcp.second);
            double d = MathTools.distance((Tuple3d)s, (Tuple3d)p);
            distances.add(d);
            ++i;
        }
        distances.add(totalLength);
        if (totalLength >= reservedLength) {
            ArrayList<GapObj> gaps = new ArrayList<GapObj>(fixedLengthPoints.size() - 1);
            int overlaps = 0;
            int i2 = 0;
            while (i2 < fixedLengthPoints.size() - 1) {
                Pair<PipeControlPoint, Vector3d> pcp1 = fixedLengthPoints.get(i2);
                Pair<PipeControlPoint, Vector3d> pcp2 = fixedLengthPoints.get(i2 + 1);
                double d1 = (Double)distances.get(i2);
                double d2 = (Double)distances.get(i2 + 1);
                double ld1 = i2 == 0 ? 0.0 : ((PipeControlPoint)pcp1.first).getInlineLength();
                double ld2 = i2 == fixedLengthPoints.size() - 2 ? 0.0 : ((PipeControlPoint)pcp2.first).getInlineLength();
                double e1 = d1 + ld1;
                double s2 = d2 - ld2;
                double diff = s2 - e1;
                GapObj obj = new GapObj();
                obj.pcp1 = pcp1;
                obj.pcp2 = pcp2;
                obj.d = diff;
                if (diff < -MIN_INLINE_LENGTH) {
                    obj.gap = Gap.OVERLAP;
                    ++overlaps;
                } else {
                    obj.gap = diff > MIN_INLINE_LENGTH ? Gap.SPACE : Gap.ATTACHED;
                }
                gaps.add(obj);
                ++i2;
            }
            if (overlaps == 0) {
                return;
            }
            i2 = 0;
            while (i2 < gaps.size()) {
                GapObj gapObj = (GapObj)gaps.get(i2);
                if (gapObj.gap == Gap.OVERLAP) {
                    double curr = gapObj.d;
                    int d = 1;
                    while (d < gaps.size() && curr < -MIN_INLINE_LENGTH) {
                        Vector3d p;
                        Pair<PipeControlPoint, Vector3d> pcp;
                        int j;
                        Vector3d mv;
                        double move;
                        GapObj prev;
                        GapObj next = i2 + d < gaps.size() ? (GapObj)gaps.get(i2 + d) : null;
                        GapObj gapObj2 = prev = i2 - d >= 0 ? (GapObj)gaps.get(i2 - d) : null;
                        if (next != null && next.gap == Gap.SPACE) {
                            move = Math.min(-curr, next.d);
                            curr += move;
                            next.d -= move;
                            if (next.d < MIN_INLINE_LENGTH) {
                                next.gap = Gap.ATTACHED;
                            }
                            mv = new Vector3d(dir);
                            mv.normalize();
                            mv.scale(move);
                            j = i2;
                            while (j < i2 + d) {
                                pcp = ((GapObj)gaps.get((int)j)).pcp2;
                                p = new Vector3d(((PipeControlPoint)pcp.first).getWorldPosition());
                                p.add((Tuple3d)mv);
                                ((PipeControlPoint)pcp.first).setWorldPosition(p);
                                ++j;
                            }
                            continue;
                        }
                        if (prev != null && prev.gap == Gap.SPACE) {
                            move = Math.min(-curr, prev.d);
                            curr += move;
                            prev.d -= move;
                            if (prev.d < MIN_INLINE_LENGTH) {
                                prev.gap = Gap.ATTACHED;
                            }
                            mv = new Vector3d(dir);
                            mv.normalize();
                            mv.scale(-move);
                            j = i2;
                            while (j > i2 - d) {
                                pcp = ((GapObj)gaps.get((int)j)).pcp1;
                                p = new Vector3d(((PipeControlPoint)pcp.first).getWorldPosition());
                                p.add((Tuple3d)mv);
                                ((PipeControlPoint)pcp.first).setWorldPosition(p);
                                --j;
                            }
                            continue;
                        }
                        ++d;
                    }
                }
                ++i2;
            }
        } else {
            i = 1;
            while (i < fixedLengthPoints.size() - 1) {
                Pair<PipeControlPoint, Vector3d> prev = i == 0 ? null : fixedLengthPoints.get(i - 1);
                Pair<PipeControlPoint, Vector3d> curr = fixedLengthPoints.get(i);
                Pair<PipeControlPoint, Vector3d> next = i == fixedLengthPoints.size() - 1 ? null : fixedLengthPoints.get(i + 1);
                PipingRules.updateFixedLength(curr, prev, next, s, e, dir);
                ++i;
            }
        }
    }

    private static void updateFixedLength(Pair<PipeControlPoint, Vector3d> icp, Pair<PipeControlPoint, Vector3d> prev, Pair<PipeControlPoint, Vector3d> next, Vector3d s, Vector3d e, Vector3d dir) {
        if (prev != null) {
            PipingRules.checkOverlap(prev, icp, dir, true);
        }
        if (next != null) {
            PipingRules.checkOverlap(icp, next, dir, true);
        }
    }

    private static boolean checkOverlap(Pair<PipeControlPoint, Vector3d> icp, Pair<PipeControlPoint, Vector3d> icp2, Vector3d dir, boolean se) {
        double r;
        double d;
        Vector3d p1 = ((PipeControlPoint)icp.first).getWorldPosition();
        Vector3d p2 = ((PipeControlPoint)icp2.first).getWorldPosition();
        p1.sub((Tuple3d)icp.second);
        p2.sub((Tuple3d)icp2.second);
        double[] u = new double[1];
        MathTools.closestPointOnStraight((Tuple3d)p2, (Tuple3d)p1, (Vector3d)dir, (double[])u);
        if (u[0] < 0.0) {
            if (!((PipeControlPoint)icp2.first).isDirected()) {
                Vector3d p2n = new Vector3d(p1);
                MathTools.mad((Tuple3d)p2n, (Tuple3d)dir, (double)MIN_INLINE_LENGTH);
                p2.set((Tuple3d)p2n);
                p2n.add((Tuple3d)icp2.second);
                ((PipeControlPoint)icp2.first).setWorldPosition(p2n);
            } else if (!((PipeControlPoint)icp.first).isDirected()) {
                Vector3d p1n = new Vector3d(p2);
                MathTools.mad((Tuple3d)p1n, (Tuple3d)dir, (double)(-MIN_INLINE_LENGTH));
                p1.set((Tuple3d)p1n);
                p1n.add((Tuple3d)icp.second);
                ((PipeControlPoint)icp.first).setWorldPosition(p1n);
            }
        }
        if ((d = MathTools.distance((Tuple3d)p1, (Tuple3d)p2)) - (r = ((PipeControlPoint)icp.first).getInlineLength() + ((PipeControlPoint)icp2.first).getInlineLength()) < -MIN_INLINE_LENGTH) {
            if (se) {
                PipingRules.setError((PipeControlPoint)icp.first, "Overlapping");
                PipingRules.setError((PipeControlPoint)icp2.first, "Overlapping");
            }
            return true;
        }
        return false;
    }

    private static void setErrorForce(PipeControlPoint pcp, String error) {
        PipelineComponent comp = pcp.getPipelineComponent();
        if (comp == null) {
            return;
        }
        comp.setError(error);
    }

    private static void setError(PipeControlPoint pcp, String error) {
        PipelineComponent comp = pcp.getPipelineComponent();
        if (comp == null) {
            return;
        }
        if (comp.getError() != null) {
            return;
        }
        comp.setError(error);
    }

    private boolean updateVariableLength(PipeControlPoint icp, PipeControlPoint prev, PipeControlPoint next) {
        Vector3d prevPos = prev.getWorldPosition();
        Vector3d nextPos = next.getWorldPosition();
        Vector3d dir = new Vector3d(nextPos);
        dir.sub((Tuple3d)prevPos);
        double l = dir.length();
        double l2prev = prev.getInlineLength();
        double l2next = next.getInlineLength();
        double l2 = l2prev + l2next;
        double length = l - l2;
        if (length >= MIN_INLINE_LENGTH) {
            dir.normalize();
            dir.scale(length * 0.5 + l2prev);
            dir.add((Tuple3d)prevPos);
            icp.setWorldPosition(dir);
            icp.setLength(length);
            return false;
        }
        if (icp.isDeletable()) {
            if (!this.allowInsertRemove) {
                icp.setLength(MIN_INLINE_LENGTH);
                PipingRules.setError(icp, "Not enough available space");
                this.triedIR = true;
                return false;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("PipingRules.updateVariableLength removing " + String.valueOf(icp));
            }
            icp._remove();
            return true;
        }
        icp.setLength(MIN_INLINE_LENGTH);
        icp.getPipelineComponent().setError("Not enough available space");
        return false;
    }

    private boolean possibleVaribleLengthInsert(PipeControlPoint icp, PipeControlPoint prev) throws Exception {
        Vector3d currentPos = icp.getWorldPosition();
        Vector3d prevPos = prev.getWorldPosition();
        Vector3d dir = new Vector3d(currentPos);
        dir.sub((Tuple3d)prevPos);
        double l = dir.lengthSquared();
        double l2prev = prev.getInlineLength();
        double l2next = icp.getInlineLength();
        double l2 = l2prev + l2next;
        double l2s = l2 * l2;
        double diff = l - l2s;
        if (diff >= MIN_INLINE_LENGTH) {
            if (this.allowInsertRemove) {
                dir.normalize();
                double length = Math.sqrt(l) - l2;
                dir.scale(length * 0.5 + l2prev);
                dir.add((Tuple3d)prevPos);
                this.insertStraight(prev, icp, dir, length);
                return true;
            }
            this.triedIR = true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVariableLengthEnd(PipeControlPoint icp, PipeControlPoint prev) {
        boolean simple;
        Vector3d currentPos = icp.getWorldPosition();
        Vector3d prevPos = prev.getWorldPosition();
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)currentPos, (Tuple3d)prevPos);
        Object object = this.ruleMutex;
        synchronized (object) {
            simple = this.currentUpdates.contains(icp);
        }
        if (simple) {
            double currentLength = (dir.length() - prev.getInlineLength()) * 2.0;
            icp.setLength(currentLength);
        } else {
            double currentLength = icp.getLength();
            if (currentLength < MathTools.NEAR_ZERO) {
                currentLength = (dir.length() - prev.getInlineLength()) * 2.0;
            }
            if (dir.lengthSquared() > MathTools.NEAR_ZERO) {
                dir.normalize();
            }
            Point3d endPos = new Point3d((Tuple3d)dir);
            endPos.scale(currentLength * 0.5);
            endPos.add((Tuple3d)currentPos);
            double offset = prev.getInlineLength();
            Point3d beginPos = new Point3d((Tuple3d)dir);
            beginPos.scale(offset);
            beginPos.add((Tuple3d)prevPos);
            double l = beginPos.distance(endPos);
            if (Double.isNaN(l)) {
                LOGGER.debug("Length for " + String.valueOf(icp) + " is NaN");
            }
            dir.scale(l * 0.5);
            beginPos.add((Tuple3d)dir);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("PipingRules.updateInlineControlPoints() setting variable length to " + l);
            }
            icp.setLength(l);
            icp.setWorldPosition(new Vector3d((Tuple3d)beginPos));
        }
    }

    private void ppNoOffset(UpdateStruct2 u, boolean updateEnds) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.ppNoOffset() " + String.valueOf(u));
        }
        Vector3d offset = new Vector3d();
        if (u.hasOffsets) {
            for (PipeControlPoint icp : u.list) {
                if (icp.isOffset()) {
                    offset.add((Tuple3d)icp.getSizeChangeOffsetVector(u.dir, u.leg));
                    continue;
                }
                if (!icp.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + String.valueOf(icp)), (Throwable)new Exception("ASSERT!"));
            }
        }
        u.offset = offset;
        this.checkExpandPathLeg(u, PathLegUpdateType.NONE, updateEnds);
    }

    private void ppNoDir(PipeControlPoint start, Vector3d startPoint, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d endPoint, boolean hasOffsets, int iter, PipeControlPoint.Direction direction, ArrayList<ExpandIterInfo> toRemove, PipeControlPoint updated) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.ppNoDir() " + String.valueOf(start) + " " + String.valueOf(end) + " " + iter + " " + toRemove.size());
        }
        Vector3d dir = new Vector3d();
        Vector3d leg = new Vector3d();
        Vector3d offset = new Vector3d();
        hasOffsets = PipingRules.calculateOffset(startPoint, endPoint, start, list, end, dir, leg, offset);
        this.ppNoOffset(new UpdateStruct2(start, startPoint, list, end, endPoint, dir, leg, null, hasOffsets, iter, direction, toRemove, updated), true);
    }

    private void checkExpandPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        this.checkExpandPathLeg(u, lengthChange, u.updated.isInline() && u.updated.isOffset());
    }

    private void checkExpandPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange, boolean updateEnds) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.checkExpandPathLeg() " + String.valueOf(u) + " " + String.valueOf((Object)lengthChange));
        }
        if (lengthChange != PathLegUpdateType.NONE) {
            this.processPathLeg(u, updateEnds, false);
            int type = this.checkTurns(u, lengthChange);
            PipingRules.refreshUS(u);
            if (type == 0) {
                this.processPathLeg(u, updateEnds, true);
            } else {
                this.expandPathLeg(u, type);
            }
        } else {
            this.processPathLeg(u, updateEnds, true);
        }
    }

    private void updateDirectedPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        double tr;
        Vector3d position;
        PipeControlPoint other;
        PipeControlPoint dcp;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateDirectedPipeRun() " + String.valueOf(u) + " " + String.valueOf((Object)lengthChange));
        }
        boolean canMoveOther = false;
        boolean dcpStart = false;
        boolean inlineEnd = false;
        if (PipingRules.asDirected(u.start, PipeControlPoint.Direction.NEXT)) {
            dcp = u.start;
            other = u.end;
            position = u.startPoint;
            dcpStart = true;
            if (u.direction == null || u.direction == PipeControlPoint.Direction.NEXT) {
                canMoveOther = true;
            }
            inlineEnd = u.end.isInline();
        } else {
            dcp = u.end;
            other = u.start;
            position = u.endPoint;
            if (u.direction == null || u.direction == PipeControlPoint.Direction.PREVIOUS) {
                canMoveOther = true;
            }
            inlineEnd = u.start.isInline();
        }
        Vector3d directedDirection = PipingRules.direction(dcp, dcpStart ? PipeControlPoint.Direction.NEXT : PipeControlPoint.Direction.PREVIOUS);
        if (directedDirection == null) {
            PipingRules.updateTurnControlPointTurn(dcp, null, null);
            directedDirection = PipingRules.direction(dcp, dcpStart ? PipeControlPoint.Direction.NEXT : PipeControlPoint.Direction.PREVIOUS);
            if (directedDirection == null) {
                return;
            }
        }
        Point3d otherPosition = new Point3d((Tuple3d)(dcpStart ? u.endPoint : u.startPoint));
        double[] mu = new double[2];
        Vector3d closest = MathTools.closestPointOnStraight((Tuple3d)otherPosition, (Tuple3d)position, (Vector3d)directedDirection, (double[])mu);
        Vector3d offset = new Vector3d();
        if (u.hasOffsets) {
            Vector3d dir = new Vector3d(directedDirection);
            if (!dcpStart) {
                dir.negate();
            }
            Vector3d leg = new Vector3d();
            PipingRules.calculateDirectedOffset(u.startPoint, u.endPoint, u.start, u.list, u.end, dir, leg, offset);
            u.dir = dir;
            u.offset = offset;
            u.leg = leg;
            if (dcpStart) {
                closest.add((Tuple3d)offset);
            } else {
                closest.sub((Tuple3d)offset);
            }
        }
        Vector3d t = new Vector3d();
        t.sub((Tuple3d)closest, (Tuple3d)otherPosition);
        double distance = t.length();
        boolean aligned = distance < ALLOWED_OFFSET;
        double requiredSpace = 0.0;
        if (other.isVariableAngle() && (requiredSpace = PipingRules.spaceForTurn(other, dcp)) > (tr = ((TurnComponent)other.getPipelineComponent()).getTurnRadius().doubleValue()) * 5.0) {
            requiredSpace = 0.0;
        }
        if (mu[0] < requiredSpace) {
            aligned = false;
            canMoveOther = true;
        }
        if (aligned) {
            this.checkExpandPathLeg(u, lengthChange, inlineEnd || u.start.isInline() || u.end.isInline() || u.start.asFixedAngle() || u.end.asFixedAngle());
        } else if (u.iter > 0) {
            this.backIter(u);
        } else {
            PipeControlPoint nextToDcp = u.list.size() > 0 ? (dcpStart ? u.list.get(0) : u.list.get(u.list.size() - 1)) : (dcpStart ? u.end : u.start);
            if (other.isVariableAngle()) {
                boolean recalc = false;
                if (mu[0] < requiredSpace) {
                    if (dcpStart) {
                        closest.set((Tuple3d)u.startPoint);
                    } else {
                        closest.set((Tuple3d)u.endPoint);
                    }
                    Vector3d v = new Vector3d(directedDirection);
                    v.scale(requiredSpace);
                    closest.add((Tuple3d)v);
                    recalc = true;
                }
                if (canMoveOther) {
                    if (u.hasOffsets && recalc) {
                        offset = new Vector3d();
                        Vector3d newDir = new Vector3d(directedDirection);
                        Vector3d newLeg = new Vector3d();
                        if (!dcpStart) {
                            newDir.negate();
                        }
                        PipingRules.calculateDirectedOffset(position, closest, u.start, u.list, u.end, newDir, newLeg, offset);
                        if (dcpStart) {
                            closest.add((Tuple3d)offset);
                        } else {
                            closest.sub((Tuple3d)offset);
                        }
                    }
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("PipingRules.updateDirectedPipeRun() moved end " + String.valueOf(other) + " to " + String.valueOf(closest));
                    }
                    other.setWorldPosition(closest);
                    if (dcpStart) {
                        leg = new Vector3d();
                        leg.sub((Tuple3d)closest, (Tuple3d)u.startPoint);
                        if (leg.lengthSquared() > MathTools.NEAR_ZERO) {
                            leg.normalize();
                        }
                        this.checkExpandPathLeg(new UpdateStruct2(u.start, u.startPoint, u.list, u.end, new Vector3d(closest), directedDirection, leg, offset, u.hasOffsets, u.iter, u.direction, u.toRemove, u.updated), PathLegUpdateType.NONE, true);
                        if (u.end.getNext() != null && lengthChange == PathLegUpdateType.NEXT || lengthChange == PathLegUpdateType.NEXT_S) {
                            this.updatePathLegNext(u.end, u.updated, PathLegUpdateType.NEXT);
                        }
                    } else {
                        leg = new Vector3d();
                        leg.sub((Tuple3d)u.endPoint, (Tuple3d)closest);
                        if (leg.lengthSquared() > MathTools.NEAR_ZERO) {
                            leg.normalize();
                        }
                        Vector3d dir = new Vector3d(directedDirection);
                        dir.negate();
                        this.checkExpandPathLeg(new UpdateStruct2(u.start, new Vector3d(closest), u.list, u.end, u.endPoint, dir, leg, offset, u.hasOffsets, u.iter, u.direction, u.toRemove, u.updated), PathLegUpdateType.NONE, true);
                        if (u.start.getPrevious() != null && lengthChange == PathLegUpdateType.PREV || lengthChange == PathLegUpdateType.PREV_S) {
                            this.updatePathLegPrev(u.start, u.updated, PathLegUpdateType.PREV);
                        }
                    }
                } else if (this.allowInsertRemove) {
                    this.insertElbowUpdate(u, dcp, nextToDcp, dcpStart, position, directedDirection);
                } else {
                    this.triedIR = true;
                }
            } else if (other.isNonDirected() && other.getParentPoint() != null) {
                Vector3d bintersect = new Vector3d();
                PipeControlPoint bcp = other.getParentPoint();
                if (bcp == null || !canMoveOther) {
                    throw new UnsupportedOperationException("not implemented");
                }
                Point3d bstart = new Point3d();
                Point3d bend = new Point3d();
                Vector3d bdir = new Vector3d();
                bcp.getInlineControlPointEnds((Tuple3d)bstart, (Tuple3d)bend, bdir);
                Vector3d nintersect = new Vector3d();
                MathTools.intersectStraightStraight((Tuple3d)position, (Vector3d)directedDirection, (Tuple3d)bend, (Vector3d)bdir, (Tuple3d)nintersect, (Tuple3d)bintersect, (double[])mu);
                Vector3d dist = new Vector3d(nintersect);
                dist.sub((Tuple3d)bintersect);
                canMoveOther = mu[1] > 0.0 && mu[1] < 1.0 && dist.lengthSquared() < 0.01;
                if (canMoveOther) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("PipingRules.updateDirectedPipeRun() moved end " + String.valueOf(other) + " to " + String.valueOf(bintersect));
                    }
                    bcp.setWorldPosition(bintersect);
                    if (dcpStart) {
                        leg = new Vector3d();
                        leg.sub((Tuple3d)bintersect, (Tuple3d)u.startPoint);
                        if (leg.lengthSquared() > MathTools.NEAR_ZERO) {
                            leg.normalize();
                        }
                        this.checkExpandPathLeg(new UpdateStruct2(u.start, u.startPoint, u.list, u.end, new Vector3d(bintersect), directedDirection, leg, u.offset, u.hasOffsets, u.iter, u.direction, u.toRemove, u.updated), lengthChange);
                    } else {
                        leg = new Vector3d();
                        leg.sub((Tuple3d)u.endPoint, (Tuple3d)bintersect);
                        if (leg.lengthSquared() > MathTools.NEAR_ZERO) {
                            leg.normalize();
                        }
                        Vector3d dir = new Vector3d(directedDirection);
                        dir.negate();
                        this.checkExpandPathLeg(new UpdateStruct2(u.start, new Vector3d(bintersect), u.list, u.end, u.endPoint, dir, leg, u.offset, u.hasOffsets, u.iter, u.direction, u.toRemove, u.updated), lengthChange);
                    }
                } else if (this.allowInsertRemove) {
                    this.insertElbowUpdate(u, dcp, nextToDcp, dcpStart, position, directedDirection);
                } else {
                    this.triedIR = true;
                }
            } else if (this.allowInsertRemove) {
                this.insertElbowUpdate(u, dcp, nextToDcp, dcpStart, position, directedDirection);
            } else {
                this.triedIR = true;
            }
        }
    }

    private void updateDualDirectedPathLeg(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        boolean aligned;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateDualDirectedPipeRun() " + String.valueOf(u) + " " + String.valueOf((Object)lengthChange));
        }
        PipeControlPoint dcp1 = u.start;
        PipeControlPoint dcp2 = u.end;
        Point3d position1 = new Point3d((Tuple3d)u.startPoint);
        Point3d position2 = new Point3d((Tuple3d)u.endPoint);
        Vector3d dir = u.start.getDirection(PipeControlPoint.Direction.NEXT);
        Vector3d offset = new Vector3d();
        Vector3d leg = new Vector3d();
        leg.sub((Tuple3d)position2, (Tuple3d)position1);
        if (leg.lengthSquared() > MathTools.NEAR_ZERO) {
            leg.normalize();
        }
        if (dir != null) {
            PipingRules.calculateDirectedOffset(new Vector3d((Tuple3d)position1), new Vector3d((Tuple3d)position2), u.start, u.list, u.end, dir, leg, offset);
        }
        Point3d position1offset = new Point3d(position1);
        position1offset.add((Tuple3d)offset);
        Point3d position2offset = new Point3d(position2);
        position2offset.sub((Tuple3d)offset);
        Vector3d dir1 = PipingRules.direction(dcp1, PipeControlPoint.Direction.NEXT);
        Vector3d dir2 = PipingRules.direction(dcp2, PipeControlPoint.Direction.PREVIOUS);
        Vector3d p1 = MathTools.closestPointOnStraight((Tuple3d)position1, (Tuple3d)position2offset, (Vector3d)dir2);
        Vector3d p2 = MathTools.closestPointOnStraight((Tuple3d)position2, (Tuple3d)position1offset, (Vector3d)dir1);
        double d1 = position1.distance(new Point3d((Tuple3d)p1));
        double d2 = position2.distance(new Point3d((Tuple3d)p2));
        boolean bl = aligned = d1 < ALLOWED_OFFSET && d2 < ALLOWED_OFFSET;
        if (aligned) {
            this.processPathLeg(u);
        } else if (u.iter > 0) {
            this.backIter(u);
        } else if (this.allowInsertRemove) {
            PipeControlPoint next;
            PipeControlPoint dcp;
            boolean useNext;
            boolean bl2 = useNext = u.direction == null || u.direction == PipeControlPoint.Direction.NEXT;
            if (useNext) {
                dcp = dcp1;
                next = u.list.size() > 0 ? u.list.get(0) : dcp2;
            } else {
                dcp = dcp2;
                next = u.list.size() > 0 ? u.list.get(u.list.size() - 1) : dcp1;
            }
            Point3d i1 = new Point3d();
            Point3d i2 = new Point3d();
            boolean intersect = false;
            double[] mu = new double[2];
            intersect = useNext ? MathTools.intersectStraightStraight((Tuple3d)position1, (Vector3d)dir1, (Tuple3d)position2offset, (Vector3d)dir2, (Tuple3d)i1, (Tuple3d)i2, (double[])mu) : MathTools.intersectStraightStraight((Tuple3d)position1offset, (Vector3d)dir1, (Tuple3d)position2, (Vector3d)dir2, (Tuple3d)i1, (Tuple3d)i2, (double[])mu);
            if (intersect && i1.distance(i2) < ALLOWED_OFFSET && mu[0] > MathTools.NEAR_ZERO && mu[1] > MathTools.NEAR_ZERO) {
                PipeControlPoint tcp1 = this.insertElbow(dcp, next, new Vector3d((Tuple3d)i1));
                this.updatePathLegNext(tcp1, u.updated, PathLegUpdateType.NONE);
                this.updatePathLegPrev(tcp1, u.updated, PathLegUpdateType.NONE);
            } else {
                p1 = dcp.getWorldPosition();
                Vector3d v = new Vector3d();
                if (u.direction == null || u.direction == PipeControlPoint.Direction.NEXT) {
                    v.set((Tuple3d)dir1);
                } else {
                    v.set((Tuple3d)dir2);
                }
                double off = dcp1.getPipeRun().getTurnRadius();
                v.scale(off);
                p1.add((Tuple3d)v);
                p2 = useNext ? MathTools.closestPointOnStraight((Tuple3d)new Point3d((Tuple3d)p1), (Tuple3d)position2offset, (Vector3d)dir2) : MathTools.closestPointOnStraight((Tuple3d)new Point3d((Tuple3d)p1), (Tuple3d)position1offset, (Vector3d)dir1);
                if (MathTools.distance((Tuple3d)p1, (Tuple3d)p2) < off * 2.05) {
                    p2.add((Tuple3d)v);
                }
                PipeControlPoint tcp1 = this.insertElbow(dcp, next, p1);
                PipeControlPoint tcp2 = this.insertElbow(tcp1, next, p2);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("PipingRules.updateDualDirectedPipeRun() created two turns " + String.valueOf(tcp1) + " " + String.valueOf(tcp2));
                }
                if (tcp1.getNext() == tcp2) {
                    this.updatePathLegPrev(tcp1, u.updated, PathLegUpdateType.NONE);
                    this.updatePathLegNext(tcp1, u.updated, PathLegUpdateType.NONE);
                    this.updatePathLegNext(tcp2, u.updated, PathLegUpdateType.NONE);
                } else {
                    this.updatePathLegPrev(tcp2, u.updated, PathLegUpdateType.NONE);
                    this.updatePathLegNext(tcp2, u.updated, PathLegUpdateType.NONE);
                    this.updatePathLegNext(tcp1, u.updated, PathLegUpdateType.NONE);
                }
            }
        } else {
            this.triedIR = true;
        }
    }

    private static double spaceForTurn(PipeControlPoint tcp, PipeControlPoint dcp) {
        Vector3d dir2;
        Vector3d dir;
        double tr = ((TurnComponent)tcp.getPipelineComponent()).getTurnRadius();
        if (dcp == null) {
            return tr;
        }
        PipeControlPoint ne = tcp.findNextEnd();
        PipeControlPoint pe = tcp.findPreviousEnd();
        PipeControlPoint other = null;
        if (dcp == ne) {
            other = pe;
        } else if (dcp == pe) {
            other = ne;
        } else {
            return tr;
        }
        if (other == null || other == tcp) {
            return tr;
        }
        if (dcp.isDirected()) {
            dir = dcp.getDirectedControlPointDirection();
        } else if (dcp == pe) {
            dir = PipingRules.pathLegDirection(dcp);
            dir.negate();
        } else {
            dir = PipingRules.pathLegDirection(dcp);
        }
        if (other == ne) {
            dir2 = PipingRules.pathLegDirection(tcp);
        } else {
            dir2 = PipingRules.pathLegDirection(pe);
            dir2.negate();
        }
        double d = dir.dot(dir2);
        if (d > 0.999999) {
            return 0.0;
        }
        if (d < -0.9) {
            return tr * 2.0;
        }
        double curr = 0.0;
        int iter = 10;
        Vector3d tp0 = tcp.getPosition();
        try {
            Vector3d dp = dcp.getWorldPosition();
            while (iter > 0) {
                Vector3d tp = new Vector3d(dir);
                tp.scaleAdd(curr, (Tuple3d)dp);
                tcp._setPosition(tp);
                if (other == ne) {
                    dir2 = PipingRules.pathLegDirection(tcp);
                } else {
                    dir2 = PipingRules.pathLegDirection(pe);
                    dir2.negate();
                }
                double a = dir.angle(dir2);
                if (Math.PI - a <= MathTools.NEAR_ZERO) {
                    return 0.0;
                }
                double R = tr * Math.tan(a * 0.5);
                if (R <= curr) {
                    break;
                }
                curr = R * 1.00000000001;
                --iter;
            }
        }
        finally {
            tcp._setPosition(tp0);
        }
        return curr;
    }

    private void insertElbowUpdate(UpdateStruct2 u, PipeControlPoint dcp, PipeControlPoint next, boolean dcpStart, Vector3d position, Vector3d directedDirection) throws Exception {
        PipeControlPoint tcp = null;
        Vector3d closest = new Vector3d(directedDirection);
        closest.scaleAdd(dcp.getPipeRun().getTurnRadius(), (Tuple3d)position);
        tcp = dcpStart ? this.insertElbow(dcp, next, closest) : this.insertElbow(next, dcp, closest);
        double s = PipingRules.spaceForTurn(tcp, dcp);
        Vector3d p = new Vector3d(directedDirection);
        p.scaleAdd(s, (Tuple3d)position);
        tcp.setPosition(p);
        closest = p;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateDirectedPipeRun() inserted " + String.valueOf(tcp));
        }
        if (dcpStart) {
            this.ppNoDir(tcp, new Vector3d(closest), u.list, u.end, u.endPoint, u.hasOffsets, u.iter, PipeControlPoint.Direction.NEXT, u.toRemove, u.updated);
            this.processPathLeg(new UpdateStruct2(u.start, u.startPoint, new ArrayList<PipeControlPoint>(), tcp, new Vector3d(closest), directedDirection, new Vector3d(directedDirection), new Vector3d(), false, 0, PipeControlPoint.Direction.NEXT, new ArrayList<ExpandIterInfo>(), u.updated));
        } else {
            this.ppNoDir(u.start, u.startPoint, u.list, tcp, new Vector3d(closest), u.hasOffsets, u.iter, PipeControlPoint.Direction.PREVIOUS, u.toRemove, u.updated);
            directedDirection.negate();
            this.processPathLeg(new UpdateStruct2(tcp, new Vector3d(closest), new ArrayList<PipeControlPoint>(), u.end, u.endPoint, directedDirection, new Vector3d(directedDirection), new Vector3d(), false, 0, PipeControlPoint.Direction.PREVIOUS, new ArrayList<ExpandIterInfo>(), u.updated));
        }
    }

    private int checkTurns(UpdateStruct2 u, PathLegUpdateType lengthChange) throws Exception {
        PipeControlPoint endNext;
        PathLegUpdateType type;
        double a;
        PipeControlPoint startPrev;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.checkTurns() " + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        boolean startRemoved = false;
        boolean endRemoved = false;
        if (u.start.isVariableAngle() && (startPrev = u.start.getPrevious()) != null) {
            a = PipingRules.updateTurnControlPointTurn(u.start, null, u.dir);
            if (a < MIN_TURN_ANGLE && u.start.isDeletable()) {
                startRemoved = true;
            } else if (lengthChange == PathLegUpdateType.PREV || lengthChange == PathLegUpdateType.PREV_S) {
                type = lengthChange == PathLegUpdateType.PREV_S ? PathLegUpdateType.PREV : PathLegUpdateType.NONE;
                this.updatePathLegPrev(u.start, u.start, type);
            }
        }
        if (u.end.isVariableAngle() && (endNext = u.end.getNext()) != null) {
            a = PipingRules.updateTurnControlPointTurn(u.end, null, null);
            if (a < MIN_TURN_ANGLE && u.end.isDeletable()) {
                endRemoved = true;
            } else if (lengthChange == PathLegUpdateType.NEXT || lengthChange == PathLegUpdateType.NEXT_S) {
                type = lengthChange == PathLegUpdateType.NEXT_S ? PathLegUpdateType.NEXT : PathLegUpdateType.NONE;
                this.updatePathLegNext(u.end, u.end, type);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.checkTurns() res " + startRemoved + " " + endRemoved);
        }
        if (!startRemoved && !endRemoved) {
            return 0;
        }
        if (startRemoved && endRemoved) {
            return 3;
        }
        if (startRemoved) {
            return 1;
        }
        return 2;
    }

    private void expandPathLeg(UpdateStruct2 u, int type) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.expandPipeline " + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        ArrayList<PipeControlPoint> newList = new ArrayList<PipeControlPoint>();
        switch (type) {
            case 0: {
                throw new RuntimeException("Error in piping rules");
            }
            case 1: {
                u.toRemove.add(new ExpandIterInfo(u.start, 1));
                u.start = u.start.findPreviousEnd();
                u.startPoint = u.start.getPosition();
                u.start.findNextEnd(newList);
                newList.addAll(u.list);
                u.list = newList;
                break;
            }
            case 2: {
                u.toRemove.add(new ExpandIterInfo(u.end, 2));
                u.end = u.end.findNextEnd(newList);
                u.endPoint = u.end.getPosition();
                u.list.addAll(newList);
                break;
            }
            case 3: {
                u.toRemove.add(new ExpandIterInfo(u.start, u.end));
                u.start = u.start.findPreviousEnd();
                u.startPoint = u.start.getPosition();
                u.start.findNextEnd(newList);
                newList.addAll(u.list);
                u.list = newList;
                newList = new ArrayList();
                u.end = u.end.findNextEnd(newList);
                u.endPoint = u.end.getPosition();
                u.list.addAll(newList);
                break;
            }
            default: {
                throw new RuntimeException("Error in piping rules");
            }
        }
        PipingRules.refreshUS(u);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.expandPipeline expanded " + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        ++u.iter;
        this.updatePathLeg(u, PathLegUpdateType.NONE);
    }

    private void backIter(UpdateStruct2 u) throws Exception {
        PipeControlPoint icp2;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.backIter" + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        if (u.iter == 0) {
            throw new RuntimeException("Error in piping rules");
        }
        ExpandIterInfo info = u.toRemove.get(u.toRemove.size() - 1);
        u.toRemove.remove(u.toRemove.size() - 1);
        if (info.getType() == 1 || info.getType() == 3) {
            while (u.list.size() > 0) {
                icp2 = u.list.get(0);
                if (icp2.getPrevious().equals(info.getStart())) break;
                u.list.remove(icp2);
            }
            u.start = info.getStart();
        }
        if (info.getType() == 2 || info.getType() == 3) {
            while (u.list.size() > 0) {
                icp2 = u.list.get(u.list.size() - 1);
                if (icp2.getNext().equals(info.getEnd())) break;
                u.list.remove(icp2);
            }
            u.end = info.getEnd();
        }
        u.offset = new Vector3d();
        if (u.hasOffsets) {
            u.dir.normalize();
            for (PipeControlPoint icp2 : u.list) {
                if (icp2.isOffset()) {
                    u.offset.add((Tuple3d)icp2.getSizeChangeOffsetVector(u.dir, u.leg));
                    continue;
                }
                if (!icp2.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + String.valueOf(icp2)), (Throwable)new Exception("ASSERT!"));
            }
        }
        this.processPathLeg(u);
    }

    private void processPathLeg(UpdateStruct2 u) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.processPathLeg " + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        this.processPathLeg(u, true, true);
    }

    private void processPathLeg(UpdateStruct2 u, boolean updateEnds, boolean updateInline) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.processPathLeg " + (updateEnds ? "ends " : "") + (updateInline ? "inline " : "") + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        if (u.toRemove.size() > 0) {
            for (ExpandIterInfo info : u.toRemove) {
                if (info.getStart() != null) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("PipingRules.processPathLeg removing start " + String.valueOf(info.getStart()));
                    }
                    info.getStart()._remove();
                }
                if (info.getEnd() == null) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("PipingRules.processPathLeg removing end " + String.valueOf(info.getEnd()));
                }
                info.getEnd()._remove();
            }
            u.list.clear();
            u.start.findNextEnd(u.list);
        }
        this.updateInlineControlPoints(u, false);
        if (updateEnds) {
            if (u.start.isTurn()) {
                PipingRules.updateTurnControlPointTurn(u.start, null, null);
            } else if (u.start.isEnd()) {
                this.updateEndComponentControlPoint(u.start, u.dir);
            } else if (u.start.isInline()) {
                u.start.orientToDirection(u.dir, u.leg);
            }
            if (u.end.isTurn()) {
                PipingRules.updateTurnControlPointTurn(u.end, null, null);
            } else if (u.end.isEnd()) {
                this.updateEndComponentControlPoint(u.end, u.dir);
            } else if (u.end.isInline()) {
                u.end.orientToDirection(u.dir, u.leg);
            }
        } else {
            if (u.start.isEnd()) {
                this.updateEndComponentControlPoint(u.start, u.dir);
            }
            if (u.end.isEnd()) {
                this.updateEndComponentControlPoint(u.end, u.dir);
            }
        }
        if (updateInline) {
            this.updateInlineControlPoints(u, true);
        }
    }

    private void processPathLegNoOffset(UpdateStruct2 u) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.processPathLeg " + String.valueOf(u.start) + " " + String.valueOf(u.end));
        }
        Vector3d offset = new Vector3d();
        if (u.hasOffsets) {
            u.dir.normalize();
            for (PipeControlPoint icp : u.list) {
                if (icp.isOffset()) {
                    offset.add((Tuple3d)icp.getSizeChangeOffsetVector(u.dir, u.leg));
                    continue;
                }
                if (!icp.isDualSub()) continue;
                ErrorLogger.defaultLogError((String)("Updating pipe run, found offset controlpoint " + String.valueOf(icp)), (Throwable)new Exception("ASSERT!"));
            }
        }
        this.processPathLeg(u);
    }

    private static void updateOffsetPoint(PipeControlPoint sccp, Vector3d offset) {
        Vector3d world = sccp.getWorldPosition();
        world.add((Tuple3d)offset);
        PipeControlPoint ocp = sccp.getDualSub();
        ocp.setWorldPosition(world);
    }

    private static void updateInlineControlPoint(PipeControlPoint icp, Vector3d prev, Vector3d next, Vector3d dir, Vector3d leg) {
        boolean canCalc;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateInlineControlPoint() " + String.valueOf(icp));
        }
        Vector3d inlinePoint = icp.getWorldPosition();
        Vector3d prevPoint = new Vector3d(prev);
        Vector3d nextPoint = new Vector3d(next);
        if (!icp.isVariableLength()) {
            MathTools.mad((Tuple3d)prevPoint, (Tuple3d)dir, (double)icp.getInlineLength());
            MathTools.mad((Tuple3d)nextPoint, (Tuple3d)dir, (double)(-icp.getInlineLength()));
            if (MathTools.distance((Tuple3d)prevPoint, (Tuple3d)nextPoint) < ALLOWED_OFFSET) {
                prevPoint = prev;
                nextPoint = next;
            }
        }
        boolean bl = canCalc = MathTools.distance((Tuple3d)prevPoint, (Tuple3d)nextPoint) > ALLOWED_OFFSET;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("InlineControlPoint update " + String.valueOf(icp) + " " + String.valueOf(inlinePoint) + " " + String.valueOf(prevPoint) + " " + String.valueOf(nextPoint));
        }
        Vector3d newInlinePoint = null;
        if (canCalc) {
            boolean branchUpdate = false;
            PipeControlPoint becp = null;
            for (PipeControlPoint pcp : icp.getChildPoints()) {
                if (!pcp.isNonDirected()) continue;
                branchUpdate = true;
                becp = pcp;
                break;
            }
            if (!branchUpdate) {
                newInlinePoint = MathTools.closestPointOnEdge((Vector3d)new Vector3d(inlinePoint), (Vector3d)prevPoint, (Vector3d)nextPoint);
            } else {
                PipeControlPoint p = null;
                if (becp.getNext() != null) {
                    p = becp.findNextEnd();
                } else if (becp.getPrevious() != null) {
                    p = becp.findPreviousEnd();
                }
                if (p == null) {
                    newInlinePoint = MathTools.closestPointOnEdge((Vector3d)new Vector3d(inlinePoint), (Vector3d)prevPoint, (Vector3d)nextPoint);
                } else if (canCalc) {
                    Vector3d branchLegEnd = p.getWorldPosition();
                    Vector3d dir2 = new Vector3d(inlinePoint);
                    dir2.sub((Tuple3d)branchLegEnd);
                    Vector3d dir1 = new Vector3d(nextPoint);
                    dir1.sub((Tuple3d)prevPoint);
                    newInlinePoint = new Vector3d();
                    double[] mu = new double[2];
                    MathTools.intersectStraightStraight((Tuple3d)new Vector3d(prevPoint), (Vector3d)dir1, (Tuple3d)new Vector3d(branchLegEnd), (Vector3d)dir2, (Tuple3d)newInlinePoint, (Tuple3d)new Vector3d(), (double[])mu);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(Double.toString(mu[0]));
                    }
                    if (mu[0] < 0.0) {
                        newInlinePoint = new Vector3d(prevPoint);
                    } else if (mu[0] > 1.0) {
                        newInlinePoint = new Vector3d(nextPoint);
                    }
                }
            }
        } else {
            newInlinePoint = new Vector3d(prevPoint);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(" " + String.valueOf(newInlinePoint));
        }
        icp.setWorldPosition(newInlinePoint);
        icp.orientToDirection(dir, leg);
    }

    private void updateEndComponentControlPoint(PipeControlPoint ecp, Vector3d dir) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateEndComponentControlPoint() " + String.valueOf(ecp));
        }
        if (!ecp.isFixed()) {
            ecp.orientToDirection(dir);
        }
        for (PipeControlPoint pcp : ecp.getChildPoints()) {
            this.updatePathLegEndControlPoint(pcp);
        }
    }

    private void updateBranchControlPointBranches(PipeControlPoint bcp) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PipingRules.updateBranchControlPointBranches() " + String.valueOf(bcp));
        }
        if (bcp.isDualInline()) {
            return;
        }
        List<PipeControlPoint> branches = bcp.getChildPoints();
        if (branches.size() == 0) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("No Branches found");
            }
            return;
        }
        for (PipeControlPoint pcp : branches) {
            this.updatePathLegEndControlPoint(pcp);
        }
    }

    public static double updateTurnControlPointTurn(PipeControlPoint tcp, Vector3d prev, Vector3d next) {
        UpdateStruct2 us;
        if (next == null && (us = PipingRules.createUS(tcp, PipeControlPoint.Direction.NEXT, 0, new ArrayList<ExpandIterInfo>(), tcp)) != null) {
            next = us.dir;
        }
        if (prev == null && (us = PipingRules.createUS(tcp, PipeControlPoint.Direction.PREVIOUS, 0, new ArrayList<ExpandIterInfo>(), tcp)) != null) {
            prev = us.dir;
        }
        if (!tcp.asFixedAngle()) {
            if (next == null || prev == null) {
                if (tcp.getTurnAngle() != null) {
                    return tcp.getTurnAngle();
                }
                return Math.PI;
            }
            boolean isDegenerate = prev.lengthSquared() < MathTools.NEAR_ZERO || next.lengthSquared() < MathTools.NEAR_ZERO;
            double turnAngle = isDegenerate ? 0.0 : prev.angle(next);
            Vector3d turnAxis = new Vector3d();
            turnAxis.cross(prev, next);
            if (turnAxis.lengthSquared() > MathTools.NEAR_ZERO) {
                double elbowRadius = ((TurnComponent)tcp.getPipelineComponent()).getTurnRadius();
                double R = elbowRadius * Math.tan(turnAngle * 0.5);
                turnAxis.normalize();
                tcp.setTurnAngle(turnAngle);
                tcp.setLength(R);
                tcp.setTurnAxis(turnAxis);
            } else {
                turnAngle = 0.0;
                tcp.setTurnAngle(0.0);
                tcp.setLength(0.0);
                tcp.setTurnAxis(new Vector3d(MathTools.Y_AXIS));
            }
            tcp.orientToDirection(prev);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("PipingTools.updateTurnControlPointTurn " + String.valueOf(prev) + " " + String.valueOf(next) + " " + turnAngle + " " + String.valueOf(turnAxis));
            }
            return turnAngle;
        }
        if (prev == null || next == null) {
            if (prev == null) {
                if (!tcp._getReversed()) {
                    tcp.setReversed(true);
                }
            } else if (next == null && tcp._getReversed()) {
                tcp.setReversed(false);
            }
        }
        Vector3d dir = null;
        if (!tcp._getReversed()) {
            dir = prev;
        } else {
            dir = next;
            dir.negate();
        }
        if (dir == null) {
            return Math.PI;
        }
        Quat4d q = tcp.getControlPointOrientationQuat(dir, tcp.getRotationAngle() != null ? tcp.getRotationAngle() : 0.0);
        Vector3d v = new Vector3d();
        MathTools.rotate((Quat4d)q, (Tuple3d)MathTools.Y_AXIS, (Tuple3d)v);
        tcp.setTurnAxis(v);
        tcp.setWorldOrientation(q);
        if (tcp.getTurnAngle() != null) {
            return tcp.getTurnAngle();
        }
        return Math.PI;
    }

    public static List<PipeControlPoint> getControlPoints(PipeRun pipeRun) {
        ArrayList<PipeControlPoint> list = new ArrayList<PipeControlPoint>();
        if (pipeRun.getControlPoints().size() == 0) {
            return list;
        }
        PipeControlPoint pcp = pipeRun.getControlPoints().iterator().next();
        while (pcp.getPrevious() != null) {
            PipeControlPoint prev = pcp.getPrevious();
            if (prev.getPipeRun() != pipeRun && prev.getPipeRun() != null) break;
            pcp = prev;
        }
        if (pcp.isDualSub()) {
            pcp = pcp.getParentPoint();
        }
        list.add(pcp);
        while (pcp.getNext() != null) {
            if ((pcp = pcp.getNext()).getPipeRun() != pipeRun) break;
            list.add(pcp);
        }
        return list;
    }

    public static void reverse(PipeRun pipeRun) {
        List list;
        PipeRun pr;
        List<PipeControlPoint> points;
        PipeControlPoint pcp;
        while ((pcp = (points = PipingRules.getControlPoints(pipeRun)).get(0)).isSizeChange() && pcp.getChildPoints().size() > 0 && (pr = pcp.getPipeRun()) != pipeRun) {
            pipeRun = pr;
        }
        ArrayList<PipeRun> all = new ArrayList<PipeRun>();
        ArrayList<List<PipeControlPoint>> pcps = new ArrayList<List<PipeControlPoint>>();
        while (true) {
            PipeRun pipeRun2;
            all.add(pipeRun);
            List<PipeControlPoint> points2 = PipingRules.getControlPoints(pipeRun);
            pcps.add(points2);
            PipeControlPoint pcp2 = points2.get(points2.size() - 1);
            if (pcp2.getChildPoints().size() <= 0 || pipeRun == (pipeRun2 = pcp2.getChildPoints().get(0).getPipeRun())) break;
            pipeRun = pipeRun2;
        }
        int i = 0;
        while (i < all.size()) {
            PipeRun run = (PipeRun)all.get(i);
            list = (List)pcps.get(i);
            PipingRules._reverse(run, list);
            ++i;
        }
        i = 0;
        while (i < all.size()) {
            boolean last = i == all.size() - 1;
            list = (List)pcps.get(i);
            if (!last) {
                PipeControlPoint next;
                List list2 = (List)pcps.get(i + 1);
                PipeControlPoint prev = (PipeControlPoint)list.get(list.size() - 1);
                if (prev == (next = (PipeControlPoint)list2.get(0))) {
                    InlineComponent ic = (InlineComponent)prev.getPipelineComponent();
                    PipeRun r1 = ic.getPipeRun();
                    PipeRun r2 = ic.getAlternativePipeRun();
                    if (r1 == null || r2 == null) {
                        throw new RuntimeException("Components on PipeRun changes should refer to both PipeRuns");
                    }
                    ic.deattach();
                    r2.addChild(ic);
                    ic.setPipeRun(r2);
                    ic.setAlternativePipeRun(r1);
                } else {
                    throw new RuntimeException("PipeRun changes should contain shared control points");
                }
            }
            ++i;
        }
    }

    private static void _reverse(PipeRun run, List<PipeControlPoint> list) {
        int i;
        if (list.size() > 1) {
            i = 0;
            while (i < list.size()) {
                boolean first = i == 0;
                boolean last = i == list.size() - 1;
                PipeControlPoint current = list.get(i);
                PipeControlPoint currentSub = null;
                if (current.isDualInline()) {
                    currentSub = current.getDualSub();
                }
                if (first) {
                    PipeControlPoint next = list.get(i + 1);
                    if (next.isDualInline()) {
                        next = next.getDualSub();
                    }
                    if (current.getNext() == next) {
                        current.setNext(null);
                    }
                    current.setPrevious(next);
                    if (currentSub != null) {
                        if (currentSub.getNext() == next) {
                            currentSub.setNext(null);
                        }
                        currentSub.setPrevious(next);
                    }
                } else if (last) {
                    prev = list.get(i - 1);
                    if (current.getPrevious() == prev) {
                        current.setPrevious(null);
                    }
                    current.setNext(prev);
                    if (currentSub != null) {
                        if (currentSub.getPrevious() == prev) {
                            currentSub.setPrevious(null);
                        }
                        currentSub.setNext(prev);
                    }
                } else {
                    prev = list.get(i - 1);
                    PipeControlPoint next = list.get(i + 1);
                    if (next.isDualInline()) {
                        next = next.getDualSub();
                    }
                    current.setPrevious(next);
                    current.setNext(prev);
                    if (currentSub != null) {
                        currentSub.setPrevious(next);
                        currentSub.setNext(prev);
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < list.size()) {
            PipeControlPoint current = list.get(i);
            if (current.getPipeRun() == run) {
                if (current.asFixedAngle()) {
                    current.setReversed(!current._getReversed());
                }
                if (current.isInline() && current.isReverse()) {
                    current.setReversed(!current._getReversed());
                }
                if (current.isRotate() && Math.abs(current.getRotationAngle()) > 0.0) {
                    current.setRotationAngle(Math.PI * 2 - current.getRotationAngle());
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(PipeRun pipeRun) {
        if (pipeRun == null) {
            return;
        }
        Object object = this.ruleMutex;
        synchronized (object) {
            Collection<PipeControlPoint> pcps = pipeRun.getControlPoints();
            int count = 0;
            for (PipeControlPoint pcp : pcps) {
                if (pcp.getParentPoint() != null && pcp.getParentPoint().getPipeRun() == pipeRun) continue;
                ++count;
            }
            List<PipeControlPoint> runPcps = PipingRules.getControlPoints(pipeRun);
            if (runPcps.size() != count) {
                LOGGER.debug("Run " + pipeRun.getName() + " contains unconnected control points, found " + runPcps.size() + " connected, " + pcps.size() + " total.");
                for (PipeControlPoint pcp : pcps) {
                    if (runPcps.contains(pcp)) continue;
                    LOGGER.debug("Unconnected " + String.valueOf(pcp) + " " + String.valueOf(pcp.getPipelineComponent()));
                }
            }
            for (PipeControlPoint pcp : pcps) {
                if (pcp.getPipeRun() == null) {
                    LOGGER.debug("PipeRun ref missing " + String.valueOf(pcp) + " " + String.valueOf(pcp.getPipelineComponent()));
                }
                if (pcp.isDirected() || pcp.getNext() != null || pcp.getPrevious() != null) continue;
                LOGGER.debug("Orphan undirected " + String.valueOf(pcp) + " " + String.valueOf(pcp.getPipelineComponent()));
            }
            for (PipeControlPoint pcp : pcps) {
                if (pcp.getParentPoint() != null) continue;
                PipeControlPoint sub = null;
                if (pcp.isDualInline()) {
                    sub = pcp.getDualSub();
                }
                PipeControlPoint next = pcp.getNext();
                PipeControlPoint prev = pcp.getPrevious();
                if (next != null && next.getPrevious() != pcp && next.getPrevious() != sub) {
                    LOGGER.debug("Inconsistency between " + String.valueOf(pcp) + " -> " + String.valueOf(next));
                }
                if (prev == null) continue;
                PipeControlPoint prevParent = null;
                if (prev.isDualSub()) {
                    prevParent = prev.getParentPoint();
                } else if (prev.isDualInline()) {
                    LOGGER.debug("Inconsistency between " + String.valueOf(pcp) + " <-- " + String.valueOf(prev));
                }
                if (prev.getNext() == pcp && (prevParent == null || prevParent.getNext() == pcp)) continue;
                LOGGER.debug("Inconsistency between " + String.valueOf(pcp) + " <-- " + String.valueOf(prev));
            }
        }
    }

    public void splitVariableLengthComponent(PipelineComponent newComponent, InlineComponent splittingComponent, boolean assignPos) throws Exception {
        this.splitVariableLengthComponent(newComponent, splittingComponent, assignPos, true);
    }

    public void splitVariableLengthComponent(PipelineComponent newComponent, InlineComponent splittingComponent, boolean assignPos, boolean runRules) throws Exception {
        Vector3d dir;
        assert (!splittingComponent.getControlPoint().isFixedLength());
        assert (!(newComponent instanceof InlineComponent) || newComponent.getControlPoint().isFixedLength());
        PipeControlPoint newCP = newComponent.getControlPoint();
        PipeControlPoint splittingCP = splittingComponent.getControlPoint();
        PipeControlPoint nextCP = splittingCP.getNext();
        PipeControlPoint prevCP = splittingCP.getPrevious();
        if (nextCP == null && prevCP == null) {
            throw new RuntimeException("VariableLengthComponent " + String.valueOf(splittingComponent) + " is not connected to anything.");
        }
        double newLength = newComponent.getControlPoint().getLength();
        Point3d next = new Point3d();
        Point3d prev = new Point3d();
        splittingCP.getInlineControlPointEnds((Tuple3d)prev, (Tuple3d)next);
        Vector3d newPos = null;
        if (assignPos) {
            newPos = new Vector3d((Tuple3d)prev);
            dir = new Vector3d((Tuple3d)next);
            dir.sub((Tuple3d)prev);
            dir.scale(0.5);
            newPos.add((Tuple3d)dir);
            newComponent.setWorldPosition(newPos);
        } else {
            newPos = newComponent.getWorldPosition();
        }
        dir = new Vector3d((Tuple3d)next);
        dir.sub((Tuple3d)prev);
        dir.normalize();
        dir.scale(newLength * 0.5);
        Point3d vn = new Point3d((Tuple3d)newPos);
        Point3d vp = new Point3d((Tuple3d)newPos);
        vn.add((Tuple3d)dir);
        vp.sub((Tuple3d)dir);
        double ln = vn.distance(next);
        double lp = vp.distance(prev);
        vp.interpolate((Tuple3d)prev, 0.5);
        vn.interpolate((Tuple3d)next, 0.5);
        if (nextCP == null) {
            newCP.insert(splittingCP, PipeControlPoint.Direction.NEXT);
            this.insertStraight(newCP, PipeControlPoint.Direction.NEXT, new Vector3d((Tuple3d)vn), ln);
            splittingCP.setWorldPosition(new Vector3d((Tuple3d)vp));
        } else if (prevCP == null) {
            newCP.insert(splittingCP, PipeControlPoint.Direction.PREVIOUS);
            this.insertStraight(newCP, PipeControlPoint.Direction.PREVIOUS, new Vector3d((Tuple3d)vp), lp);
            splittingCP.setWorldPosition(new Vector3d((Tuple3d)vn));
        } else {
            newCP.insert(splittingCP, nextCP);
            this.insertStraight(newCP, nextCP, new Vector3d((Tuple3d)vn), ln);
            splittingCP.setWorldPosition(new Vector3d((Tuple3d)vp));
        }
        if (runRules) {
            this.positionUpdate(newCP);
        }
    }

    public static void addSizeChange(boolean reversed, PipeRun pipeRun, PipeRun other, InlineComponent reducer, PipeControlPoint previous, PipeControlPoint next) {
        PipeControlPoint pcp = reducer.getControlPoint();
        PipeControlPoint ocp = pcp.getDualSub();
        if (!reversed) {
            String name = pipeRun.getUniqueName("Reducer");
            reducer.setName(name);
            pipeRun.addChild(reducer);
            other.addChild(ocp);
            reducer.setAlternativePipeRun(other);
            previous.setNext(pcp);
            pcp.setPrevious(previous);
            ocp.setPrevious(previous);
            if (next != null) {
                pcp.setNext(next);
                ocp.setNext(next);
                next.setPrevious(ocp);
            }
        } else {
            String name = other.getUniqueName("Reducer");
            reducer.setName(name);
            other.addChild(reducer);
            pipeRun.addChild(ocp);
            reducer.setAlternativePipeRun(pipeRun);
            if (next != null) {
                next.setNext(pcp);
                pcp.setPrevious(next);
                ocp.setPrevious(next);
            }
            pcp.setNext(previous);
            ocp.setNext(previous);
            previous.setPrevious(ocp);
        }
    }

    public static class ExpandIterInfo {
        private PipeControlPoint start;
        private PipeControlPoint end;
        private int type;

        public ExpandIterInfo() {
        }

        public ExpandIterInfo(PipeControlPoint tcp, int type) {
            if (type == 1) {
                this.start = tcp;
            } else {
                this.end = tcp;
            }
            this.type = type;
        }

        public ExpandIterInfo(PipeControlPoint start, PipeControlPoint end) {
            this.start = start;
            this.end = end;
            this.type = 3;
        }

        public PipeControlPoint getEnd() {
            return this.end;
        }

        public void setEnd(PipeControlPoint end) {
            this.end = end;
        }

        public PipeControlPoint getStart() {
            return this.start;
        }

        public void setStart(PipeControlPoint start) {
            this.start = start;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    private static enum Gap {
        ATTACHED,
        OVERLAP,
        SPACE;

    }

    private static class GapObj {
        Gap gap;
        double d;
        Pair<PipeControlPoint, Vector3d> pcp1;
        Pair<PipeControlPoint, Vector3d> pcp2;

        private GapObj() {
        }
    }

    private static enum PathLegUpdateType {
        NONE,
        PREV,
        NEXT,
        PREV_S,
        NEXT_S;

    }

    private static class UpdateStruct2 {
        public PipeControlPoint start;
        public Vector3d startPoint;
        public ArrayList<PipeControlPoint> list;
        public PipeControlPoint end;
        public Vector3d endPoint;
        public Vector3d dir;
        public Vector3d leg;
        public Vector3d offset;
        public boolean hasOffsets;
        public int iter;
        public PipeControlPoint.Direction direction;
        public ArrayList<ExpandIterInfo> toRemove;
        public PipeControlPoint updated;

        public UpdateStruct2(PipeControlPoint start, Vector3d startPoint, ArrayList<PipeControlPoint> list, PipeControlPoint end, Vector3d endPoint, Vector3d dir, Vector3d leg, Vector3d offset, boolean hasOffsets, int iter, PipeControlPoint.Direction direction, ArrayList<ExpandIterInfo> toRemove, PipeControlPoint updated) {
            if (start == null || end == null) {
                throw new NullPointerException();
            }
            this.start = start;
            this.startPoint = startPoint;
            this.list = list;
            this.end = end;
            this.endPoint = endPoint;
            this.dir = dir;
            this.leg = leg;
            this.offset = offset;
            this.hasOffsets = hasOffsets;
            this.iter = iter;
            this.direction = direction;
            this.toRemove = toRemove;
            this.updated = updated;
            if (!(MathTools.isValid((Tuple3d)startPoint) && MathTools.isValid((Tuple3d)endPoint) && MathTools.isValid((Tuple3d)dir))) {
                throw new RuntimeException();
            }
        }

        public String toString() {
            return String.valueOf(this.start) + " " + String.valueOf(this.end) + " " + String.valueOf(this.dir) + " " + this.hasOffsets + " " + String.valueOf(this.offset) + " " + this.iter + " " + this.toRemove.size();
        }
    }
}

