/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetComboPropertyValue;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.PropertyTabBlacklist;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.graph.annotations.GraphType;
import org.simantics.objmap.graph.annotations.RelatedElementsAdd;
import org.simantics.objmap.graph.annotations.RelatedElementsGet;
import org.simantics.objmap.graph.annotations.RelatedElementsRem;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DParentNode;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import vtk.vtkProp3D;
import vtk.vtkRenderer;

@GraphType(value="http://www.simantics.org/Plant3D-0.1/PipeRun")
@PropertyTabBlacklist(value="Transform")
public class PipeRun
extends P3DParentNode<IP3DNode> {
    private double pipeDiameter = 0.1;
    private double pipeThickness = 0.0;
    private double[] turnRadius = new double[]{0.2};
    private int turnRadiusIndex = 0;
    private Double turnRadiusCustom;
    private static String PIPECP = "pipecp";

    @Override
    public void setName(String name) {
        super.setName(name);
        if (PipelineComponent.DEBUG) {
            System.out.println("Create " + this.toDebugString());
        }
    }

    @Override
    public void update(vtkRenderer ren) {
    }

    @Override
    public void visualize(VtkView panel) {
    }

    @Override
    public Collection<vtkProp3D> getActors() {
        return Collections.emptyList();
    }

    @Override
    public void stopVisualize() {
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadius")
    @GetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadius", name="Elbow radius")
    public Double getCustomTurnRadius() {
        return this.turnRadiusCustom;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadius")
    public void setCustomTurnRadius(Double radius) {
        Integer newIndex;
        if (Objects.equals(this.turnRadiusCustom, radius)) {
            return;
        }
        if (radius != null && (newIndex = this._getTurnRadiusIndex(radius)) != null) {
            this.turnRadiusCustom = null;
            this.setTurnRadiusIndex(newIndex);
            return;
        }
        this.turnRadiusCustom = radius;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadius");
    }

    public double getTurnRadius() {
        if (this.turnRadiusCustom != null) {
            return this.turnRadiusCustom;
        }
        if (this.turnRadiusIndex < this.turnRadius.length) {
            return this.turnRadius[this.turnRadiusIndex];
        }
        return this.turnRadius[0];
    }

    protected Integer _getTurnRadiusIndex(double r) {
        int i = 0;
        while (i < this.turnRadius.length) {
            if (this.turnRadius[i] == r) {
                return i;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setTurnRadius(double turnRadius) {
        Integer newIndex = this._getTurnRadiusIndex(turnRadius);
        Integer currIndex = this.turnRadiusIndex;
        Double currCustom = this.turnRadiusCustom;
        if (this.turnRadiusCustom != null) {
            currIndex = null;
        }
        if (newIndex != null) {
            if (this.turnRadiusCustom != null) {
                this.turnRadiusCustom = null;
            } else if (this.turnRadiusIndex == newIndex) {
                return;
            }
            this.turnRadiusIndex = newIndex;
        } else {
            this.turnRadiusCustom = turnRadius;
        }
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadius");
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex");
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray");
        for (PipelineComponent pc : this.getChild()) {
            Double trc;
            void tc;
            PipelineComponent pipelineComponent = pc;
            if (!(pipelineComponent instanceof TurnComponent)) continue;
            TurnComponent cfr_ignored_0 = (TurnComponent)pipelineComponent;
            TurnComponent cfr_ignored_1 = (TurnComponent)pipelineComponent;
            if (currIndex != null) {
                Integer tri = tc.getTurnRadiusIndex();
                if (tri == null || tri.intValue() != currIndex.intValue()) continue;
                if (this.turnRadiusCustom != null) {
                    tc.setTurnRadiusIndex(null);
                    continue;
                }
                if (tc.getTurnRadiusCustom() != null) continue;
                tc.setTurnRadiusIndex(this.turnRadiusIndex);
                continue;
            }
            if (currCustom == null || (trc = tc.getTurnRadiusCustom()) != null && !currCustom.equals(trc)) continue;
            if (this.turnRadiusCustom != null) {
                if (trc != null) {
                    tc.setTurnRadiusCustom(null);
                }
                tc.setTurnRadiusIndex(null);
                continue;
            }
            if (newIndex == null) continue;
            tc.setTurnRadiusIndex(newIndex);
        }
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray")
    @GetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray", name="Elbow radius array")
    public double[] getTurnRadiusArray() {
        return this.turnRadius;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray")
    @SetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray")
    public void setTurnRadiusArray(double[] turnRadiusArray) {
        if (turnRadiusArray == null || turnRadiusArray.length == 0 || Arrays.equals(this.turnRadius, turnRadiusArray)) {
            return;
        }
        this.turnRadius = turnRadiusArray;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray");
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    @GetComboPropertyValue(name="Turn Radius", value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    public Integer getTurnRadiusIndex() {
        return this.turnRadiusIndex;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex")
    public void setTurnRadiusIndex(int turnRadiusIndex) {
        if (Objects.equals(this.turnRadiusIndex, turnRadiusIndex)) {
            return;
        }
        if (turnRadiusIndex >= this.turnRadius.length) {
            return;
        }
        this.turnRadiusIndex = turnRadiusIndex;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadius");
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusIndex");
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasTurnRadiusArray");
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeDiameter")
    @GetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeDiameter", name="Diameter")
    public double getPipeDiameter() {
        return this.pipeDiameter;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeDiameter")
    @SetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeDiameter")
    public void setPipeDiameter(double pipeDiameter) {
        if (this.pipeDiameter == pipeDiameter) {
            return;
        }
        this.pipeDiameter = pipeDiameter;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasPipeDiameter");
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeThickness")
    @GetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeThickness", name="Wall Thickness")
    public double getPipeThickness() {
        return this.pipeThickness;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeThickness")
    @SetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasPipeThickness")
    public void setPipeThickness(double pipeThickness) {
        if (this.pipeThickness == pipeThickness) {
            return;
        }
        this.pipeThickness = pipeThickness;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasPipeThickness");
    }

    public double getInsideDiameter() {
        return this.pipeDiameter - 2.0 * this.pipeThickness;
    }

    @RelatedElementsAdd(value="http://www.simantics.org/Plant3D-0.1/children")
    public void addChild(PipelineComponent node) {
        this.addNode("http://www.simantics.org/Plant3D-0.1/children", (INode)node);
    }

    @RelatedElementsGet(value="http://www.simantics.org/Plant3D-0.1/children")
    public Collection<PipelineComponent> getChild() {
        ArrayList<PipelineComponent> coll = new ArrayList<PipelineComponent>();
        for (IG3DNode n : this.getNodes("http://www.simantics.org/Plant3D-0.1/children")) {
            coll.add((PipelineComponent)n);
        }
        return coll;
    }

    @RelatedElementsRem(value="http://www.simantics.org/Plant3D-0.1/children")
    public void _remChild(PipelineComponent node) {
        this.deattachNode("http://www.simantics.org/Plant3D-0.1/children", (INode)node);
    }

    public void remChild(PipelineComponent node) {
        this.removeNode("http://www.simantics.org/Plant3D-0.1/children", (INode)node);
    }

    public void remove() {
        if (PipelineComponent.DEBUG) {
            System.out.println(this.toDebugString() + " remove");
        }
        Collection<PipelineComponent> comps = this.getChild();
        for (PipelineComponent c : comps) {
            c.deattach();
        }
        Collection<PipeControlPoint> cpcs = this.getControlPoints();
        for (PipeControlPoint pcp : cpcs) {
            pcp.deattach();
        }
        super.remove();
    }

    public List<PipelineComponent> getSortedChild() {
        ArrayList<PipelineComponent> coll = new ArrayList<PipelineComponent>();
        for (IG3DNode n : this.getNodes("http://www.simantics.org/Plant3D-0.1/children")) {
            coll.add((PipelineComponent)n);
        }
        Collections.sort(coll, new ComponentComparator());
        return coll;
    }

    public void addChild(PipeControlPoint node) {
        this.addNode(PIPECP, (INode)node);
    }

    public void remChild(PipeControlPoint node) {
        this.removeNode(PIPECP, (INode)node);
    }

    public void deattachChild(PipeControlPoint node) {
        this.deattachNode(PIPECP, (INode)node);
    }

    public Collection<PipeControlPoint> getControlPoints() {
        ArrayList<PipeControlPoint> coll = new ArrayList<PipeControlPoint>();
        for (IG3DNode n : this.getNodes(PIPECP)) {
            coll.add((PipeControlPoint)n);
        }
        return coll;
    }

    public boolean equalSpecs(PipeRun other) {
        if (!MathTools.equals((double)this.pipeDiameter, (double)other.pipeDiameter)) {
            return false;
        }
        if (this.turnRadius.length != other.turnRadius.length) {
            return false;
        }
        int i = 0;
        while (i < this.turnRadius.length) {
            if (!MathTools.equals((double)this.turnRadius[i], (double)other.turnRadius[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canMerge(PipeRun other) {
        return MathTools.equals((double)this.pipeDiameter, (double)other.pipeDiameter);
    }

    public void merge(PipeRun r2) {
        HashMap<Integer, Integer> turnIndexMap = null;
        if (!this.equalSpecs(r2)) {
            if (!this.canMerge(r2)) {
                throw new IllegalArgumentException("PipeRuns cannot be merged");
            }
            turnIndexMap = new HashMap<Integer, Integer>();
            ArrayList<Double> mergedTurnRadius = new ArrayList<Double>();
            double[] dArray = this.getTurnRadiusArray();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double t = dArray[n2];
                mergedTurnRadius.add(t);
                ++n2;
            }
            int i2 = 0;
            while (i2 < r2.getTurnRadiusArray().length) {
                double t2 = r2.getTurnRadiusArray()[i2];
                boolean found = false;
                int i = 0;
                while (i < mergedTurnRadius.size()) {
                    if (MathTools.equals((double)((Double)mergedTurnRadius.get(i)), (double)t2)) {
                        turnIndexMap.put(i2, i);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    turnIndexMap.put(i2, mergedTurnRadius.size());
                    mergedTurnRadius.add(t2);
                }
                ++i2;
            }
            for (PipeControlPoint pcp : r2.getControlPoints()) {
                PipelineComponent comp = pcp.getPipelineComponent();
                boolean cfr_ignored_0 = comp instanceof TurnComponent;
            }
            if (mergedTurnRadius.size() > this.getTurnRadiusArray().length) {
                double[] arr = new double[mergedTurnRadius.size()];
                int i = 0;
                while (i < mergedTurnRadius.size()) {
                    arr[i] = (Double)mergedTurnRadius.get(i);
                    ++i;
                }
                this.setTurnRadiusArray(arr);
            }
        }
        Collection<PipeControlPoint> pcps = r2.getControlPoints();
        for (PipeControlPoint pcp : pcps) {
            r2.deattachChild(pcp);
            this.addChild(pcp);
            PipelineComponent component = pcp.getPipelineComponent();
            if (component == null) continue;
            if (!(component instanceof Nozzle)) {
                component.deattach();
                this.addChild(component);
                continue;
            }
            Nozzle n = (Nozzle)component;
            n.setPipeRun(this);
        }
        if (turnIndexMap != null) {
            for (PipeControlPoint pcp : pcps) {
                TurnComponent tc;
                PipelineComponent component = pcp.getPipelineComponent();
                if (!(component instanceof TurnComponent) || (tc = (TurnComponent)component).getTurnRadiusIndex() == null || tc.getTurnRadiusIndex() < 0) continue;
                tc.setTurnRadiusIndex((Integer)turnIndexMap.get(tc.getTurnRadiusIndex()));
            }
        }
        r2.remove();
    }

    private class ComponentComparator
    implements Comparator<PipelineComponent> {
        private ComponentComparator() {
        }

        @Override
        public int compare(PipelineComponent o1, PipelineComponent o2) {
            if (o1 == o2) {
                return 0;
            }
            int i = 1;
            PipelineComponent c = o1.getPrevious();
            while (c != null) {
                if (c == o2) {
                    return i;
                }
                c = c.getPrevious();
                ++i;
            }
            i = -1;
            c = o1.getNext();
            while (c != null) {
                if (c == o2) {
                    return i;
                }
                c = c.getNext();
                --i;
            }
            return 0;
        }
    }
}

