/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.ArrayList;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.shape.Tube;
import org.simantics.plant3d.geometry.BuiltinMeshProvider;

public class StraightGeometryProvider
extends BuiltinMeshProvider {
    private double length = 1.0;
    private double radius = 0.01;

    public StraightGeometryProvider(Resource resource) {
        super(resource);
    }

    public Mesh getMesh() {
        if (this.length < 1.0E-4 || this.radius < MathTools.NEAR_ZERO) {
            return null;
        }
        Tube tube = new Tube();
        tube.setResolution(16);
        ArrayList<Point3d> vertices = new ArrayList<Point3d>();
        ArrayList<Double> radius = new ArrayList<Double>();
        ArrayList<Vector3d> tangents = new ArrayList<Vector3d>();
        vertices.add(new Point3d(-this.length * 0.5, 0.0, 0.0));
        vertices.add(new Point3d(this.length * 0.5, 0.0, 0.0));
        radius.add(this.radius);
        radius.add(this.radius);
        tangents.add(new Vector3d(1.0, 0.0, 0.0));
        tangents.add(new Vector3d(1.0, 0.0, 0.0));
        tube.setVertices(vertices);
        tube.setRadiis(radius);
        tube.setTangents(tangents);
        tube.setCap(false);
        return tube.create();
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("length")) {
            this.length = (Double)props.get("length");
        }
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
        if (this.length < 0.0) {
            this.length = 0.0;
        }
        if (this.radius < MathTools.NEAR_ZERO) {
            this.radius = MathTools.NEAR_ZERO;
        }
    }
}

