/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.plant3d.geometry.BuiltinGeometryProvider;

public class NozzleGeometryProvider
extends BuiltinGeometryProvider {
    private double length = 0.1;
    private double radius = 0.01;

    public NozzleGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.radius < MathTools.NEAR_ZERO || this.length < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        TopoDS_Shape shape = OccTriangulator.makeCylinder((double[])new double[]{-this.length, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)this.radius, (double)this.length);
        TopoDS_Shape shape2 = OccTriangulator.makeCylinder((double[])new double[]{-this.length * 0.25, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)(this.radius * 1.2), (double)(this.length * 0.25));
        TopoDS_Shape shape3 = OccTriangulator.makeCompound((TopoDS_Shape[])new TopoDS_Shape[]{shape, shape2});
        shape.delete();
        shape2.delete();
        return Collections.singletonList(shape3);
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("length")) {
            this.length = (Double)props.get("length");
        }
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
    }
}

