/*
 * Decompiled with CFR 0.152.
 */
package org.jcae.opencascade;

import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jcae.opencascade.Utilities;
import org.jcae.opencascade.jni.BRepBndLib;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeVertex;
import org.jcae.opencascade.jni.BRepBuilderAPI_Sewing;
import org.jcae.opencascade.jni.BRepTools;
import org.jcae.opencascade.jni.BRep_Builder;
import org.jcae.opencascade.jni.BRep_Tool;
import org.jcae.opencascade.jni.Bnd_Box;
import org.jcae.opencascade.jni.GeomAPI_ProjectPointOnSurf;
import org.jcae.opencascade.jni.Geom_Surface;
import org.jcae.opencascade.jni.TopAbs_ShapeEnum;
import org.jcae.opencascade.jni.TopExp_Explorer;
import org.jcae.opencascade.jni.TopoDS_Compound;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Iterator;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.jcae.opencascade.jni.TopoDS_Vertex;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Shape<T extends Shape<T>>
implements Comparable<T> {
    private static final Logger LOGGER = Logger.getLogger(Shape.class.getCanonicalName());
    protected static GeomAPI_ProjectPointOnSurf projectPointOnSurf;
    private static final Map<TopAbs_ShapeEnum, String> TYPE_MAP_XML;
    private static final Map<String, TopAbs_ShapeEnum> TYPE_MAP_XML_INV;
    private static final Map<TopAbs_ShapeEnum, String> TYPE_MAP_NAME;
    private static final TopAbs_ShapeEnum[] TYPE;
    private static final String[] TYPE_LABEL;
    protected TopoDS_Shape impl;
    protected T[] children;
    protected T[] parents;
    private static final Factory<ShapeImpl> DEFAULT_FACTORY;

    static {
        HashMap<TopAbs_ShapeEnum, String> m = new HashMap<TopAbs_ShapeEnum, String>();
        HashMap<TopAbs_ShapeEnum, String> mm = new HashMap<TopAbs_ShapeEnum, String>();
        HashMap<String, TopAbs_ShapeEnum> mi = new HashMap<String, TopAbs_ShapeEnum>();
        ListOfShapes[] shapes = ListOfShapes.values();
        TYPE = new TopAbs_ShapeEnum[shapes.length];
        TYPE_LABEL = new String[shapes.length];
        int i = 0;
        ListOfShapes[] listOfShapesArray = shapes;
        int n = shapes.length;
        int n2 = 0;
        while (n2 < n) {
            ListOfShapes s = listOfShapesArray[n2];
            if (s != ListOfShapes.SHAPE) {
                m.put(s.type, s.xmlName);
                mi.put(s.xmlName, s.type);
            }
            mm.put(s.type, s.label);
            Shape.TYPE[i] = s.type;
            Shape.TYPE_LABEL[i] = s.label;
            ++i;
            ++n2;
        }
        TYPE_MAP_XML = Collections.unmodifiableMap(m);
        TYPE_MAP_NAME = Collections.unmodifiableMap(mm);
        TYPE_MAP_XML_INV = Collections.unmodifiableMap(mi);
        DEFAULT_FACTORY = new Factory<ShapeImpl>(){

            public ShapeImpl create(TopoDS_Shape shape, Map<TopoDS_Shape, ShapeImpl> map, ShapeImpl[] parents) {
                return new ShapeImpl(shape, map, parents);
            }

            public ShapeImpl[] createArray(int length) {
                return new ShapeImpl[length];
            }
        };
    }

    protected Shape() {
        this((TopoDS_Shape)null);
    }

    protected Shape(TopoDS_Shape shape) {
        this(shape, new HashMap(), null);
    }

    protected Shape(String fileName) {
        this(Utilities.readFile(fileName));
    }

    protected Shape(TopoDS_Shape shape, Map<TopoDS_Shape, T> map, T[] parents) {
        if (shape == null) {
            TopoDS_Compound c = new TopoDS_Compound();
            new BRep_Builder().makeCompound(c);
            this.impl = c;
        } else {
            this.impl = shape;
        }
        if (parents == null) {
            parents = (Shape[])this.getFactory().createArray(0);
        }
        this.parents = parents;
        int cntChildren = 0;
        TopoDS_Iterator it = new TopoDS_Iterator(this.impl);
        while (it.more()) {
            ++cntChildren;
            it.next();
        }
        this.children = (Shape[])this.getFactory().createArray(cntChildren);
        cntChildren = 0;
        it = new TopoDS_Iterator(this.impl);
        while (it.more()) {
            TopoDS_Shape tds = it.value();
            Shape css = (Shape)map.get(tds);
            if (css == null) {
                Shape[] pArray = (Shape[])this.getFactory().createArray(1);
                pArray[0] = this.getDerived();
                css = this.getFactory().create(tds, map, pArray);
            }
            this.children[cntChildren] = css;
            ++cntChildren;
            it.next();
        }
        map.put(shape, this.getDerived());
    }

    public static String[] getLabels(TopAbs_ShapeEnum from) {
        int startIndex = from.ordinal();
        String[] toReturn = new String[TopAbs_ShapeEnum.values().length - 1 - startIndex];
        System.arraycopy(TYPE_LABEL, startIndex, toReturn, 0, toReturn.length);
        return toReturn;
    }

    protected abstract Factory<T> getFactory();

    protected abstract T getDerived();

    public void add(T newShape) {
        this.impl.free(true);
        new BRep_Builder().add(this.impl, ((Shape)newShape).impl);
        Shape[] nc = (Shape[])this.getFactory().createArray(this.children.length + 1);
        System.arraycopy(this.children, 0, nc, 0, this.children.length);
        nc[nc.length - 1] = newShape;
        this.children = nc;
        Shape[] np = (Shape[])((Shape)newShape).getFactory().createArray(((Shape)newShape).parents.length + 1);
        System.arraycopy(((Shape)newShape).parents, 0, np, 0, np.length - 1);
        np[np.length - 1] = this.getDerived();
        ((Shape)newShape).parents = np;
    }

    public T addVertex(double[] coords) {
        TopoDS_Vertex v = (TopoDS_Vertex)new BRepBuilderAPI_MakeVertex(coords).shape();
        Shape vs = this.getFactory().create(v, new HashMap(), (Shape[])this.getFactory().createArray(0));
        this.add(vs);
        if (this.impl instanceof TopoDS_Face) {
            TopoDS_Face face = (TopoDS_Face)this.impl;
            double[] uvTol = new double[3];
            this.projectPoint(coords, uvTol);
            new BRep_Builder().updateVertex(v, uvTol[0], uvTol[1], face, uvTol[2]);
        }
        return (T)vs;
    }

    public void projectPoint(double[] coords, double[] result) {
        TopoDS_Face face = (TopoDS_Face)this.impl;
        Geom_Surface surface = BRep_Tool.surface(face);
        if (projectPointOnSurf == null) {
            projectPointOnSurf = new GeomAPI_ProjectPointOnSurf(coords, surface);
        } else {
            projectPointOnSurf.init(coords, surface);
        }
        if (projectPointOnSurf.nbPoints() > 0) {
            projectPointOnSurf.lowerDistanceParameters(result);
            double[] p = projectPointOnSurf.nearestPoint();
            result[2] = projectPointOnSurf.lowerDistance();
            System.arraycopy(p, 0, result, 3, 3);
        } else {
            result[2] = Double.POSITIVE_INFINITY;
        }
    }

    public void remove() {
        BRep_Builder bb = new BRep_Builder();
        T shape = this.getDerived();
        T[] TArray = this.parents;
        int n = this.parents.length;
        int n2 = 0;
        while (n2 < n) {
            T parent = TArray[n2];
            ArrayList<Shape> set = new ArrayList<Shape>(Arrays.asList(((Shape)parent).children));
            if (set.contains(shape)) {
                ((Shape)parent).impl.free(true);
                bb.remove(((Shape)parent).impl, this.impl);
                set.remove(shape);
                ((Shape)parent).children = set.toArray((Shape[])this.getFactory().createArray(set.size()));
            }
            ++n2;
        }
        this.parents = (Shape[])this.getFactory().createArray(0);
    }

    public void reverse() {
        Shape[] parentSav = (Shape[])this.parents.clone();
        this.remove();
        this.impl.reverse();
        Shape[] shapeArray = parentSav;
        int n = parentSav.length;
        int n2 = 0;
        while (n2 < n) {
            Shape s = shapeArray[n2];
            s.add(this.getDerived());
            ++n2;
        }
    }

    public T sewed(double tolerance, boolean option, boolean cutting, boolean manifold) {
        BRepBuilderAPI_Sewing sewer = new BRepBuilderAPI_Sewing();
        sewer.init(tolerance, option, cutting, manifold);
        sewer.add(this.impl);
        sewer.perform();
        return (T)this.getFactory().create(sewer.sewedShape(), new HashMap(), (Shape[])this.getFactory().createArray(0));
    }

    public void dump(PrintWriter writer) {
        int[] ids = new int[TopAbs_ShapeEnum.values().length - 1];
        Arrays.fill(ids, 1);
        writer.println("<geometry>");
        this.dump(writer, new HashSet(), ids);
        writer.println("</geometry>");
    }

    protected void dump(PrintWriter writer, Set<T> shapeSet, int[] id) {
        T shape = this.getDerived();
        if (!shapeSet.contains(shape)) {
            int type = this.getType().ordinal();
            shapeSet.add(shape);
            if (this.getAttributes() != null) {
                String e = TYPE_MAP_XML.get((Object)this.impl.shapeType());
                writer.println("<" + e + " id=\"" + id[type] + "\">");
                writer.println(this.getAttributes().toXML());
                writer.println("</" + e + ">");
            }
            int n = type;
            id[n] = id[n] + 1;
            T[] TArray = this.children;
            int n2 = this.children.length;
            int n3 = 0;
            while (n3 < n2) {
                T s = TArray[n3];
                ((Shape)s).dump(writer, shapeSet, id);
                ++n3;
            }
        }
    }

    public void load(Node node) {
        NodeList nodes = node.getChildNodes();
        int i = 0;
        int imax = nodes.getLength();
        while (i < imax) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1) {
                TopAbs_ShapeEnum type = TYPE_MAP_XML_INV.get(n.getNodeName());
                Element e = (Element)n;
                int id = Integer.parseInt(e.getAttribute("id"));
                T s = this.getShapeFromID(id, type);
                if (((Shape)s).getAttributes() == null) {
                    ((Shape)s).createAttributes();
                }
                ((Shape)s).getAttributes().fromXML(e);
            }
            ++i;
        }
    }

    public int getID(T rootShape) {
        int[] ids = new int[1];
        if (this.getID(rootShape, new HashSet(), ids, this.impl.shapeType())) {
            return ids[0];
        }
        return -1;
    }

    public int getID() {
        T r = this.getRootShape();
        int id = this.getID(r);
        if (id < 0) {
            throw new NoSuchElementException("Cannot find " + String.valueOf(this.impl) + " in " + String.valueOf(r));
        }
        return id;
    }

    private boolean getID(T rootShape, Set<T> shapeSet, int[] number, TopAbs_ShapeEnum wantedType) {
        block8: {
            int compare;
            block7: {
                if (shapeSet.contains(rootShape)) {
                    return false;
                }
                shapeSet.add(rootShape);
                compare = ((Shape)rootShape).impl.shapeType().compareTo(wantedType);
                if (compare != 0) break block7;
                number[0] = number[0] + 1;
                if (this.equals(rootShape)) {
                    return true;
                }
                if (!(((Shape)rootShape).impl instanceof TopoDS_Compound)) break block8;
                T[] TArray = ((Shape)rootShape).children;
                int n = ((Shape)rootShape).children.length;
                int n2 = 0;
                while (n2 < n) {
                    T s = TArray[n2];
                    if (((Shape)s).impl instanceof TopoDS_Compound && this.getID(s, shapeSet, number, wantedType)) {
                        return true;
                    }
                    ++n2;
                }
                break block8;
            }
            if (compare < 0) {
                T[] TArray = ((Shape)rootShape).children;
                int n = ((Shape)rootShape).children.length;
                int n3 = 0;
                while (n3 < n) {
                    T s = TArray[n3];
                    if (this.getID(s, shapeSet, number, wantedType)) {
                        return true;
                    }
                    ++n3;
                }
            }
        }
        return false;
    }

    protected T explore(Collection<T> result, TopAbs_ShapeEnum wantedType, int maxsize, TopoDS_Shape shape) {
        if (this.impl.shapeType().equals((Object)wantedType)) {
            result.add(this.getDerived());
            if (result.size() >= maxsize) {
                return this.getDerived();
            }
            if (this.impl.equals(shape)) {
                return this.getDerived();
            }
        }
        T[] TArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            T s = TArray[n2];
            T toReturn = ((Shape)s).explore(result, wantedType, maxsize, shape);
            if (toReturn != null) {
                return toReturn;
            }
            ++n2;
        }
        return null;
    }

    public Collection<T> explore(TopAbs_ShapeEnum type) {
        ArrayList toReturn = new ArrayList();
        this.explore(toReturn, type, Integer.MAX_VALUE, null);
        return toReturn;
    }

    public T getRootShape() {
        T aparent = this.getDerived();
        while (((Shape)aparent).parents.length != 0) {
            aparent = ((Shape)aparent).parents[0];
        }
        return aparent;
    }

    public T getShapeFromID(int id, TopAbs_ShapeEnum type) {
        if (id < 1) {
            throw new IllegalArgumentException("Shape ID must be greater than 1");
        }
        HashSet result = new HashSet();
        Object toReturn = this.explore(result, type, id, null);
        if (toReturn == null) {
            throw new ArrayIndexOutOfBoundsException("This shape contains only " + result.size() + " elements of type " + String.valueOf((Object)type));
        }
        return (T)toReturn;
    }

    public T getShapeFromImpl(TopoDS_Shape shape) {
        AbstractList dummy = new AbstractList<T>(){

            @Override
            public void add(int index, T element) {
            }

            @Override
            public T get(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return 0;
            }
        };
        return this.explore(dummy, shape.shapeType(), Integer.MAX_VALUE, shape);
    }

    public T getCompound() {
        if (this.impl instanceof TopoDS_Compound) {
            return this.getDerived();
        }
        if (this.parents.length > 0) {
            return ((Shape)this.parents[0]).getCompound();
        }
        return null;
    }

    public double getTolerance() {
        return Utilities.tolerance(this.impl);
    }

    public TopAbs_ShapeEnum getType() {
        return this.impl.shapeType();
    }

    public double[] getBounds() {
        Bnd_Box box = new Bnd_Box();
        BRepBndLib.add(this.impl, box);
        return box.get();
    }

    protected Attributes getAttributes() {
        return null;
    }

    protected void createAttributes() {
    }

    public String getName() {
        return TYPE_MAP_NAME.get((Object)this.impl.shapeType());
    }

    public void saveImpl(String fileName) {
        BRepTools.write(this.impl, fileName);
    }

    @Override
    public int compareTo(T o) {
        int r = this.getType().compareTo(((Shape)o).getType());
        if (r == 0) {
            r = this.getID() - ((Shape)o).getID();
        }
        return r;
    }

    private static void dumpTopExp(TopoDS_Shape shape) {
        TopAbs_ShapeEnum[] topAbs_ShapeEnumArray = TopAbs_ShapeEnum.values();
        int n = topAbs_ShapeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            TopAbs_ShapeEnum type = topAbs_ShapeEnumArray[n2];
            if (!type.equals((Object)TopAbs_ShapeEnum.SHAPE)) {
                TopExp_Explorer ex = new TopExp_Explorer(shape, type);
                while (ex.more()) {
                    System.out.println(ex.current());
                    ex.next();
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        try {
            long t1 = System.nanoTime();
            TopoDS_Shape rootShape = Utilities.readFile("/home/jerome/Models/F1.brep");
            long t2 = System.nanoTime();
            LOGGER.info("Time to load brep: " + (double)(t2 - t1) / 1.0E9);
            System.gc();
            LOGGER.info("Used memory :" + (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000.0 + " Mb");
            t1 = System.nanoTime();
            ShapeImpl rootShapeJ = new ShapeImpl(rootShape, (Map<TopoDS_Shape, ShapeImpl>)new HashMap<TopoDS_Shape, ShapeImpl>(), new ShapeImpl[0]);
            t2 = System.nanoTime();
            LOGGER.info("Time to create dual graph: " + (double)(t2 - t1) / 1.0E9);
            System.gc();
            LOGGER.info("Used memory :" + (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000.0 + " Mb");
            LOGGER.info(rootShapeJ.toString());
            t1 = System.nanoTime();
            ShapeImpl s = (ShapeImpl)rootShapeJ.getShapeFromID(330, TopAbs_ShapeEnum.EDGE);
            t2 = System.nanoTime();
            ShapeImpl ss = (ShapeImpl)rootShapeJ.getShapeFromImpl(s.impl);
            long t3 = System.nanoTime();
            int id = ss.getID();
            long t4 = System.nanoTime();
            System.out.println("time for getShapeFromID: " + (double)(t2 - t1) / 1.0E9);
            System.out.println("time for getShapeFromImpl: " + (double)(t3 - t2) / 1.0E9);
            System.out.println("time for getID: " + (double)(t4 - t3) / 1.0E9);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public static interface Attributes {
        public String toXML();

        public void fromXML(Element var1);
    }

    protected static interface Factory<T> {
        public T create(TopoDS_Shape var1, Map<TopoDS_Shape, T> var2, T[] var3);

        public T[] createArray(int var1);
    }

    private static enum ListOfShapes {
        COMPOUND(TopAbs_ShapeEnum.COMPOUND, "Compound", "co"),
        COMPSOLID(TopAbs_ShapeEnum.COMPSOLID, "CompSolid", "cs"),
        SOLID(TopAbs_ShapeEnum.SOLID, "Solid", "so"),
        SHELL(TopAbs_ShapeEnum.SHELL, "Shell", "sh"),
        FACE(TopAbs_ShapeEnum.FACE, "Face", "f"),
        WIRE(TopAbs_ShapeEnum.WIRE, "Wire", "w"),
        EDGE(TopAbs_ShapeEnum.EDGE, "Edge", "e"),
        VERTEX(TopAbs_ShapeEnum.VERTEX, "Vertex", "v"),
        SHAPE(TopAbs_ShapeEnum.SHAPE, "Shape", null);

        TopAbs_ShapeEnum type;
        String label;
        String xmlName;

        private ListOfShapes(TopAbs_ShapeEnum type, String label, String xmlName) {
            this.type = type;
            this.label = label;
            this.xmlName = xmlName;
        }
    }

    private static class ShapeImpl
    extends Shape<ShapeImpl> {
        public ShapeImpl(TopoDS_Shape shape, Map<TopoDS_Shape, ShapeImpl> map, ShapeImpl[] parents) {
            super(shape, map, (Shape[])parents);
        }

        @Override
        protected Factory<ShapeImpl> getFactory() {
            return DEFAULT_FACTORY;
        }

        @Override
        protected ShapeImpl getDerived() {
            return this;
        }
    }
}

