/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Map;

public class Subtraction
implements IExpression {
    public IExpression exp1;
    public IExpression exp2;

    public Subtraction(IExpression exp1, IExpression exp2) {
        if (exp1 == null) {
            exp1 = new Constant("0");
        }
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    public String toString() {
        return String.valueOf(this.exp1) + " - " + String.valueOf(this.exp2);
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        Object o1 = this.exp1.evaluate(environment);
        Object o2 = this.exp2.evaluate(environment);
        if (o1 == null || o2 == null) {
            return null;
        }
        if (o1 instanceof Double && o2 instanceof Double) {
            return (Double)o1 - (Double)o2;
        }
        if (o1 instanceof Array && o2 instanceof Array) {
            Array la = (Array)o1;
            Array ra = (Array)o2;
            return la.copy2(ra, new Array.Modifier2(){

                @Override
                public Object modify(Object o1, Object o2) {
                    if (o1 instanceof Double && o2 instanceof Double) {
                        return (Double)o1 - (Double)o2;
                    }
                    throw new IllegalStateException("Tried to subtract a non-numerical array");
                }
            });
        }
        throw new IllegalStateException();
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        return new Subtraction(this.exp1.withBase(frame, prefix), this.exp2.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        this.exp1 = this.exp1.rewrite(frame, copies);
        this.exp2 = this.exp2.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        this.exp1.accept(visitor);
        this.exp2.accept(visitor);
    }
}

