/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui;

import org.simantics.utils.ui.dialogs.ShowError;


/**
 * 
 * @author Toni Kalajainen
 */
public class ExceptionUtils {

    public static void logWarning(String msg) {
        Exception e = new Exception(msg);
        ErrorLogger.getDefault().logWarning(msg, e);
    }

    public static void logWarning(String msg, Throwable e) {
        e = new Exception(msg, e);
        ErrorLogger.getDefault().logWarning(msg, e);
    }

    public static void logError(Throwable e) {
        ErrorLogger.defaultLogError(e);
    }

    public static void logError(String msg, Throwable e) {
        e = new Exception(msg, e);
        ErrorLogger.getDefault().logError(msg, e);
    }

    public static void logAndShowError(Throwable e) {
        ErrorLogger.defaultLogError(e);
        ShowError.showError("Error", e.getMessage(),e);
    }
    
    public static void logAndShowError(String message, Throwable e) {
        ErrorLogger.defaultLogError(message,e);
        ShowError.showError("Error", message,e);
    }

    public static void logAndShowError(String title, String message, Throwable e) {
        ErrorLogger.defaultLogError(message,e);
        ShowError.showError(title, message,e);
    }

    public static void showError(Throwable e) {
    	 ShowError.showError("Error", e.getMessage(),e);
    }
    
    public static void showError(String message, Throwable e) {
   	 	ShowError.showError("Error", message,e);
    }

}
