/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.util;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class KvikDeviationBuilder {
    List<Rectangle2D.Double> rects = new ArrayList<Rectangle2D.Double>();
    int rectCount = 0;

    public KvikDeviationBuilder() {
        this.reset();
    }

    public void addRectangle(double x1, double x2, double y1, double y2) {
        if (y1 > y2) {
            double yy = y1;
            y1 = y2;
            y2 = yy;
        }
        if (y2 == Double.NaN || y1 == Double.NaN || y2 == y1) {
            return;
        }
        Rectangle2D.Double lastRect = this.lastRect();
        if (lastRect != null) {
            double lx1 = lastRect.x;
            double lx2 = lastRect.x + lastRect.width;
            double ly1 = lastRect.y;
            double ly2 = lastRect.y + lastRect.height;
            if (x1 == lx1 && x2 == lx2) {
                if (y2 < ly1) {
                    lastRect.y = y2;
                }
                if (y1 > ly2) {
                    lastRect.height = y1 - lastRect.y;
                }
                return;
            }
            if (x1 == lx2 && y1 == ly1 && y2 == ly2) {
                lastRect.width = x2 - lastRect.x;
                return;
            }
        }
        Rectangle2D.Double r = this.newRect();
        r.x = x1;
        r.y = y1;
        r.width = x2 - x1;
        r.height = y2 - y1;
    }

    public void appendRectangle(double xx, double low, double high) {
        Rectangle2D.Double lastRect = this.lastRect();
        if (lastRect != null) {
            this.addRectangle(lastRect.x + lastRect.width, xx, low, high);
        } else {
            this.addRectangle(xx, xx, low, high);
        }
    }

    public void extendRectangle(double toX) {
        Rectangle2D.Double lastRect = this.lastRect();
        if (lastRect == null) {
            return;
        }
        lastRect.width = toX - lastRect.x;
    }

    public boolean isEmpty() {
        return this.rectCount == 0;
    }

    public void reset() {
        this.rectCount = 0;
    }

    public void drawLines(Graphics2D g) {
        Line2D.Double line = new Line2D.Double();
        int i = 0;
        while (i < this.rectCount) {
            Rectangle2D.Double r = this.rects.get(i);
            int x1 = (int)Math.round(r.x);
            int x2 = (int)Math.round(r.x);
            line.y1 = r.y;
            line.y2 = r.y + r.height;
            int x = x1;
            while (x <= x2) {
                line.x1 = line.x2 = (double)x;
                g.draw(line);
                ++x;
            }
            ++i;
        }
    }

    public void drawRectangles(Graphics2D g) {
        int i = 0;
        while (i < this.rectCount) {
            Rectangle2D.Double r = this.rects.get(i);
            g.fill(r);
            ++i;
        }
    }

    Rectangle2D.Double newRect() {
        if (this.rectCount < this.rects.size()) {
            return this.rects.get(this.rectCount++);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ++this.rectCount;
        this.rects.add(rect);
        return rect;
    }

    Rectangle2D.Double lastRect() {
        if (this.rectCount == 0) {
            return null;
        }
        return this.rects.get(this.rectCount - 1);
    }
}

