/*******************************************************************************
 *  Copyright (c) 2023 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web.serializer;

import java.awt.geom.AffineTransform;
import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * @author Antti Villberg
 * @since 1.58.0
 */
public class TransformSerializer extends StdSerializer<AffineTransform> {

	private static final long serialVersionUID = 8732741358420623631L;

	public TransformSerializer() {
		this(null);
	}

	public TransformSerializer(Class<AffineTransform> t) {
		super(t);
	}
	
	@Override
	public void serializeWithType(AffineTransform value, JsonGenerator gen, SerializerProvider serializers,
			TypeSerializer typeSer) throws IOException {
		typeSer.writeTypePrefixForObject(value, gen);
		serialize(value, gen, serializers);
		typeSer.writeTypeSuffixForObject(value, gen);
	}

	@Override
	public void serialize(AffineTransform value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		jgen.writeNumberField("m00", value.getScaleX());
		jgen.writeNumberField("m01", value.getShearX());
		jgen.writeNumberField("m02", value.getTranslateX());
		jgen.writeNumberField("m10", value.getShearY());
		jgen.writeNumberField("m11", value.getScaleY());
		jgen.writeNumberField("m12", value.getTranslateY());
	}
}