/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.commands.ResourceWriteCommand;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IModelingRules;

public class Connect
extends ResourceWriteCommand<ModelingCommandSequenceTest>
implements SingleResourceTrait {
    private SingleResourceTrait diagram;
    private SingleResourceTrait m1;
    private SingleResourceTrait m2;
    private SingleResourceTrait c1;
    private SingleResourceTrait c2;

    public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, SingleResourceTrait c1, SingleResourceTrait m2, SingleResourceTrait c2) {
        this.diagram = diagram;
        this.m1 = m1;
        this.c1 = c1;
        this.m2 = m2;
        this.c2 = c2;
    }

    public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, SingleResourceTrait c1, SingleResourceTrait m2, Resource c2) {
        this.diagram = diagram;
        this.m1 = m1;
        this.c1 = c1;
        this.m2 = m2;
        this.c2 = new SingleResourceTraitImpl(c2);
    }

    public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, Resource c1, SingleResourceTrait m2, SingleResourceTrait c2) {
        this.diagram = diagram;
        this.m1 = m1;
        this.c1 = new SingleResourceTraitImpl(c1);
        this.m2 = m2;
        this.c2 = c2;
    }

    public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, Resource c1, SingleResourceTrait m2, Resource c2) {
        this.diagram = diagram;
        this.m1 = m1;
        this.c1 = new SingleResourceTraitImpl(c1);
        this.m2 = m2;
        this.c2 = new SingleResourceTraitImpl(c2);
    }

    @Override
    protected Resource run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
        ConnectionUtil cu = new ConnectionUtil(graph);
        Resource conn = cu.createConnectionWithCorners(graph, this.m1.getResource((ReadGraph)graph), this.c1.getResource((ReadGraph)graph), this.m2.getResource((ReadGraph)graph), this.c2.getResource((ReadGraph)graph), Collections.emptyList());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        graph.claim(conn, L0.PartOf, this.diagram.getResource());
        AddElement.claimFreshElementName((WriteGraph)graph, (Resource)this.diagram.getResource(), (Resource)conn);
        OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)this.diagram.getResource(), (Resource)conn);
        IModelingRules modelingRules = (IModelingRules)graph.syncRequest(DiagramRequests.getModelingRules((Resource)this.diagram.getResource(), null));
        CPTerminal cp1 = new CPTerminal(this.m1.getResource((ReadGraph)graph), this.c1.getResource((ReadGraph)graph));
        CPTerminal cp2 = new CPTerminal(this.m2.getResource((ReadGraph)graph), this.c2.getResource((ReadGraph)graph));
        ConnectionJudgement judgement = modelingRules.judgeConnection((ReadGraph)graph, Arrays.asList(cp1, cp2));
        Assert.assertNotNull((Object)judgement.connectionType);
        graph.claim(conn, STR.HasConnectionType, null, judgement.connectionType);
        return conn;
    }
}

