/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.simantics.db.layer0.util.EvaluatingListener;
import org.simantics.db.testing.common.Command;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.commands.Utils;
import org.simantics.modeling.tests.traits.SingleResourceTrait;

public class AssertStateValue
extends Command<ModelingCommandSequenceTest> {
    private final transient SingleResourceTrait run;
    private final transient String rvi;
    private final transient Number expectedValue;
    private final transient double tolerance;

    public AssertStateValue(SingleResourceTrait run, String rvi, Number expectedValue, double tolerance) {
        this.run = run;
        this.rvi = rvi;
        this.expectedValue = expectedValue;
        this.tolerance = tolerance;
    }

    public void run(ModelingCommandSequenceTest environment) throws Exception {
        EvaluatingListener.Criterion<Number> criterion = new EvaluatingListener.Criterion<Number>(){

            public EvaluatingListener.Evaluation evaluate(Number result) {
                if (result == null) {
                    return EvaluatingListener.Evaluation.IGNORE;
                }
                double resultDouble = result.doubleValue();
                double expectedDouble = AssertStateValue.this.expectedValue.doubleValue();
                if (Math.abs(expectedDouble - resultDouble) <= AssertStateValue.this.tolerance) {
                    return EvaluatingListener.Evaluation.ACCEPT;
                }
                return EvaluatingListener.Evaluation.IGNORE;
            }
        };
        Number result = Utils.readValue(this.run, this.rvi, criterion);
        if (result == null) {
            throw new AssertionFailedError();
        }
        double resultDouble = result.doubleValue();
        double expectedDouble = this.expectedValue.doubleValue();
        Assert.assertEquals((double)expectedDouble, (double)resultDouble, (double)this.tolerance);
    }
}

