/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.collections;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.OperationResource;
import org.simantics.utils.datastructures.persistent.IContextMap;

public class ContextualList implements IContextualList {

	Object[] list;
	
	public ContextualList(ReadGraph g, Resource r) throws DatabaseException {
		list = OrderedSetUtils.toList(g, r).toArray();
		OperationResource OP = OperationResource.getInstance(g);
		for(int i=0;i<list.length;++i) {
			Resource e = (Resource)list[i];
			if(g.isInstanceOf(e, OP.AbstractContextualList)) {
				list[i] = g.adapt(e, IContextualList.class);
			}
		}
	}

	@Override
	public void fill(ReadGraph g, IContextMap parameters, Collection<Resource> c) throws DatabaseException {
		for(Object obj : list) {
			if(obj instanceof Resource)
				c.add((Resource)obj);
			else
				((IContextualList)obj).fill(g, parameters, c);
		}
	}

	
}
