/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.binaryPredicates;

import java.util.Arrays;
import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Pair;

public class InversePredicate extends BinaryPredicate {

	IBinaryPredicate base;
	
	public InversePredicate(IBinaryPredicate base) {
		this.base = base;
	}

	@Override
	public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
		return base.getSubjects(g, subject);
	}

	@SuppressWarnings("unchecked")
    @Override
	public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) throws DatabaseException {
		Collection<Pair<Resource, Resource>> baseResult = base.getStatements(g);
		Pair<Resource, Resource>[] result = new Pair[baseResult.size()];
		int i=0;
		for(Pair<Resource, Resource> p : baseResult)
			result[i++] = new Pair<Resource, Resource>(p.second, p.first);
		return Arrays.asList(result);
	}

	@Override
	public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
		return base.getObjects(g, object);
	}

	@Override
	public boolean has(ReadGraph g, Resource subject, Resource object) {
		return has(g, object, subject);
	}

	@Override
	public boolean supportsGetObjects() {
		return base.supportsGetSubjects();
	}

	@Override
	public boolean supportsGetStatements() {
		return base.supportsGetStatements();
	}

	@Override
	public boolean supportsGetSubjects() {
		return base.supportsGetObjects();
	}

	@Override
	public void add(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
		base.add(g, object, subject);
	}

	@Override
	public void remove(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
		base.remove(g, object, subject);
	}

	@Override
	public boolean supportsAdditions() {
		return base.supportsAdditions();
	}

	@Override
	public boolean supportsRemovals() {
		return base.supportsRemovals();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((base == null) ? 0 : base.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		InversePredicate other = (InversePredicate) obj;
		if (base == null) {
			if (other.base != null)
				return false;
		} else if (!base.equals(other.base))
			return false;
		return true;
	}
	
	@Override
	public IBinaryPredicate inverse(ReadGraph g) {
		return base;
	}
	
}
