/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.Color;
import java.util.HashMap;

public class Colors {
    
    static HashMap<String, Color> x11ColorMap = new HashMap<String, Color>();

    private static int getHex(String hex) {
        int value = 0;
        for(int i=0;i<hex.length();++i) {
            value *= 0x10;
            char c = hex.charAt(i);
            if(c >= '0' && c <= '9')
                value += c - '0';
            else if(c >= 'a' && c <= 'f')
                value += c - 'a' + 10;
            else if(c >= 'A' && c <= 'F')
                value += c - 'A' + 10;
        }
        return value;
    }    
    
    public static Color getColor(String colorName) {
        if(colorName.charAt(0) == '#') {
            if(colorName.length() < 9)
                return new Color(
                    getHex(colorName.substring(1, 3)),
                    getHex(colorName.substring(3, 5)),
                    getHex(colorName.substring(5, 7))
                    );
            else 
                return new Color(
                    getHex(colorName.substring(1, 3)),
                    getHex(colorName.substring(3, 5)),
                    getHex(colorName.substring(5, 7)),
                    getHex(colorName.substring(7, 9))
                    );
        }
        else {
            Color color = x11ColorMap.get(colorName.toLowerCase());
            if(color == null) {
                System.err.println("Unknown color: " + colorName);
                return Color.BLACK;
            }
            return color;
        }
    }

    private static void addColor(int r, int g, int b, String name) {
        x11ColorMap.put(name.toLowerCase(), new Color(r, g, b));
    }
    
    static {
        addColor(255, 250, 250, "snow");
        addColor(248, 248, 255, "ghost white");
        addColor(248, 248, 255, "GhostWhite");
        addColor(245, 245, 245, "white smoke");
        addColor(245, 245, 245, "WhiteSmoke");
        addColor(220, 220, 220, "gainsboro");
        addColor(255, 250, 240, "floral white");
        addColor(255, 250, 240, "FloralWhite");
        addColor(253, 245, 230, "old lace");
        addColor(253, 245, 230, "OldLace");
        addColor(250, 240, 230, "linen");
        addColor(250, 235, 215, "antique white");
        addColor(250, 235, 215, "AntiqueWhite");
        addColor(255, 239, 213, "papaya whip");
        addColor(255, 239, 213, "PapayaWhip");
        addColor(255, 235, 205, "blanched almond");
        addColor(255, 235, 205, "BlanchedAlmond");
        addColor(255, 228, 196, "bisque");
        addColor(255, 218, 185, "peach puff");
        addColor(255, 218, 185, "PeachPuff");
        addColor(255, 222, 173, "navajo white");
        addColor(255, 222, 173, "NavajoWhite");
        addColor(255, 228, 181, "moccasin");
        addColor(255, 248, 220, "cornsilk");
        addColor(255, 255, 240, "ivory");
        addColor(255, 250, 205, "lemon chiffon");
        addColor(255, 250, 205, "LemonChiffon");
        addColor(255, 245, 238, "seashell");
        addColor(240, 255, 240, "honeydew");
        addColor(245, 255, 250, "mint cream");
        addColor(245, 255, 250, "MintCream");
        addColor(240, 255, 255, "azure");
        addColor(240, 248, 255, "alice blue");
        addColor(240, 248, 255, "AliceBlue");
        addColor(230, 230, 250, "lavender");
        addColor(255, 240, 245, "lavender blush");
        addColor(255, 240, 245, "LavenderBlush");
        addColor(255, 228, 225, "misty rose");
        addColor(255, 228, 225, "MistyRose");
        addColor(255, 255, 255, "white");
        addColor(0, 0, 0, "black");
        addColor(47, 79, 79, "dark slate gray");
        addColor(47, 79, 79, "DarkSlateGray");
        addColor(47, 79, 79, "dark slate grey");
        addColor(47, 79, 79, "DarkSlateGrey");
        addColor(105, 105, 105, "dim gray");
        addColor(105, 105, 105, "DimGray");
        addColor(105, 105, 105, "dim grey");
        addColor(105, 105, 105, "DimGrey");
        addColor(112, 128, 144, "slate gray");
        addColor(112, 128, 144, "SlateGray");
        addColor(112, 128, 144, "slate grey");
        addColor(112, 128, 144, "SlateGrey");
        addColor(119, 136, 153, "light slate gray");
        addColor(119, 136, 153, "LightSlateGray");
        addColor(119, 136, 153, "light slate grey");
        addColor(119, 136, 153, "LightSlateGrey");
        addColor(190, 190, 190, "gray");
        addColor(190, 190, 190, "grey");
        addColor(211, 211, 211, "light grey");
        addColor(211, 211, 211, "LightGrey");
        addColor(211, 211, 211, "light gray");
        addColor(211, 211, 211, "LightGray");
        addColor(25, 25, 112, "midnight blue");
        addColor(25, 25, 112, "MidnightBlue");
        addColor(0, 0, 128, "navy");
        addColor(0, 0, 128, "navy blue");
        addColor(0, 0, 128, "NavyBlue");
        addColor(100, 149, 237, "cornflower blue");
        addColor(100, 149, 237, "CornflowerBlue");
        addColor(72, 61, 139, "dark slate blue");
        addColor(72, 61, 139, "DarkSlateBlue");
        addColor(106, 90, 205, "slate blue");
        addColor(106, 90, 205, "SlateBlue");
        addColor(123, 104, 238, "medium slate blue");
        addColor(123, 104, 238, "MediumSlateBlue");
        addColor(132, 112, 255, "light slate blue");
        addColor(132, 112, 255, "LightSlateBlue");
        addColor(0, 0, 205, "medium blue");
        addColor(0, 0, 205, "MediumBlue");
        addColor(65, 105, 225, "royal blue");
        addColor(65, 105, 225, "RoyalBlue");
        addColor(0, 0, 255, "blue");
        addColor(30, 144, 255, "dodger blue");
        addColor(30, 144, 255, "DodgerBlue");
        addColor(0, 191, 255, "deep sky blue");
        addColor(0, 191, 255, "DeepSkyBlue");
        addColor(135, 206, 235, "sky blue");
        addColor(135, 206, 235, "SkyBlue");
        addColor(135, 206, 250, "light sky blue");
        addColor(135, 206, 250, "LightSkyBlue");
        addColor(70, 130, 180, "steel blue");
        addColor(70, 130, 180, "SteelBlue");
        addColor(176, 196, 222, "light steel blue");
        addColor(176, 196, 222, "LightSteelBlue");
        addColor(173, 216, 230, "light blue");
        addColor(173, 216, 230, "LightBlue");
        addColor(176, 224, 230, "powder blue");
        addColor(176, 224, 230, "PowderBlue");
        addColor(175, 238, 238, "pale turquoise");
        addColor(175, 238, 238, "PaleTurquoise");
        addColor(0, 206, 209, "dark turquoise");
        addColor(0, 206, 209, "DarkTurquoise");
        addColor(72, 209, 204, "medium turquoise");
        addColor(72, 209, 204, "MediumTurquoise");
        addColor(64, 224, 208, "turquoise");
        addColor(0, 255, 255, "cyan");
        addColor(224, 255, 255, "light cyan");
        addColor(224, 255, 255, "LightCyan");
        addColor(95, 158, 160, "cadet blue");
        addColor(95, 158, 160, "CadetBlue");
        addColor(102, 205, 170, "medium aquamarine");
        addColor(102, 205, 170, "MediumAquamarine");
        addColor(127, 255, 212, "aquamarine");
        addColor(0, 100, 0, "dark green");
        addColor(0, 100, 0, "DarkGreen");
        addColor(85, 107, 47, "dark olive green");
        addColor(85, 107, 47, "DarkOliveGreen");
        addColor(143, 188, 143, "dark sea green");
        addColor(143, 188, 143, "DarkSeaGreen");
        addColor(46, 139, 87, "sea green");
        addColor(46, 139, 87, "SeaGreen");
        addColor(60, 179, 113, "medium sea green");
        addColor(60, 179, 113, "MediumSeaGreen");
        addColor(32, 178, 170, "light sea green");
        addColor(32, 178, 170, "LightSeaGreen");
        addColor(152, 251, 152, "pale green");
        addColor(152, 251, 152, "PaleGreen");
        addColor(0, 255, 127, "spring green");
        addColor(0, 255, 127, "SpringGreen");
        addColor(124, 252, 0, "lawn green");
        addColor(124, 252, 0, "LawnGreen");
        addColor(0, 255, 0, "green");
        addColor(127, 255, 0, "chartreuse");
        addColor(0, 250, 154, "medium spring green");
        addColor(0, 250, 154, "MediumSpringGreen");
        addColor(173, 255, 47, "green yellow");
        addColor(173, 255, 47, "GreenYellow");
        addColor(50, 205, 50, "lime green");
        addColor(50, 205, 50, "LimeGreen");
        addColor(154, 205, 50, "yellow green");
        addColor(154, 205, 50, "YellowGreen");
        addColor(34, 139, 34, "forest green");
        addColor(34, 139, 34, "ForestGreen");
        addColor(107, 142, 35, "olive drab");
        addColor(107, 142, 35, "OliveDrab");
        addColor(189, 183, 107, "dark khaki");
        addColor(189, 183, 107, "DarkKhaki");
        addColor(240, 230, 140, "khaki");
        addColor(238, 232, 170, "pale goldenrod");
        addColor(238, 232, 170, "PaleGoldenrod");
        addColor(250, 250, 210, "light goldenrod yellow");
        addColor(250, 250, 210, "LightGoldenrodYellow");
        addColor(255, 255, 224, "light yellow");
        addColor(255, 255, 224, "LightYellow");
        addColor(255, 255, 0, "yellow");
        addColor(255, 215, 0, "gold");
        addColor(238, 221, 130, "light goldenrod");
        addColor(238, 221, 130, "LightGoldenrod");
        addColor(218, 165, 32, "goldenrod");
        addColor(184, 134, 11, "dark goldenrod");
        addColor(184, 134, 11, "DarkGoldenrod");
        addColor(188, 143, 143, "rosy brown");
        addColor(188, 143, 143, "RosyBrown");
        addColor(205, 92, 92, "indian red");
        addColor(205, 92, 92, "IndianRed");
        addColor(139, 69, 19, "saddle brown");
        addColor(139, 69, 19, "SaddleBrown");
        addColor(160, 82, 45, "sienna");
        addColor(205, 133, 63, "peru");
        addColor(222, 184, 135, "burlywood");
        addColor(245, 245, 220, "beige");
        addColor(245, 222, 179, "wheat");
        addColor(244, 164, 96, "sandy brown");
        addColor(244, 164, 96, "SandyBrown");
        addColor(210, 180, 140, "tan");
        addColor(210, 105, 30, "chocolate");
        addColor(178, 34, 34, "firebrick");
        addColor(165, 42, 42, "brown");
        addColor(233, 150, 122, "dark salmon");
        addColor(233, 150, 122, "DarkSalmon");
        addColor(250, 128, 114, "salmon");
        addColor(255, 160, 122, "light salmon");
        addColor(255, 160, 122, "LightSalmon");
        addColor(255, 165, 0, "orange");
        addColor(255, 140, 0, "dark orange");
        addColor(255, 140, 0, "DarkOrange");
        addColor(255, 127, 80, "coral");
        addColor(240, 128, 128, "light coral");
        addColor(240, 128, 128, "LightCoral");
        addColor(255, 99, 71, "tomato");
        addColor(255, 69, 0, "orange red");
        addColor(255, 69, 0, "OrangeRed");
        addColor(255, 0, 0, "red");
        addColor(255, 105, 180, "hot pink");
        addColor(255, 105, 180, "HotPink");
        addColor(255, 20, 147, "deep pink");
        addColor(255, 20, 147, "DeepPink");
        addColor(255, 192, 203, "pink");
        addColor(255, 182, 193, "light pink");
        addColor(255, 182, 193, "LightPink");
        addColor(219, 112, 147, "pale violet red");
        addColor(219, 112, 147, "PaleVioletRed");
        addColor(176, 48, 96, "maroon");
        addColor(199, 21, 133, "medium violet red");
        addColor(199, 21, 133, "MediumVioletRed");
        addColor(208, 32, 144, "violet red");
        addColor(208, 32, 144, "VioletRed");
        addColor(255, 0, 255, "magenta");
        addColor(238, 130, 238, "violet");
        addColor(221, 160, 221, "plum");
        addColor(218, 112, 214, "orchid");
        addColor(186, 85, 211, "medium orchid");
        addColor(186, 85, 211, "MediumOrchid");
        addColor(153, 50, 204, "dark orchid");
        addColor(153, 50, 204, "DarkOrchid");
        addColor(148, 0, 211, "dark violet");
        addColor(148, 0, 211, "DarkViolet");
        addColor(138, 43, 226, "blue violet");
        addColor(138, 43, 226, "BlueViolet");
        addColor(160, 32, 240, "purple");
        addColor(147, 112, 219, "medium purple");
        addColor(147, 112, 219, "MediumPurple");
        addColor(216, 191, 216, "thistle");
        addColor(255, 250, 250, "snow1");
        addColor(238, 233, 233, "snow2");
        addColor(205, 201, 201, "snow3");
        addColor(139, 137, 137, "snow4");
        addColor(255, 245, 238, "seashell1");
        addColor(238, 229, 222, "seashell2");
        addColor(205, 197, 191, "seashell3");
        addColor(139, 134, 130, "seashell4");
        addColor(255, 239, 219, "AntiqueWhite1");
        addColor(238, 223, 204, "AntiqueWhite2");
        addColor(205, 192, 176, "AntiqueWhite3");
        addColor(139, 131, 120, "AntiqueWhite4");
        addColor(255, 228, 196, "bisque1");
        addColor(238, 213, 183, "bisque2");
        addColor(205, 183, 158, "bisque3");
        addColor(139, 125, 107, "bisque4");
        addColor(255, 218, 185, "PeachPuff1");
        addColor(238, 203, 173, "PeachPuff2");
        addColor(205, 175, 149, "PeachPuff3");
        addColor(139, 119, 101, "PeachPuff4");
        addColor(255, 222, 173, "NavajoWhite1");
        addColor(238, 207, 161, "NavajoWhite2");
        addColor(205, 179, 139, "NavajoWhite3");
        addColor(139, 121, 94, "NavajoWhite4");
        addColor(255, 250, 205, "LemonChiffon1");
        addColor(238, 233, 191, "LemonChiffon2");
        addColor(205, 201, 165, "LemonChiffon3");
        addColor(139, 137, 112, "LemonChiffon4");
        addColor(255, 248, 220, "cornsilk1");
        addColor(238, 232, 205, "cornsilk2");
        addColor(205, 200, 177, "cornsilk3");
        addColor(139, 136, 120, "cornsilk4");
        addColor(255, 255, 240, "ivory1");
        addColor(238, 238, 224, "ivory2");
        addColor(205, 205, 193, "ivory3");
        addColor(139, 139, 131, "ivory4");
        addColor(240, 255, 240, "honeydew1");
        addColor(224, 238, 224, "honeydew2");
        addColor(193, 205, 193, "honeydew3");
        addColor(131, 139, 131, "honeydew4");
        addColor(255, 240, 245, "LavenderBlush1");
        addColor(238, 224, 229, "LavenderBlush2");
        addColor(205, 193, 197, "LavenderBlush3");
        addColor(139, 131, 134, "LavenderBlush4");
        addColor(255, 228, 225, "MistyRose1");
        addColor(238, 213, 210, "MistyRose2");
        addColor(205, 183, 181, "MistyRose3");
        addColor(139, 125, 123, "MistyRose4");
        addColor(240, 255, 255, "azure1");
        addColor(224, 238, 238, "azure2");
        addColor(193, 205, 205, "azure3");
        addColor(131, 139, 139, "azure4");
        addColor(131, 111, 255, "SlateBlue1");
        addColor(122, 103, 238, "SlateBlue2");
        addColor(105, 89, 205, "SlateBlue3");
        addColor(71, 60, 139, "SlateBlue4");
        addColor(72, 118, 255, "RoyalBlue1");
        addColor(67, 110, 238, "RoyalBlue2");
        addColor(58, 95, 205, "RoyalBlue3");
        addColor(39, 64, 139, "RoyalBlue4");
        addColor(0, 0, 255, "blue1");
        addColor(0, 0, 238, "blue2");
        addColor(0, 0, 205, "blue3");
        addColor(0, 0, 139, "blue4");
        addColor(30, 144, 255, "DodgerBlue1");
        addColor(28, 134, 238, "DodgerBlue2");
        addColor(24, 116, 205, "DodgerBlue3");
        addColor(16, 78, 139, "DodgerBlue4");
        addColor(99, 184, 255, "SteelBlue1");
        addColor(92, 172, 238, "SteelBlue2");
        addColor(79, 148, 205, "SteelBlue3");
        addColor(54, 100, 139, "SteelBlue4");
        addColor(0, 191, 255, "DeepSkyBlue1");
        addColor(0, 178, 238, "DeepSkyBlue2");
        addColor(0, 154, 205, "DeepSkyBlue3");
        addColor(0, 104, 139, "DeepSkyBlue4");
        addColor(135, 206, 255, "SkyBlue1");
        addColor(126, 192, 238, "SkyBlue2");
        addColor(108, 166, 205, "SkyBlue3");
        addColor(74, 112, 139, "SkyBlue4");
        addColor(176, 226, 255, "LightSkyBlue1");
        addColor(164, 211, 238, "LightSkyBlue2");
        addColor(141, 182, 205, "LightSkyBlue3");
        addColor(96, 123, 139, "LightSkyBlue4");
        addColor(198, 226, 255, "SlateGray1");
        addColor(185, 211, 238, "SlateGray2");
        addColor(159, 182, 205, "SlateGray3");
        addColor(108, 123, 139, "SlateGray4");
        addColor(202, 225, 255, "LightSteelBlue1");
        addColor(188, 210, 238, "LightSteelBlue2");
        addColor(162, 181, 205, "LightSteelBlue3");
        addColor(110, 123, 139, "LightSteelBlue4");
        addColor(191, 239, 255, "LightBlue1");
        addColor(178, 223, 238, "LightBlue2");
        addColor(154, 192, 205, "LightBlue3");
        addColor(104, 131, 139, "LightBlue4");
        addColor(224, 255, 255, "LightCyan1");
        addColor(209, 238, 238, "LightCyan2");
        addColor(180, 205, 205, "LightCyan3");
        addColor(122, 139, 139, "LightCyan4");
        addColor(187, 255, 255, "PaleTurquoise1");
        addColor(174, 238, 238, "PaleTurquoise2");
        addColor(150, 205, 205, "PaleTurquoise3");
        addColor(102, 139, 139, "PaleTurquoise4");
        addColor(152, 245, 255, "CadetBlue1");
        addColor(142, 229, 238, "CadetBlue2");
        addColor(122, 197, 205, "CadetBlue3");
        addColor(83, 134, 139, "CadetBlue4");
        addColor(0, 245, 255, "turquoise1");
        addColor(0, 229, 238, "turquoise2");
        addColor(0, 197, 205, "turquoise3");
        addColor(0, 134, 139, "turquoise4");
        addColor(0, 255, 255, "cyan1");
        addColor(0, 238, 238, "cyan2");
        addColor(0, 205, 205, "cyan3");
        addColor(0, 139, 139, "cyan4");
        addColor(151, 255, 255, "DarkSlateGray1");
        addColor(141, 238, 238, "DarkSlateGray2");
        addColor(121, 205, 205, "DarkSlateGray3");
        addColor(82, 139, 139, "DarkSlateGray4");
        addColor(127, 255, 212, "aquamarine1");
        addColor(118, 238, 198, "aquamarine2");
        addColor(102, 205, 170, "aquamarine3");
        addColor(69, 139, 116, "aquamarine4");
        addColor(193, 255, 193, "DarkSeaGreen1");
        addColor(180, 238, 180, "DarkSeaGreen2");
        addColor(155, 205, 155, "DarkSeaGreen3");
        addColor(105, 139, 105, "DarkSeaGreen4");
        addColor(84, 255, 159, "SeaGreen1");
        addColor(78, 238, 148, "SeaGreen2");
        addColor(67, 205, 128, "SeaGreen3");
        addColor(46, 139, 87, "SeaGreen4");
        addColor(154, 255, 154, "PaleGreen1");
        addColor(144, 238, 144, "PaleGreen2");
        addColor(124, 205, 124, "PaleGreen3");
        addColor(84, 139, 84, "PaleGreen4");
        addColor(0, 255, 127, "SpringGreen1");
        addColor(0, 238, 118, "SpringGreen2");
        addColor(0, 205, 102, "SpringGreen3");
        addColor(0, 139, 69, "SpringGreen4");
        addColor(0, 255, 0, "green1");
        addColor(0, 238, 0, "green2");
        addColor(0, 205, 0, "green3");
        addColor(0, 139, 0, "green4");
        addColor(127, 255, 0, "chartreuse1");
        addColor(118, 238, 0, "chartreuse2");
        addColor(102, 205, 0, "chartreuse3");
        addColor(69, 139, 0, "chartreuse4");
        addColor(192, 255, 62, "OliveDrab1");
        addColor(179, 238, 58, "OliveDrab2");
        addColor(154, 205, 50, "OliveDrab3");
        addColor(105, 139, 34, "OliveDrab4");
        addColor(202, 255, 112, "DarkOliveGreen1");
        addColor(188, 238, 104, "DarkOliveGreen2");
        addColor(162, 205, 90, "DarkOliveGreen3");
        addColor(110, 139, 61, "DarkOliveGreen4");
        addColor(255, 246, 143, "khaki1");
        addColor(238, 230, 133, "khaki2");
        addColor(205, 198, 115, "khaki3");
        addColor(139, 134, 78, "khaki4");
        addColor(255, 236, 139, "LightGoldenrod1");
        addColor(238, 220, 130, "LightGoldenrod2");
        addColor(205, 190, 112, "LightGoldenrod3");
        addColor(139, 129, 76, "LightGoldenrod4");
        addColor(255, 255, 224, "LightYellow1");
        addColor(238, 238, 209, "LightYellow2");
        addColor(205, 205, 180, "LightYellow3");
        addColor(139, 139, 122, "LightYellow4");
        addColor(255, 255, 0, "yellow1");
        addColor(238, 238, 0, "yellow2");
        addColor(205, 205, 0, "yellow3");
        addColor(139, 139, 0, "yellow4");
        addColor(255, 215, 0, "gold1");
        addColor(238, 201, 0, "gold2");
        addColor(205, 173, 0, "gold3");
        addColor(139, 117, 0, "gold4");
        addColor(255, 193, 37, "goldenrod1");
        addColor(238, 180, 34, "goldenrod2");
        addColor(205, 155, 29, "goldenrod3");
        addColor(139, 105, 20, "goldenrod4");
        addColor(255, 185, 15, "DarkGoldenrod1");
        addColor(238, 173, 14, "DarkGoldenrod2");
        addColor(205, 149, 12, "DarkGoldenrod3");
        addColor(139, 101, 8, "DarkGoldenrod4");
        addColor(255, 193, 193, "RosyBrown1");
        addColor(238, 180, 180, "RosyBrown2");
        addColor(205, 155, 155, "RosyBrown3");
        addColor(139, 105, 105, "RosyBrown4");
        addColor(255, 106, 106, "IndianRed1");
        addColor(238, 99, 99, "IndianRed2");
        addColor(205, 85, 85, "IndianRed3");
        addColor(139, 58, 58, "IndianRed4");
        addColor(255, 130, 71, "sienna1");
        addColor(238, 121, 66, "sienna2");
        addColor(205, 104, 57, "sienna3");
        addColor(139, 71, 38, "sienna4");
        addColor(255, 211, 155, "burlywood1");
        addColor(238, 197, 145, "burlywood2");
        addColor(205, 170, 125, "burlywood3");
        addColor(139, 115, 85, "burlywood4");
        addColor(255, 231, 186, "wheat1");
        addColor(238, 216, 174, "wheat2");
        addColor(205, 186, 150, "wheat3");
        addColor(139, 126, 102, "wheat4");
        addColor(255, 165, 79, "tan1");
        addColor(238, 154, 73, "tan2");
        addColor(205, 133, 63, "tan3");
        addColor(139, 90, 43, "tan4");
        addColor(255, 127, 36, "chocolate1");
        addColor(238, 118, 33, "chocolate2");
        addColor(205, 102, 29, "chocolate3");
        addColor(139, 69, 19, "chocolate4");
        addColor(255, 48, 48, "firebrick1");
        addColor(238, 44, 44, "firebrick2");
        addColor(205, 38, 38, "firebrick3");
        addColor(139, 26, 26, "firebrick4");
        addColor(255, 64, 64, "brown1");
        addColor(238, 59, 59, "brown2");
        addColor(205, 51, 51, "brown3");
        addColor(139, 35, 35, "brown4");
        addColor(255, 140, 105, "salmon1");
        addColor(238, 130, 98, "salmon2");
        addColor(205, 112, 84, "salmon3");
        addColor(139, 76, 57, "salmon4");
        addColor(255, 160, 122, "LightSalmon1");
        addColor(238, 149, 114, "LightSalmon2");
        addColor(205, 129, 98, "LightSalmon3");
        addColor(139, 87, 66, "LightSalmon4");
        addColor(255, 165, 0, "orange1");
        addColor(238, 154, 0, "orange2");
        addColor(205, 133, 0, "orange3");
        addColor(139, 90, 0, "orange4");
        addColor(255, 127, 0, "DarkOrange1");
        addColor(238, 118, 0, "DarkOrange2");
        addColor(205, 102, 0, "DarkOrange3");
        addColor(139, 69, 0, "DarkOrange4");
        addColor(255, 114, 86, "coral1");
        addColor(238, 106, 80, "coral2");
        addColor(205, 91, 69, "coral3");
        addColor(139, 62, 47, "coral4");
        addColor(255, 99, 71, "tomato1");
        addColor(238, 92, 66, "tomato2");
        addColor(205, 79, 57, "tomato3");
        addColor(139, 54, 38, "tomato4");
        addColor(255, 69, 0, "OrangeRed1");
        addColor(238, 64, 0, "OrangeRed2");
        addColor(205, 55, 0, "OrangeRed3");
        addColor(139, 37, 0, "OrangeRed4");
        addColor(255, 0, 0, "red1");
        addColor(238, 0, 0, "red2");
        addColor(205, 0, 0, "red3");
        addColor(139, 0, 0, "red4");
        addColor(255, 20, 147, "DeepPink1");
        addColor(238, 18, 137, "DeepPink2");
        addColor(205, 16, 118, "DeepPink3");
        addColor(139, 10, 80, "DeepPink4");
        addColor(255, 110, 180, "HotPink1");
        addColor(238, 106, 167, "HotPink2");
        addColor(205, 96, 144, "HotPink3");
        addColor(139, 58, 98, "HotPink4");
        addColor(255, 181, 197, "pink1");
        addColor(238, 169, 184, "pink2");
        addColor(205, 145, 158, "pink3");
        addColor(139, 99, 108, "pink4");
        addColor(255, 174, 185, "LightPink1");
        addColor(238, 162, 173, "LightPink2");
        addColor(205, 140, 149, "LightPink3");
        addColor(139, 95, 101, "LightPink4");
        addColor(255, 130, 171, "PaleVioletRed1");
        addColor(238, 121, 159, "PaleVioletRed2");
        addColor(205, 104, 137, "PaleVioletRed3");
        addColor(139, 71, 93, "PaleVioletRed4");
        addColor(255, 52, 179, "maroon1");
        addColor(238, 48, 167, "maroon2");
        addColor(205, 41, 144, "maroon3");
        addColor(139, 28, 98, "maroon4");
        addColor(255, 62, 150, "VioletRed1");
        addColor(238, 58, 140, "VioletRed2");
        addColor(205, 50, 120, "VioletRed3");
        addColor(139, 34, 82, "VioletRed4");
        addColor(255, 0, 255, "magenta1");
        addColor(238, 0, 238, "magenta2");
        addColor(205, 0, 205, "magenta3");
        addColor(139, 0, 139, "magenta4");
        addColor(255, 131, 250, "orchid1");
        addColor(238, 122, 233, "orchid2");
        addColor(205, 105, 201, "orchid3");
        addColor(139, 71, 137, "orchid4");
        addColor(255, 187, 255, "plum1");
        addColor(238, 174, 238, "plum2");
        addColor(205, 150, 205, "plum3");
        addColor(139, 102, 139, "plum4");
        addColor(224, 102, 255, "MediumOrchid1");
        addColor(209, 95, 238, "MediumOrchid2");
        addColor(180, 82, 205, "MediumOrchid3");
        addColor(122, 55, 139, "MediumOrchid4");
        addColor(191, 62, 255, "DarkOrchid1");
        addColor(178, 58, 238, "DarkOrchid2");
        addColor(154, 50, 205, "DarkOrchid3");
        addColor(104, 34, 139, "DarkOrchid4");
        addColor(155, 48, 255, "purple1");
        addColor(145, 44, 238, "purple2");
        addColor(125, 38, 205, "purple3");
        addColor(85, 26, 139, "purple4");
        addColor(171, 130, 255, "MediumPurple1");
        addColor(159, 121, 238, "MediumPurple2");
        addColor(137, 104, 205, "MediumPurple3");
        addColor(93, 71, 139, "MediumPurple4");
        addColor(255, 225, 255, "thistle1");
        addColor(238, 210, 238, "thistle2");
        addColor(205, 181, 205, "thistle3");
        addColor(139, 123, 139, "thistle4");
        addColor(0, 0, 0, "gray0");
        addColor(0, 0, 0, "grey0");
        addColor(3, 3, 3, "gray1");
        addColor(3, 3, 3, "grey1");
        addColor(5, 5, 5, "gray2");
        addColor(5, 5, 5, "grey2");
        addColor(8, 8, 8, "gray3");
        addColor(8, 8, 8, "grey3");
        addColor(10, 10, 10, "gray4");
        addColor(10, 10, 10, "grey4");
        addColor(13, 13, 13, "gray5");
        addColor(13, 13, 13, "grey5");
        addColor(15, 15, 15, "gray6");
        addColor(15, 15, 15, "grey6");
        addColor(18, 18, 18, "gray7");
        addColor(18, 18, 18, "grey7");
        addColor(20, 20, 20, "gray8");
        addColor(20, 20, 20, "grey8");
        addColor(23, 23, 23, "gray9");
        addColor(23, 23, 23, "grey9");
        addColor(26, 26, 26, "gray10");
        addColor(26, 26, 26, "grey10");
        addColor(28, 28, 28, "gray11");
        addColor(28, 28, 28, "grey11");
        addColor(31, 31, 31, "gray12");
        addColor(31, 31, 31, "grey12");
        addColor(33, 33, 33, "gray13");
        addColor(33, 33, 33, "grey13");
        addColor(36, 36, 36, "gray14");
        addColor(36, 36, 36, "grey14");
        addColor(38, 38, 38, "gray15");
        addColor(38, 38, 38, "grey15");
        addColor(41, 41, 41, "gray16");
        addColor(41, 41, 41, "grey16");
        addColor(43, 43, 43, "gray17");
        addColor(43, 43, 43, "grey17");
        addColor(46, 46, 46, "gray18");
        addColor(46, 46, 46, "grey18");
        addColor(48, 48, 48, "gray19");
        addColor(48, 48, 48, "grey19");
        addColor(51, 51, 51, "gray20");
        addColor(51, 51, 51, "grey20");
        addColor(54, 54, 54, "gray21");
        addColor(54, 54, 54, "grey21");
        addColor(56, 56, 56, "gray22");
        addColor(56, 56, 56, "grey22");
        addColor(59, 59, 59, "gray23");
        addColor(59, 59, 59, "grey23");
        addColor(61, 61, 61, "gray24");
        addColor(61, 61, 61, "grey24");
        addColor(64, 64, 64, "gray25");
        addColor(64, 64, 64, "grey25");
        addColor(66, 66, 66, "gray26");
        addColor(66, 66, 66, "grey26");
        addColor(69, 69, 69, "gray27");
        addColor(69, 69, 69, "grey27");
        addColor(71, 71, 71, "gray28");
        addColor(71, 71, 71, "grey28");
        addColor(74, 74, 74, "gray29");
        addColor(74, 74, 74, "grey29");
        addColor(77, 77, 77, "gray30");
        addColor(77, 77, 77, "grey30");
        addColor(79, 79, 79, "gray31");
        addColor(79, 79, 79, "grey31");
        addColor(82, 82, 82, "gray32");
        addColor(82, 82, 82, "grey32");
        addColor(84, 84, 84, "gray33");
        addColor(84, 84, 84, "grey33");
        addColor(87, 87, 87, "gray34");
        addColor(87, 87, 87, "grey34");
        addColor(89, 89, 89, "gray35");
        addColor(89, 89, 89, "grey35");
        addColor(92, 92, 92, "gray36");
        addColor(92, 92, 92, "grey36");
        addColor(94, 94, 94, "gray37");
        addColor(94, 94, 94, "grey37");
        addColor(97, 97, 97, "gray38");
        addColor(97, 97, 97, "grey38");
        addColor(99, 99, 99, "gray39");
        addColor(99, 99, 99, "grey39");
        addColor(102, 102, 102, "gray40");
        addColor(102, 102, 102, "grey40");
        addColor(105, 105, 105, "gray41");
        addColor(105, 105, 105, "grey41");
        addColor(107, 107, 107, "gray42");
        addColor(107, 107, 107, "grey42");
        addColor(110, 110, 110, "gray43");
        addColor(110, 110, 110, "grey43");
        addColor(112, 112, 112, "gray44");
        addColor(112, 112, 112, "grey44");
        addColor(115, 115, 115, "gray45");
        addColor(115, 115, 115, "grey45");
        addColor(117, 117, 117, "gray46");
        addColor(117, 117, 117, "grey46");
        addColor(120, 120, 120, "gray47");
        addColor(120, 120, 120, "grey47");
        addColor(122, 122, 122, "gray48");
        addColor(122, 122, 122, "grey48");
        addColor(125, 125, 125, "gray49");
        addColor(125, 125, 125, "grey49");
        addColor(127, 127, 127, "gray50");
        addColor(127, 127, 127, "grey50");
        addColor(130, 130, 130, "gray51");
        addColor(130, 130, 130, "grey51");
        addColor(133, 133, 133, "gray52");
        addColor(133, 133, 133, "grey52");
        addColor(135, 135, 135, "gray53");
        addColor(135, 135, 135, "grey53");
        addColor(138, 138, 138, "gray54");
        addColor(138, 138, 138, "grey54");
        addColor(140, 140, 140, "gray55");
        addColor(140, 140, 140, "grey55");
        addColor(143, 143, 143, "gray56");
        addColor(143, 143, 143, "grey56");
        addColor(145, 145, 145, "gray57");
        addColor(145, 145, 145, "grey57");
        addColor(148, 148, 148, "gray58");
        addColor(148, 148, 148, "grey58");
        addColor(150, 150, 150, "gray59");
        addColor(150, 150, 150, "grey59");
        addColor(153, 153, 153, "gray60");
        addColor(153, 153, 153, "grey60");
        addColor(156, 156, 156, "gray61");
        addColor(156, 156, 156, "grey61");
        addColor(158, 158, 158, "gray62");
        addColor(158, 158, 158, "grey62");
        addColor(161, 161, 161, "gray63");
        addColor(161, 161, 161, "grey63");
        addColor(163, 163, 163, "gray64");
        addColor(163, 163, 163, "grey64");
        addColor(166, 166, 166, "gray65");
        addColor(166, 166, 166, "grey65");
        addColor(168, 168, 168, "gray66");
        addColor(168, 168, 168, "grey66");
        addColor(171, 171, 171, "gray67");
        addColor(171, 171, 171, "grey67");
        addColor(173, 173, 173, "gray68");
        addColor(173, 173, 173, "grey68");
        addColor(176, 176, 176, "gray69");
        addColor(176, 176, 176, "grey69");
        addColor(179, 179, 179, "gray70");
        addColor(179, 179, 179, "grey70");
        addColor(181, 181, 181, "gray71");
        addColor(181, 181, 181, "grey71");
        addColor(184, 184, 184, "gray72");
        addColor(184, 184, 184, "grey72");
        addColor(186, 186, 186, "gray73");
        addColor(186, 186, 186, "grey73");
        addColor(189, 189, 189, "gray74");
        addColor(189, 189, 189, "grey74");
        addColor(191, 191, 191, "gray75");
        addColor(191, 191, 191, "grey75");
        addColor(194, 194, 194, "gray76");
        addColor(194, 194, 194, "grey76");
        addColor(196, 196, 196, "gray77");
        addColor(196, 196, 196, "grey77");
        addColor(199, 199, 199, "gray78");
        addColor(199, 199, 199, "grey78");
        addColor(201, 201, 201, "gray79");
        addColor(201, 201, 201, "grey79");
        addColor(204, 204, 204, "gray80");
        addColor(204, 204, 204, "grey80");
        addColor(207, 207, 207, "gray81");
        addColor(207, 207, 207, "grey81");
        addColor(209, 209, 209, "gray82");
        addColor(209, 209, 209, "grey82");
        addColor(212, 212, 212, "gray83");
        addColor(212, 212, 212, "grey83");
        addColor(214, 214, 214, "gray84");
        addColor(214, 214, 214, "grey84");
        addColor(217, 217, 217, "gray85");
        addColor(217, 217, 217, "grey85");
        addColor(219, 219, 219, "gray86");
        addColor(219, 219, 219, "grey86");
        addColor(222, 222, 222, "gray87");
        addColor(222, 222, 222, "grey87");
        addColor(224, 224, 224, "gray88");
        addColor(224, 224, 224, "grey88");
        addColor(227, 227, 227, "gray89");
        addColor(227, 227, 227, "grey89");
        addColor(229, 229, 229, "gray90");
        addColor(229, 229, 229, "grey90");
        addColor(232, 232, 232, "gray91");
        addColor(232, 232, 232, "grey91");
        addColor(235, 235, 235, "gray92");
        addColor(235, 235, 235, "grey92");
        addColor(237, 237, 237, "gray93");
        addColor(237, 237, 237, "grey93");
        addColor(240, 240, 240, "gray94");
        addColor(240, 240, 240, "grey94");
        addColor(242, 242, 242, "gray95");
        addColor(242, 242, 242, "grey95");
        addColor(245, 245, 245, "gray96");
        addColor(245, 245, 245, "grey96");
        addColor(247, 247, 247, "gray97");
        addColor(247, 247, 247, "grey97");
        addColor(250, 250, 250, "gray98");
        addColor(250, 250, 250, "grey98");
        addColor(252, 252, 252, "gray99");
        addColor(252, 252, 252, "grey99");
        addColor(255, 255, 255, "gray100");
        addColor(255, 255, 255, "grey100");
        addColor(169, 169, 169, "dark grey");
        addColor(169, 169, 169, "DarkGrey");
        addColor(169, 169, 169, "dark gray");
        addColor(169, 169, 169, "DarkGray");
        addColor(0, 0, 139, "dark blue");
        addColor(0, 0, 139, "DarkBlue");
        addColor(0, 139, 139, "dark cyan");
        addColor(0, 139, 139, "DarkCyan");
        addColor(139, 0, 139, "dark magenta");
        addColor(139, 0, 139, "DarkMagenta");
        addColor(139, 0, 0, "dark red");
        addColor(139, 0, 0, "DarkRed");
        addColor(144, 238, 144, "light green");
        addColor(144, 238, 144, "LightGreen");
    }
}
