/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.db;

import java.io.Closeable;
import java.io.DataInput;
import java.util.TreeMap;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Value;

/*
 * NOTE: Current constraints
 * 
 *  §1 The following methods shall be called exactly once in the following order:
 *     -init
 *     -getIdentityCount
 *     -forIdentities
 *     -getStatementCount
 *     -forStatements
 *     -getValueCount
 *     -forValues
 * 
 */

public interface TransferableGraphSource extends Closeable {

	public static final byte TAG_RAW_COPY_VARIANT_VALUE = 1;
	public static final byte TAG_POTENTIALLY_MODIFIED_VARIANT_VALUE = 2;

	@FunctionalInterface
	public interface TransferableGraphSourceProcedure<T> {
		void execute(T value) throws Exception;
	}

	public interface TransferableGraphSourceValueProcedure {
		void execute(int resource, Datatype type, DataInput input) throws Exception;
		void rawCopy(int resource, int length, DataInput input) throws Exception;
	}

	public DataContainer getHeader() throws Exception;
	
	public TreeMap<String, Variant> getExtensions() throws Exception;
	
	public int getResourceCount() throws Exception;

	public void init(ReadGraph graph) throws Exception;
	
	public int getIdentityCount() throws Exception;
	public void forIdentities(ReadGraph graph, TransferableGraphSourceProcedure<Identity> procedure) throws Exception;

	public int getStatementCount() throws Exception;
	public void forStatements(ReadGraph graph, TransferableGraphSourceProcedure<int[]> procedure) throws Exception;
	
	public int getValueCount() throws Exception;
	public void forValues(ReadGraph graph, TransferableGraphSourceProcedure<Value> procedure) throws Exception;
	public void forValues2(ReadGraph graph, TransferableGraphSourceValueProcedure procedure) throws Exception;
	
	public void reset() throws Exception;
	
}
