/*******************************************************************************
 * Copyright (c) 2012, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.db;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.graph.utils.TGResourceUtil;

public abstract class TransferableGraphImportProcessBase implements TransferableGraphImporter {

	protected TGStatusMonitor monitor;

	// Builtins
	protected Resource RootLibrary;
	protected Resource String;
	protected Resource Library;

	protected Resource InstanceOf;
	protected Resource ConsistsOf;
	protected Resource PartOf;
	protected Resource HasName;
	protected Resource NameOf;

	protected Resource ExternalEntity;

	protected final TGResourceUtil resourceUtil = new TGResourceUtil();

	protected Set<String> missingExternals = new HashSet<String>(); 

	public void findBuiltins(WriteOnlyGraph g) throws DatabaseException {
		RootLibrary = g.getBuiltin("http:/");
		String = g.getBuiltin(CoreInitialization.LAYER0 + "String");
		Library = g.getBuiltin(CoreInitialization.LAYER0 + "Library");
		InstanceOf = g.getBuiltin(CoreInitialization.LAYER0 + "InstanceOf");
		ConsistsOf = g.getBuiltin(CoreInitialization.LAYER0 + "ConsistsOf");
		PartOf = g.getBuiltin(CoreInitialization.LAYER0 + "PartOf");
		HasName = g.getBuiltin(CoreInitialization.LAYER0 + "HasName");
		NameOf = g.getBuiltin(CoreInitialization.LAYER0 + "NameOf");
		ExternalEntity = g.getBuiltin(CoreInitialization.LAYER0 + "ExternalEntity");
	}

	public void findBuiltins(ReadGraph g) throws DatabaseException {
		RootLibrary = g.getBuiltin("http:/");
		String = g.getBuiltin(CoreInitialization.LAYER0 + "String");
		Library = g.getBuiltin(CoreInitialization.LAYER0 + "Library");
		InstanceOf = g.getBuiltin(CoreInitialization.LAYER0 + "InstanceOf");
		ConsistsOf = g.getBuiltin(CoreInitialization.LAYER0 + "ConsistsOf");
		PartOf = g.getBuiltin(CoreInitialization.LAYER0 + "PartOf");
		HasName = g.getBuiltin(CoreInitialization.LAYER0 + "HasName");
		NameOf = g.getBuiltin(CoreInitialization.LAYER0 + "NameOf");
		ExternalEntity = g.getBuiltin(CoreInitialization.LAYER0 + "ExternalEntity");
	}

	protected Map<String,Resource> requestChildMap(ReadGraph graph, Resource parent) throws DatabaseException {
		return graph.syncRequest(new AsyncRead<Map<String,Resource>>() {
			@Override
			public void perform(AsyncReadGraph graph, AsyncProcedure<Map<String,Resource>> procedure) {
				graph.forChildMap(parent, new AsyncListener<Map<String,Resource>>() {
					@Override
					public void execute(AsyncReadGraph graph, Map<java.lang.String, Resource> result) {
						procedure.execute(graph, result);
					}
					@Override
					public void exception(AsyncReadGraph graph, Throwable throwable) {
						procedure.exception(graph, throwable);
					}
					@Override
					public boolean isDisposed() {
						return true;
					}
				});
			}
		});
	}

	@Override
	public Resource createChild(WriteOnlyGraph graph, Resource parent, Resource child, String name) throws DatabaseException {
		if(child == null)
			child = graph.newResource();
		Resource nameResource = graph.newResource();
		graph.claim(nameResource, InstanceOf, null, String);
		graph.claimValue(nameResource, name, WriteBindings.STRING);
		graph.claim(child, HasName, NameOf, nameResource);
		graph.claim(parent, ConsistsOf, PartOf, child);
		return child;
	}

}
