/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - GitLab #1201
 *******************************************************************************/
package org.simantics.desktop.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingUtils;
import org.simantics.platform.ui.PlatformUIResource;

public class NewModel extends AbstractHandler {

    public static Resource execute(WriteGraph graph) throws DatabaseException {
        PlatformUIResource PLATFORM = PlatformUIResource.getInstance(graph);
        return execute(graph, PLATFORM.Model, null);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Job job = new DatabaseJob(Messages.NewModel_NewModel) {  
            @Override
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.getSession().syncRequest((WriteGraph graph) -> execute(graph));
                    return Status.OK_STATUS;
                } catch (DatabaseException e) {
                    return new Status(IStatus.ERROR, Activator.PLUGIN_ID, NLS.bind(Messages.NewModel_0_Failed, getName()), e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public static Resource execute(WriteGraph graph, Resource type, String name) throws DatabaseException {
        Resource model = ModelingUtils.createModel(graph, type, name);

        ModelingUtils.addSCLMainToModel(graph, model, "SCLMain", ""); //$NON-NLS-1$ //$NON-NLS-2$
        ModelingUtils.createLocalLibrary(graph, model, Messages.NewModel_Library);

        return model;
    }

}
