/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.GraphHints;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoInverseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.scl.compiler.types.Type;

public interface ReadGraph
extends RequestProcessor {
    public static final String GRAPH_HINT_SYNCHRONOUS = "sync";

    public String getURI(Resource var1) throws AssumptionException, ValidationException, ServiceException;

    public String getPossibleURI(Resource var1) throws ValidationException, ServiceException;

    public Resource getResource(String var1) throws ResourceNotFoundException, ValidationException, ServiceException;

    public Resource getPossibleResource(String var1) throws ResourceNotFoundException, ValidationException, ServiceException;

    public Map<String, Resource> getChildren(Resource var1) throws ValidationException, ServiceException;

    public Resource getBuiltin(String var1) throws ResourceNotFoundException, ServiceException;

    public Collection<Statement> getStatements(Resource var1, Resource var2) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public Collection<Statement> getAssertedStatements(Resource var1, Resource var2) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public Collection<Resource> getPredicates(Resource var1) throws ServiceException;

    public Collection<Resource> getPrincipalTypes(Resource var1) throws ServiceException;

    public Set<Resource> getTypes(Resource var1) throws ServiceException;

    public Set<Resource> getSupertypes(Resource var1) throws ServiceException;

    public Set<Resource> getSuperrelations(Resource var1) throws ServiceException;

    public Resource getPossibleSuperrelation(Resource var1) throws ServiceException;

    public Collection<Resource> getObjects(Resource var1, Resource var2) throws ServiceException;

    public Collection<Resource> getAssertedObjects(Resource var1, Resource var2) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public Resource getInverse(Resource var1) throws NoInverseException, ManyObjectsForFunctionalRelationException, ServiceException;

    public Resource getSingleObject(Resource var1, Resource var2) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException;

    public Statement getSingleStatement(Resource var1, Resource var2) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException;

    public Resource getSingleType(Resource var1) throws NoSingleResultException, ServiceException;

    public Resource getSingleType(Resource var1, Resource var2) throws NoSingleResultException, ServiceException;

    public <T> T getValue(Resource var1) throws DoesNotContainValueException, ServiceException;

    public Variant getVariantValue(Resource var1) throws DoesNotContainValueException, ServiceException;

    public <T> T getValue(Resource var1, Binding var2) throws DoesNotContainValueException, BindingException, ServiceException;

    public <T> T getRelatedValue(Resource var1, Resource var2) throws NoSingleResultException, DoesNotContainValueException, ServiceException;

    public Variant getRelatedVariantValue(Resource var1, Resource var2) throws NoSingleResultException, DoesNotContainValueException, ServiceException;

    public <T> T getRelatedValue(Resource var1, Resource var2, Binding var3) throws NoSingleResultException, DoesNotContainValueException, BindingException, ServiceException;

    public <T> T adapt(Resource var1, Class<T> var2) throws AdaptionException, ValidationException, ServiceException;

    public <T> T adaptRelated(Resource var1, Resource var2, Class<T> var3) throws AdaptionException, NoSingleResultException, ValidationException, ServiceException;

    public <T> T getPossibleRelatedAdapter(Resource var1, Resource var2, Class<T> var3) throws ValidationException, ServiceException;

    public <T, C> T adaptContextual(Resource var1, C var2, Class<C> var3, Class<T> var4) throws AdaptionException, NoSingleResultException, ValidationException, ServiceException;

    public <T, C> T getPossibleContextualAdapter(Resource var1, C var2, Class<C> var3, Class<T> var4) throws ValidationException, ServiceException;

    public <T> T adaptUnique(Resource var1, Class<T> var2) throws AdaptionException, ValidationException, ServiceException;

    public Resource getPossibleInverse(Resource var1) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public Resource getPossibleObject(Resource var1, Resource var2) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public Statement getPossibleStatement(Resource var1, Resource var2) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public Resource getPossibleType(Resource var1, Resource var2) throws ServiceException;

    public <T> T getPossibleValue(Resource var1) throws ServiceException;

    public <T> T getPossibleValue(Resource var1, Binding var2) throws BindingException, ServiceException;

    public <T> T getPossibleRelatedValue(Resource var1, Resource var2) throws ManyObjectsForFunctionalRelationException, ServiceException;

    public <T> T getPossibleRelatedValue(Resource var1, Resource var2, Binding var3) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException;

    public <T> T getPossibleAdapter(Resource var1, Class<T> var2) throws ValidationException, ServiceException;

    public <T> T getPossibleUniqueAdapter(Resource var1, Class<T> var2) throws ValidationException, ServiceException;

    public boolean isInstanceOf(Resource var1, Resource var2) throws ServiceException;

    public boolean isInheritedFrom(Resource var1, Resource var2) throws ServiceException;

    public boolean isSubrelationOf(Resource var1, Resource var2) throws ServiceException;

    public boolean hasStatement(Resource var1) throws ServiceException;

    public boolean hasStatement(Resource var1, Resource var2) throws ServiceException;

    public boolean hasStatement(Resource var1, Resource var2, Resource var3) throws ServiceException;

    public boolean hasValue(Resource var1) throws ServiceException;

    public Datatype getDataType(Resource var1) throws DatabaseException;

    public <T extends Accessor> T getAccessor(Resource var1) throws DatabaseException;

    public RandomAccessBinary getRandomAccessBinary(Resource var1) throws DatabaseException;

    public <T> T getValue2(Resource var1, Object var2) throws DatabaseException;

    public Variant getVariantValue2(Resource var1, Object var2) throws DatabaseException;

    public <T> T getPossibleValue2(Resource var1, Object var2) throws DatabaseException;

    public <T> T getValue2(Resource var1, Object var2, Binding var3) throws DatabaseException;

    public <T> T getPossibleValue2(Resource var1, Object var2, Binding var3) throws DatabaseException;

    public <T> T getRelatedValue2(Resource var1, Resource var2) throws DatabaseException;

    public <T> T getPossibleRelatedValue2(Resource var1, Resource var2) throws DatabaseException;

    public Variant getRelatedVariantValue2(Resource var1, Resource var2) throws DatabaseException;

    public <T> T getRelatedValue2(Resource var1, Resource var2, Object var3) throws DatabaseException;

    public Variant getRelatedVariantValue2(Resource var1, Resource var2, Object var3) throws DatabaseException;

    public <T> T getPossibleRelatedValue2(Resource var1, Resource var2, Object var3) throws DatabaseException;

    public <T> T getRelatedValue2(Resource var1, Resource var2, Binding var3) throws DatabaseException;

    public <T> T getPossibleRelatedValue2(Resource var1, Resource var2, Binding var3) throws DatabaseException;

    public <T> T getRelatedValue2(Resource var1, Resource var2, Object var3, Binding var4) throws DatabaseException;

    public <T> T getPossibleRelatedValue2(Resource var1, Resource var2, Object var3, Binding var4) throws DatabaseException;

    public Type getRelatedValueType(Resource var1, Resource var2) throws DatabaseException;

    @Deprecated
    public boolean setSynchronous(boolean var1);

    @Deprecated
    public boolean getSynchronous();

    public <T> T getHintValue(String var1);

    public <T> GraphHints setHintValue(String var1, T var2);

    public GraphHints setHints(GraphHints var1);

    public boolean isImmutable(Resource var1) throws DatabaseException;

    public boolean isImmutableForWriting(Resource var1) throws DatabaseException;

    public int thread();
}

