/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 */
public class VariablePropertyModifierRule implements ModifierRule {

	String propertyName;

    public VariablePropertyModifierRule(ReadGraph graph, String propertyName) throws DatabaseException {
        this.propertyName = propertyName;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Modifier getModifier(ReadGraph graph, Object content,
            String columnKey) throws DatabaseException {
        if(!ColumnKeys.SINGLE.equals(columnKey))
            return null;
        if(!(content instanceof Variable))
            return null;
        Variable variable = (Variable)content;
        Variable propertyVariable = variable.getProperty(graph, propertyName);
        return new VariableModifier2(graph, propertyVariable);
    }

}
