package org.simantics.browsing.ui.model.actions;

import java.util.Collection;

import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;

public class ActionBrowseContextRequest extends UnaryRead<Collection<Resource>,ActionBrowseContext> {

    public ActionBrowseContextRequest(Collection<Resource> parameter) {
        super(parameter);
    }

    @Override
    public ActionBrowseContext perform(ReadGraph graph) throws DatabaseException {
        
        try {
            return ActionBrowseContext.createInternal(graph, parameter);
        } catch (InvalidContribution e) {
        	throw new DatabaseException(e);
        }
        
    }

}
