/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.pythonlink.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.pythonlink.Activator;
import org.simantics.pythonlink.NDArray;
import org.simantics.pythonlink.PythonException;
import org.simantics.pythonlink.SCLReportingWriter;
import org.simantics.pythonlink.jna.PythonJNA;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonContext
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonContext.class);
    protected static final String PYTHON_SCL_WRITER = "python.scl.writer";
    private static boolean isPythonLoaded = false;
    private static Boolean isPyInitialized = false;
    private static PythonJNA INSTANCE;
    private static final ExecutorService pythonExecutor;
    private static final Writer pythonWriter;
    Set<Listener> listeners = new HashSet<Listener>();
    static Pattern namePattern;
    private long contextID;

    static {
        try {
            String libPath = Activator.libPath("jnapython");
            LOGGER.info("Loading {}", (Object)libPath);
            INSTANCE = (PythonJNA)Native.loadLibrary((String)libPath, PythonJNA.class);
            isPythonLoaded = true;
        }
        catch (Throwable t) {
            LOGGER.error("Could not load jnapython", t);
        }
        pythonExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("python-context-thread-" + this.counter.getAndIncrement());
                return t;
            }
        });
        pythonWriter = new Writer(){
            Writer defaultWriter = new OutputStreamWriter(System.out);

            @Override
            public void close() throws IOException {
                throw new IllegalStateException("This writer should never be closed!");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                Writer writer;
                Writer writer2 = writer = this.getPythonWriter();
                synchronized (writer2) {
                    writer.flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                Writer writer;
                Writer writer2 = writer = this.getPythonWriter();
                synchronized (writer2) {
                    writer.write(cbuf, off, len);
                }
            }

            private Writer getPythonWriter() {
                SCLContext sclContext = SCLContext.getCurrent();
                Writer writer = (Writer)sclContext.get((Object)PythonContext.PYTHON_SCL_WRITER);
                return writer != null ? writer : this.defaultWriter;
            }
        };
        namePattern = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)");
    }

    private synchronized void ensurePythonInit() {
        if (!isPythonLoaded) {
            throw new PythonException("Python interpreter has not been successfully loaded. Check availablility of python3.dll in path.");
        }
        if (!isPyInitialized.booleanValue()) {
            PythonContext.execute(() -> {
                try {
                    INSTANCE.initializePython(SCLWriterWriteImpl.INSTANCE, SCLWriterFlushImpl.INSTANCE);
                }
                catch (Throwable t) {
                    LOGGER.error("Could not init python", t);
                }
            });
            isPyInitialized = true;
        }
    }

    public PythonContext() {
        this.ensurePythonInit();
        this.contextID = PythonContext.execute(() -> INSTANCE.createContextImpl());
        if (this.contextID == 0L) {
            throw new PythonException("Python initialization has failed");
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void close() {
        long id = this.contextID;
        this.contextID = 0L;
        if (id != 0L) {
            PythonContext.execute(() -> INSTANCE.deleteContextImpl(id));
        }
        for (Listener l : this.listeners) {
            l.closed();
        }
    }

    public boolean isOpen() {
        return this.contextID != 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void executePythonStatement(String statement, Writer writer) {
        SCLContext sclContext = SCLContext.getCurrent();
        PythonContext.execute(() -> {
            SCLContext.push((SCLContext)sclContext);
            Writer oldWriter = (Writer)sclContext.put((Object)PYTHON_SCL_WRITER, (Object)writer);
            try {
                try {
                    INSTANCE.executePythonStatementImpl(this.contextID, statement);
                    pythonWriter.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not execute in context {} statement {}", (Object)this.contextID, (Object)statement);
                    if (oldWriter != null) {
                        sclContext.put((Object)PYTHON_SCL_WRITER, (Object)oldWriter);
                    } else {
                        sclContext.remove((Object)PYTHON_SCL_WRITER);
                    }
                    SCLContext.pop();
                }
            }
            finally {
                if (oldWriter != null) {
                    sclContext.put((Object)PYTHON_SCL_WRITER, (Object)oldWriter);
                } else {
                    sclContext.remove((Object)PYTHON_SCL_WRITER);
                }
                SCLContext.pop();
            }
        });
        for (Listener l : this.listeners) {
            l.updated(null);
        }
    }

    public void executePythonStatement(String statement) {
        this.executePythonStatement(statement, new SCLReportingWriter());
    }

    public void setPythonBooleanVariable(String variableName, boolean value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonBooleanVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonIntegerVariable(String variableName, int value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonLongVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonLongVariable(String variableName, long value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonLongVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonDoubleVariable(String variableName, double value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonDoubleVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonStringVariable(String variableName, String value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonStringVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonBooleanArrayVariable(String variableName, boolean[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonBooleanArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonIntegerArrayVariable(String variableName, int[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonIntegerArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonLongArrayVariable(String variableName, long[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonLongArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonDoubleArrayVariable(String variableName, double[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonDoubleArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonStringArrayVariable(String variableName, String[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonStringArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public boolean getPythonBooleanVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return INSTANCE.getPythonBooleanVariableImpl(this.contextID, variableName);
    }

    public int getPythonIntegerVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        long value = PythonContext.execute(() -> INSTANCE.getPythonLongVariableImpl(this.contextID, variableName));
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new RuntimeException("Python value not in integer range");
        }
        return (int)value;
    }

    public long getPythonLongVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonLongVariableImpl(this.contextID, variableName));
    }

    public double getPythonDoubleVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonDoubleVariableImpl(this.contextID, variableName));
    }

    public String getPythonStringVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonStringVariableImpl(this.contextID, variableName));
    }

    public boolean[] getPythonBooleanArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonBooleanArrayVariableImpl(this.contextID, variableName));
    }

    public int[] getPythonIntegerArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonIntegerArrayVariableImpl(this.contextID, variableName));
    }

    public long[] getPythonLongArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonLongArrayVariableImpl(this.contextID, variableName));
    }

    public double[] getPythonDoubleArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonDoubleArrayVariableImpl(this.contextID, variableName));
    }

    public String[] getPythonStringArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonStringArrayVariableImpl(this.contextID, variableName));
    }

    public void setPythonNDArrayVariable(String variableName, NDArray value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> INSTANCE.setPythonNDArrayVariableImpl(this.contextID, variableName, value));
    }

    public NDArray getPythonNDArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> INSTANCE.getPythonNDArrayVariableImpl(this.contextID, variableName));
    }

    public Object getPythonVariantVariable(String variableName, Binding binding) {
        PythonContext.checkValidName(variableName);
        Object result = PythonContext.execute(() -> INSTANCE.getPythonVariantVariableImpl(this.contextID, variableName));
        try {
            return Bindings.OBJECT.getContent(result, binding);
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public Variant getPythonVariantVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return Variant.ofInstance((Object)PythonContext.execute(() -> INSTANCE.getPythonVariantVariableImpl(this.contextID, variableName)));
    }

    public void setPythonVariantVariable(String variableName, Variant value) {
        this.setPythonVariantVariable(variableName, value.getValue(), value.getBinding());
    }

    public void setPythonVariantVariable(String variableName, Object value, Binding binding) {
        PythonContext.checkValidName(variableName);
        if (!binding.isInstance(value)) {
            throw new IllegalArgumentException("Invalid object binding");
        }
        PythonContext.execute(() -> INSTANCE.setPythonVariantVariableImpl(this.contextID, variableName, value, binding));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public VariableType getPythonVariableType(String variableName) {
        PythonContext.checkValidName(variableName);
        int code = PythonContext.execute(() -> INSTANCE.getPythonVariableTypeImpl(this.contextID, variableName));
        VariableType[] values = VariableType.values();
        if (code < 0 || code >= values.length) {
            return VariableType.UNKNOWN;
        }
        return values[code];
    }

    public String[] getPythonVariableNames() {
        return PythonContext.execute(() -> INSTANCE.getPythonVariableNamesImpl(this.contextID));
    }

    private static void checkValidName(String variableName) {
        if (!namePattern.matcher(variableName).matches()) {
            throw new IllegalArgumentException("Invalid Python variable name " + variableName);
        }
    }

    static void execute(Runnable job) {
        try {
            pythonExecutor.submit(job).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    static <V> V execute(Callable<V> job) {
        try {
            return pythonExecutor.submit(job).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static interface Listener {
        public void updated(String var1);

        public void closed();
    }

    private static class SCLWriterFlushImpl
    implements PythonJNA.SCLWriterFlush {
        static PythonJNA.SCLWriterFlush INSTANCE = new SCLWriterFlushImpl();

        private SCLWriterFlushImpl() {
        }

        @Override
        public void flush() {
            try {
                pythonWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SCLWriterWriteImpl
    implements PythonJNA.SCLWriterWrite {
        static PythonJNA.SCLWriterWrite INSTANCE = new SCLWriterWriteImpl();

        private SCLWriterWriteImpl() {
        }

        @Override
        public void write(Pointer val, int length) {
            String string = Arrays.toString(val.getByteArray(0L, length));
            try {
                pythonWriter.write(string);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum VariableType {
        NO_VARIABLE,
        BOOLEAN,
        LONG,
        FLOAT,
        STRING,
        BYTEARRAY,
        DICTIONARY,
        NDARRAY,
        SEQUENCE,
        UNKNOWN;

    }
}

