/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.pythonlink;

import com.sun.jna.NativeLibrary;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private static NativeLibrary jnipython;
    private static boolean loaded;

    static {
        loaded = false;
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        try {
            String absLibPath = Activator.libPath("jnipython");
            jnipython = NativeLibrary.getInstance((String)absLibPath);
            System.load(absLibPath);
            loaded = true;
        }
        catch (Throwable e) {
            LOGGER.error("Loading of jnipython.dll failed", e);
        }
    }

    public static String libPath(String libname) throws IOException, URISyntaxException {
        String libExt = System.mapLibraryName(libname);
        LOGGER.info("lib name is {}", (Object)libExt);
        URL find = FileLocator.find((Bundle)context.getBundle(), (IPath)new Path(libExt));
        URL fileURL = FileLocator.toFileURL((URL)find);
        String absLibPath = new File(URLDecoder.decode(fileURL.getPath(), "UTF-8")).getAbsolutePath();
        LOGGER.info("absLibPath is {}", (Object)absLibPath);
        return absLibPath;
    }

    public static boolean isPythonLoaded() {
        return loaded;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

