/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.SchemaConversionComponent;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.simantics.xml.sax.configuration.Attribute;
import org.simantics.xml.sax.configuration.AttributeComposition;
import org.simantics.xml.sax.configuration.IDReference;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.List;
import org.w3._2001.xmlschema.LocalComplexType;
import org.w3._2001.xmlschema.LocalSimpleType;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.Schema;
import org.w3._2001.xmlschema.SimpleType;

public class OntologyGenerator
implements SchemaConversionComponent {
    SchemaConversionBase base;
    String ontRoot = "ONT.";
    String commentTag = "//";
    Schema schema;
    String ontologyUri;
    String className;
    SchemaConverter converter;
    PrintWriter writer = null;

    public OntologyGenerator(SchemaConverter converter, SchemaConversionBase base) {
        this.base = base;
        this.converter = converter;
        this.schema = base.schema;
        this.ontologyUri = base.ontologyURI;
        this.className = base.className;
    }

    public void createOntology() throws FileNotFoundException {
        StringWriter stringWriter = null;
        if (this.converter.getOntologyFile() == null) {
            stringWriter = new StringWriter();
            this.writer = new PrintWriter(stringWriter);
        } else {
            this.writer = new PrintWriter(this.converter.getOntologyFile());
        }
        this.handle();
        this.writer.flush();
        this.writer.close();
        if (stringWriter != null) {
            System.out.println(stringWriter.toString());
        }
    }

    protected void handle() {
        this.ontRoot = this.converter.shortName;
        String[] stringArray = this.converter.getHeader();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.writer.println(this.commentTag + " " + s);
            ++n2;
        }
        this.writer.println();
        this.writer.println("L0 = <http://www.simantics.org/Layer0-1.1>");
        this.writer.println("XML = <http://www.simantics.org/XML-1.0>");
        this.writer.println();
        if (this.converter.isPrimary()) {
            this.writer.println(this.ontRoot + " = <" + this.ontologyUri + "> : L0.Ontology");
            this.writer.println("   @L0.new");
            this.writer.println("   L0.HasResourceClass \"" + this.className + "\"");
        } else {
            this.writer.println(this.ontRoot + " = <" + this.ontologyUri + ">");
        }
        this.writer.println();
        this.writer.println();
        HashSet<SchemaConverter> children = new HashSet<SchemaConverter>();
        ArrayDeque<SchemaConverter> stack = new ArrayDeque<SchemaConverter>();
        stack.addAll(this.converter.getSubConverters());
        while (!stack.isEmpty()) {
            SchemaConverter sc = (SchemaConverter)stack.pop();
            if (children.contains(sc)) continue;
            children.add(sc);
            stack.addAll(sc.getSubConverters());
        }
        children.remove(this.converter);
        for (SchemaConverter sc : children) {
            this.writer.println(sc.shortName + " = <" + sc.ontologyUri + ">");
        }
        this.writer.println();
        this.ontRoot = String.valueOf(this.ontRoot) + ".";
        this.writer.println(this.ontRoot + "SimpleTypes : L0.Library");
        this.writer.println(this.ontRoot + "ComplexTypes : L0.Library");
        this.writer.println(this.ontRoot + "AttributeGroups : L0.Library");
        this.writer.println(this.ontRoot + "ModelGroups : L0.Library");
        this.writer.println();
        this.writer.println(this.commentTag + " Interpreted from schema");
        this.writer.println();
        this.base.handle(this);
    }

    protected String getType(QName qtype, String rel) {
        String ontType = this.base.getL0TypeFromPrimitiveType(qtype);
        if (ontType != null) {
            return ontType;
        }
        if (this.base.isComplexTypeRef(qtype.getLocalPart())) {
            return this.getName(this.base.getComplexType(qtype), rel);
        }
        if (this.base.isSimpleTypeRef(qtype.getLocalPart())) {
            return this.getName(this.base.getSimpleType(qtype), rel);
        }
        if (this.base.isElementRef(qtype.getLocalPart())) {
            return this.getName(this.base.getElement(qtype), rel);
        }
        throw new RuntimeException("Reference to unknown type " + qtype.getLocalPart());
    }

    @Override
    public String getSimpleTypePrefix() {
        return "SimpleTypes.";
    }

    @Override
    public String getComplexTypePrefix() {
        return "ComplexTypes.";
    }

    @Override
    public String getAttributeGroupPrefix() {
        return "AttributeGroups.";
    }

    @Override
    public String getModelGroupPrefix() {
        return "ModelGroups.";
    }

    @Override
    public String handleChoice(SchemaObject parent, SchemaElement indicator, java.util.List<SchemaElement> elements, String name) {
        boolean single = true;
        for (SchemaElement e : elements) {
            if (!e.getRestriction().many()) continue;
            single = false;
            break;
        }
        String relationName = this.getName(parent) + ".has" + name;
        this.writer.print(relationName);
        this.writer.print(" <R XML.hasElement");
        this.writer.println();
        if (!single) {
            String elementListType = this.getName(parent) + "." + name + "_List";
            this.writer.println(elementListType + " <T XML.ElementList");
            this.writer.println(relationName + "_List <R XML.hasElementList : L0.FunctionalRelation");
            this.writer.println("   --> " + elementListType);
        }
        return relationName;
    }

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement element, String refName, SchemaConversionBase.RefType refType, String baseRelationName) {
        if (refType != SchemaConversionBase.RefType.Element) {
            QName referenceType = null;
            if (refType == SchemaConversionBase.RefType.Type) {
                referenceType = element.getElement().getType();
                SchemaObject eObj = this.base.getElement(element.getElement());
                if (refName == null) {
                    refName = eObj.getName();
                }
            } else {
                referenceType = element.getElement().getRef();
                if (refName == null) {
                    refName = this.base.getName(referenceType);
                }
            }
            String type = this.base.getL0TypeFromPrimitiveType(referenceType);
            SchemaObject obj = null;
            if (type == null) {
                obj = this.base.getWithName(referenceType);
                this.writer.print(this.getName(parent) + ".has" + refName + " <R XML.hasElement <R " + this.getName(obj, "has"));
                if (baseRelationName != null) {
                    this.writer.print(" <R " + baseRelationName);
                }
                this.writer.println();
            } else {
                this.writer.print(this.getName(parent) + ".has" + refName + " <R XML.hasElement");
                if (baseRelationName != null) {
                    this.writer.print(" <R " + baseRelationName);
                }
                this.writer.println();
                this.writer.println("   --> " + this.getType(referenceType, ""));
            }
            if (this.base.useElementList(parent, indicator, element, refType == SchemaConversionBase.RefType.Reference, refName, referenceType)) {
                if (type == null) {
                    this.writer.println(this.getName(parent) + "." + refName + "List <T XML.ElementList");
                    this.writer.println(this.getName(parent) + ".has" + refName + "_List <R " + this.getName(obj, "has") + "_List : L0.FunctionalRelation");
                } else {
                    this.writer.println(this.getName(parent) + "." + refName + "_List <T XML.ElementList");
                    this.writer.println(this.getName(parent) + ".has" + refName + "_List <R XML.hasElementList : L0.FunctionalRelation");
                }
            }
        } else {
            Element attrs = element.getElement();
            SchemaObject obj = this.base.getWithObj(parent, attrs);
            if (refName == null) {
                refName = obj.getName();
            }
            this.writer.print(this.getName(parent) + ".has" + refName + " <R " + this.getName(obj, "has"));
            if (baseRelationName != null) {
                this.writer.print(" <R " + baseRelationName);
            }
            this.writer.println();
            this.writer.println("   --> " + this.getName(obj));
            if (this.base.useElementList(parent, indicator, element, false, refName, new QName(obj.getName()))) {
                this.writer.println(this.getName(parent) + "." + refName + "_List <T XML.ElementList");
                this.writer.println(this.getName(parent) + ".has" + refName + "_List <R " + this.getName(obj, "has") + "_List : L0.FunctionalRelation");
            }
        }
    }

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement any) {
        boolean single = true;
        String relationName = this.getName(parent) + ".hasAny";
        this.writer.print(relationName);
        this.writer.print(" <R XML.hasElement");
        this.writer.println();
        if (!single) {
            String elementListType = this.getName(parent) + ".Any_List";
            this.writer.println(elementListType + " <T XML.ElementList");
            this.writer.println(relationName + "_List <R XML.hasElementList : L0.FunctionalRelation");
            this.writer.println("   --> " + elementListType);
        }
    }

    @Override
    public void handle(SchemaObject parent, NamedGroup group) {
        if (parent != null && parent.getSc() != this.base) {
            return;
        }
        SchemaObject obj = this.base.getModelGroup(group);
        if (obj.getSc() != this.base) {
            return;
        }
        String name = this.base.escapeName(group.getName());
        this.writer.println(this.ontRoot + this.getModelGroupPrefix() + name + " <T XML.ModelGroup");
        this.writer.println(this.ontRoot + this.getModelGroupPrefix() + "has" + name + " <T XML.hasElement");
    }

    @Override
    public void handle(SchemaObject parent, org.w3._2001.xmlschema.Attribute attribute) {
        Object relationType;
        String relationName;
        String name = this.base.getName(attribute);
        QName primitiveType = attribute.getType();
        LocalSimpleType simpleType = attribute.getSimpleType();
        QName ref = attribute.getRef();
        if (name != null) {
            relationName = this.ontRoot + "has" + name;
            if (parent != null) {
                relationName = this.getName(parent) + ".has" + name;
            }
            relationType = "XML.hasAttribute";
        } else if (ref != null && parent != null) {
            relationName = this.getName(parent) + ".has" + this.base.getName(ref);
            relationType = this.converter.getShortName(ref.getNamespaceURI()) + ".has" + this.base.getName(ref);
        } else {
            throw new RuntimeException();
        }
        boolean id = false;
        String ontType = null;
        if (primitiveType != null) {
            ontType = this.base.getL0TypeFromPrimitiveType(primitiveType);
            if (ontType != null && (id = this.base.getTypeEntry((QName)primitiveType).id)) {
                relationType = "XML.hasID";
            }
        } else if (simpleType != null) {
            QName base = this.base.getSimpleTypeBase(simpleType);
            ontType = this.base.getL0TypeFromPrimitiveType(base);
        }
        this.writer.println(relationName + " <R " + (String)relationType + ": L0.FunctionalRelation");
        if (!id) {
            if (ontType != null) {
                this.writer.println("   --> " + ontType);
            } else if (primitiveType != null) {
                this.writer.println("   <R " + this.getType(primitiveType, "has"));
            }
        }
    }

    @Override
    public void handleAttributes(SchemaObject simpleTypeObj) {
    }

    @Override
    public void handle(SchemaObject parent, AttributeGroup attributeGroup) {
        if (parent == null) {
            NamedAttributeGroup group = (NamedAttributeGroup)attributeGroup;
            this.writer.println(this.ontRoot + this.getAttributeGroupPrefix() + group.getName() + " <T XML.AttributeGroup");
            SchemaObject obj = new SchemaObject(this.base, parent, attributeGroup);
            for (Annotated annotated : group.getAttributeOrAttributeGroup()) {
                if (annotated instanceof org.w3._2001.xmlschema.Attribute) {
                    this.handle(obj, (org.w3._2001.xmlschema.Attribute)annotated);
                    continue;
                }
                if (!(annotated instanceof AttributeGroup)) continue;
                this.handle(obj, (AttributeGroup)annotated);
            }
        } else {
            java.util.List<SchemaConverter> convs;
            Object ns = this.ontRoot;
            if (attributeGroup.getRef() != null && (convs = this.converter.getConverter(attributeGroup.getRef().getNamespaceURI())).size() == 1) {
                ns = convs.get((int)0).shortName + ".";
            }
            this.writer.println(this.getName(parent) + " L0.Inherits " + (String)ns + this.getAttributeGroupPrefix() + this.base.getName(attributeGroup.getRef()));
        }
    }

    @Override
    public void handleAttributeComposition(SchemaObject parent, AttributeComposition composition, BijectionMap<Attribute, Annotated> attributes) {
        org.w3._2001.xmlschema.Attribute compositionAttribute = new org.w3._2001.xmlschema.Attribute();
        compositionAttribute.setName(composition.getName());
        QName type = new QName("http://www.simantics.org/Layer0", composition.getType());
        compositionAttribute.setType(type);
        this.handle(parent, compositionAttribute);
    }

    @Override
    public void handleSimpleType(SchemaObject parent, SchemaObject simpleTypeObj) {
        SimpleType simpleType = simpleTypeObj.getSimpleType();
        String name = simpleType.getName();
        List list = simpleType.getList();
        if (list != null) {
            String relationName = this.getName(simpleTypeObj, "has");
            this.writer.println(relationName + " <R XML.hasAttribute : L0.FunctionalRelation");
            String ontType = this.base.getL0Type(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            this.writer.println("   --> " + ontType);
        } else {
            QName base = this.base.getSimpleTypeBase(simpleType);
            this.writer.println(this.getName(simpleTypeObj) + " <T " + this.getType(base, ""));
            String relationName = this.getName(simpleTypeObj, "has");
            this.writer.println(relationName + " : L0.FunctionalRelation");
            this.writer.println("   --> " + this.getName(simpleTypeObj));
        }
    }

    @Override
    public void handleComplexType(SchemaObject topLevelComplexType) {
        String name = this.getName(topLevelComplexType);
        SchemaConversionBase.Inheritance inheritance = this.base.getInheritance(topLevelComplexType);
        if (inheritance.additionalClass != null) {
            this.writer.println(name + " <T " + inheritance.baseClass + " <T " + inheritance.additionalClass);
        } else if (inheritance.atomicType != null) {
            this.writer.println(name + " <T " + inheritance.baseClass + " <T " + inheritance.atomicType.l0Type);
        } else {
            this.writer.println(name + " <T " + inheritance.baseClass);
        }
        this.writer.println(name + "_List <T XML.ElementList");
        String relationName = this.getName(topLevelComplexType, "has");
        this.writer.println(relationName + " <R XML.hasComplexType");
        this.writer.println("   --> " + name);
        this.writer.println(relationName + "_List <R XML.hasElementList");
        this.writer.println("   --> " + name + "_List");
        this.writer.println();
        this.base.handleComplexTypeAttributes(topLevelComplexType);
        this.base.handleComplexTypeExtension(topLevelComplexType);
        this.base.handleExtensionAttributes(topLevelComplexType);
        this.writer.println();
    }

    @Override
    public void handleElement(SchemaObject elementObj) {
        QName substitution;
        QName base;
        if (elementObj.getSc() != this.base) {
            return;
        }
        Element element = elementObj.getElement();
        String name = this.getName(elementObj);
        Object type = "XML.Element";
        LinkedHashSet<Object> types = new LinkedHashSet<Object>();
        if (element.getType() != null) {
            types.add(this.getType(element.getType(), ""));
        }
        if ((base = this.base.getElementBase(element)) != null) {
            if (base.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                String l0Type = this.base.getL0Type(base);
                if (l0Type == null) {
                    throw new RuntimeException("Cannot get L0 type for " + base.getLocalPart());
                }
                types.add(l0Type);
            } else if (this.base.isElementRef(base.getLocalPart())) {
                types.add(this.ontRoot + this.base.getName(base));
            } else {
                types.add(this.ontRoot + this.getComplexTypePrefix() + this.base.getName(base));
            }
        }
        if ((substitution = element.getSubstitutionGroup()) != null) {
            if (this.base.isElementRef(substitution.getLocalPart())) {
                types.add(this.ontRoot + this.base.getName(substitution));
            } else {
                types.add(this.ontRoot + this.getComplexTypePrefix() + this.base.getName(substitution));
            }
        }
        for (String string : types) {
            type = (String)type + " <T " + string;
        }
        String string = this.getName(elementObj, "has");
        this.writer.println(string + " <R XML.hasElement");
        this.writer.println(string + "_List <R XML.hasElementList");
        this.writer.println(name + " <T " + (String)type);
        LocalComplexType complexType = element.getComplexType();
        LocalSimpleType simpleType = element.getSimpleType();
        if (complexType != null) {
            SchemaObject complexTypeObj = this.base.getComplexType(complexType);
            this.base.handleElementComplexTypeAttributes(complexTypeObj);
            this.base.handleComplexTypeExtension(complexTypeObj);
        } else if (simpleType != null) {
            SchemaObject simpleTypeObj = this.base.getSimpleType(simpleType);
            this.base.handleElementSimpleTypeAttributes(simpleTypeObj);
        }
        java.util.List<IDReference> references = this.base.getIDReferences(element);
        for (IDReference ref : references) {
            this.writer.println(name + "." + ref.getReference().getName() + " <R XML.hasReference");
        }
        this.writer.println();
    }

    @Override
    public String getBaseClass(SchemaObject.ObjectType type) {
        if (type == SchemaObject.ObjectType.ELEMENT) {
            return "XML.Element";
        }
        if (type == SchemaObject.ObjectType.COMPLEX_TYPE) {
            return "XML.ComplexType";
        }
        throw new RuntimeException("ObjectType " + String.valueOf((Object)type) + " has no base class");
    }

    @Override
    public String getName(SchemaObject obj) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return obj.getLibShortName() + "." + this.getComplexTypePrefix() + obj.getName();
                }
                case ELEMENT: {
                    return obj.getLibShortName() + "." + obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return obj.getLibShortName() + "." + this.getAttributeGroupPrefix() + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return obj.getLibShortName() + "." + this.getSimpleTypePrefix() + obj.getName();
                }
                case MODEL_GROUP: {
                    return obj.getLibShortName() + "." + this.getModelGroupPrefix() + obj.getName();
                }
                case ATTRIBUTE: {
                    throw new RuntimeException("Cannot query attribute name");
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            Object name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = o.getName() + "." + (String)name;
                }
                prev = o;
                o = o.getParent();
            }
            name = ((String)name).substring(0, ((String)name).length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return obj.getLibShortName() + "." + this.getComplexTypePrefix() + (String)name;
                }
                case ELEMENT: {
                    return obj.getLibShortName() + "." + (String)name;
                }
                case ATTRIBUTE_GROUP: {
                    return obj.getLibShortName() + "." + this.getAttributeGroupPrefix() + (String)name;
                }
                case SIMPLE_TYPE: {
                    return obj.getLibShortName() + "." + this.getSimpleTypePrefix() + (String)name;
                }
                case MODEL_GROUP: {
                    return obj.getLibShortName() + "." + this.getModelGroupPrefix() + (String)name;
                }
                case ATTRIBUTE: {
                    throw new RuntimeException("Cannot query attribute name");
                }
            }
        }
        throw new RuntimeException();
    }

    public String getName(SchemaObject parent, SchemaElement e, String rel) {
        QName ref = e.getElement().getRef();
        if (ref != null) {
            return this.converter.getShortName(ref.getNamespaceURI()) + rel + this.base.getName(ref);
        }
        return this.getName(parent, "") + "." + rel + e.getElement().getName();
    }

    public String getName(SchemaObject obj, String rel) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return obj.getLibShortName() + "." + this.getComplexTypePrefix() + rel + obj.getName();
                }
                case ELEMENT: {
                    return obj.getLibShortName() + "." + rel + obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return obj.getLibShortName() + "." + this.getAttributeGroupPrefix() + rel + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return obj.getLibShortName() + "." + this.getSimpleTypePrefix() + rel + obj.getName();
                }
                case ATTRIBUTE: {
                    return obj.getLibShortName() + "." + rel + obj.getName();
                }
                case MODEL_GROUP: {
                    return obj.getLibShortName() + "." + this.getModelGroupPrefix() + rel + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            Object name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = o.getName() + "." + (String)name;
                }
                prev = o;
                o = o.getParent();
            }
            name = ((String)name).substring(0, ((String)name).length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return obj.getLibShortName() + "." + this.getComplexTypePrefix() + rel + (String)name;
                }
                case ELEMENT: {
                    return obj.getLibShortName() + "." + rel + (String)name;
                }
                case ATTRIBUTE_GROUP: {
                    return obj.getLibShortName() + "." + this.getAttributeGroupPrefix() + rel + (String)name;
                }
                case SIMPLE_TYPE: {
                    return obj.getLibShortName() + "." + this.getSimpleTypePrefix() + rel + (String)name;
                }
                case ATTRIBUTE: {
                    return obj.getLibShortName() + "." + rel + obj.getName();
                }
                case MODEL_GROUP: {
                    return obj.getLibShortName() + "." + this.getModelGroupPrefix() + rel + (String)name;
                }
            }
        }
        throw new RuntimeException();
    }
}

