/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.ui.wizard;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.xml.sax.OntologyCombinator;
import org.simantics.xml.sax.SCLCombinator;

public class SchemaCombinationPage
extends WizardPage {
    private Composite composite;
    File outputPlugin;
    File srcDir;
    CheckboxTableViewer fileSelector;
    Text javaOutputText;
    Text sclOutputText;

    public SchemaCombinationPage() {
        super("XML Schema conversion", "Combining schema versions", null);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.outputPlugin == null) {
                Label label = new Label(this.composite, 0);
                label.setText("Output plug-in has not been set, cannot create combination resources");
                return;
            }
            String name = this.outputPlugin.getName();
            name = name.replaceAll("\\.", "/");
            this.srcDir = new File(this.outputPlugin.getAbsolutePath() + "/src/" + name);
            this.fileSelector.setInput((Object)this.srcDir);
        }
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)this.composite);
        Label label = new Label(this.composite, 0);
        label.setText("Ontology resource files");
        this.fileSelector = CheckboxTableViewer.newCheckList((Composite)this.composite, (int)2048);
        this.fileSelector.setContentProvider((IContentProvider)new FileContentProvider());
        this.fileSelector.setLabelProvider((IBaseLabelProvider)new FileLabelProvider());
        label = new Label(this.composite, 0);
        label.setText("Java Output file");
        this.javaOutputText = new Text(this.composite, 2052);
        label = new Label(this.composite, 0);
        label.setText("SCL Output file");
        this.sclOutputText = new Text(this.composite, 2052);
        Button button = new Button(this.composite, 8);
        button.setText("Combine");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaCombinationPage.this.doCombination();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(this.fileSelector.getControl());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.javaOutputText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.sclOutputText);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)button);
    }

    public void setOutputPlugin(File outputPlugin) {
        this.outputPlugin = outputPlugin;
    }

    private void doCombination() {
        Object[] sel = this.fileSelector.getCheckedElements();
        File[] inputFiles = new File[sel.length];
        int i = 0;
        while (i < sel.length) {
            inputFiles[i] = (File)sel[i];
            ++i;
        }
        try {
            Object sclOutputName;
            Object javaOutputName = this.javaOutputText.getText();
            if (javaOutputName != null && ((String)javaOutputName).length() > 2) {
                if (!((String)javaOutputName).endsWith(".java")) {
                    javaOutputName = (String)javaOutputName + ".java";
                }
                File outputFile = new File(this.srcDir.getAbsolutePath() + "/" + (String)javaOutputName);
                OntologyCombinator combinator = new OntologyCombinator();
                combinator.combine(inputFiles, outputFile);
            }
            if ((sclOutputName = this.sclOutputText.getText()) != null && ((String)sclOutputName).length() > 2) {
                if (!((String)sclOutputName).endsWith(".scl")) {
                    sclOutputName = (String)sclOutputName + ".scl";
                }
                File outputFile = new File(this.srcDir.getAbsolutePath() + "/" + (String)sclOutputName);
                SCLCombinator combinator = new SCLCombinator();
                combinator.combine(inputFiles, outputFile);
            }
            this.setPageComplete(true);
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    private static class FileContentProvider
    implements IStructuredContentProvider {
        private FileContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            File directory = (File)inputElement;
            if (!directory.isDirectory()) {
                return new Object[0];
            }
            Object[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("java");
                }
            });
            return files;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FileLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            File file = (File)element;
            if (columnIndex == 0) {
                return file.getName();
            }
            return null;
        }
    }
}

