/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.ui.datawizard;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.utils.ui.widgets.DirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileOrDirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileSelectionListener;
import org.simantics.utils.ui.widgets.FileSelectionWidget;

public class InputSelectionPage
extends WizardPage
implements FileSelectionListener {
    private FileSelectionWidget schemaSelection;
    private FileSelectionWidget configurationSelection;
    private DirectorySelectionWidget pluginSelection;

    public InputSelectionPage() {
        super("InputPage", "Select input files and output plug-in", null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        this.schemaSelection = new FileSelectionWidget(composite, "XML data files", 4098);
        this.configurationSelection = new FileSelectionWidget(composite, "Configuration file (Optional)", 4096);
        this.pluginSelection = new DirectorySelectionWidget(composite, "Output plug-in", 8192);
        this.schemaSelection.setFilterExtensions(new String[]{"*.*"});
        this.schemaSelection.setFilterNames(new String[]{"XML data files"});
        this.configurationSelection.setFilterExtensions(new String[]{"*.xml"});
        this.configurationSelection.setFilterNames(new String[]{"XML files"});
        this.schemaSelection.addListener((FileSelectionListener)this);
        this.pluginSelection.addListener((FileSelectionListener)this);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public void fileSelected(FileOrDirectorySelectionWidget source, String[] filename) {
        this.setPageComplete(this.schemaSelection.getFilename() != null && this.pluginSelection.getFilename() != null);
    }

    public String[] getDataFilenames() {
        if (this.schemaSelection.getFilename() == null || this.schemaSelection.getFilename().length == 0) {
            return null;
        }
        return this.schemaSelection.getFilename();
    }

    public String getConfigurationFilename() {
        if (this.configurationSelection.getFilename() == null || this.configurationSelection.getFilename().length == 0) {
            return null;
        }
        return this.configurationSelection.getFilename()[0];
    }

    public String getPluginFilename() {
        if (this.pluginSelection.getFilename() == null || this.pluginSelection.getFilename().length == 0) {
            return null;
        }
        return this.pluginSelection.getFilename()[0];
    }
}

