/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base.datatypes.literal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

public class Date
extends Bean
implements org.simantics.xml.sax.base.datatypes.adt.Date {
    public static final Binding BINDING = Bindings.getBindingUnchecked(Date.class);
    public int year;
    public byte month;
    public byte day;
    public int offset;

    public Date() {
        super(BINDING);
    }

    public Date(int year, int month, int day) {
        this(year, month, day, Integer.MIN_VALUE);
    }

    public Date(int year, int month, int day, int offset) {
        super(BINDING);
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("Month must be between 1 - 12, got " + month);
        }
        if (day <= 0 || day > 31) {
            throw new IllegalArgumentException("Day must be between 1 - 31, got " + day);
        }
        this.year = year;
        this.month = (byte)month;
        this.day = (byte)day;
        this.offset = offset;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDate() {
        return this.day;
    }

    @Override
    public int getTimezoneOffset() {
        return this.offset;
    }

    @Override
    public java.util.Date getJavaDate() {
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month, this.day);
        if (this.offset != Integer.MIN_VALUE) {
            c.setTimeZone(TimeZone.getTimeZone(TimeZone.getAvailableIDs(this.offset * 60 * 1000)[0]));
        }
        return c.getTime();
    }

    @Override
    public int compare(org.simantics.xml.sax.base.datatypes.adt.Date o) {
        if (this.getYear() != o.getYear()) {
            return this.getYear() - o.getYear();
        }
        if (this.getMonth() != o.getMonth()) {
            return this.getMonth() - o.getMonth();
        }
        if (this.getDate() != o.getDate()) {
            return this.getDate() - o.getDate();
        }
        return 0;
    }

    public static Date parseDate(String dateString) {
        String[] formats = new String[]{"yyyy-MM-ddXXX", "yyyy-MM-dd"};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] timezone = blArray;
        int i = 0;
        while (i < formats.length) {
            String format = formats[i];
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.ROOT);
                java.util.Date n = dateFormat.parse(dateString);
                if (timezone[i]) {
                    return new Date(n.getYear() + 1900, n.getMonth() + 1, n.getDate(), n.getTimezoneOffset());
                }
                return new Date(n.getYear() + 1900, n.getMonth() + 1, n.getDate());
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        throw new IllegalArgumentException("Time is not in proper format " + dateString);
    }

    public String toString() {
        return this.year + "-" + (this.month < 10 ? "0" : "") + this.month + "-" + (this.day < 10 ? "0" : "") + this.day;
    }
}

