/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.message.ILogger;
import org.simantics.xml.sax.base.WriterElement;
import org.simantics.xml.sax.base.XMLElementNamedChildWriter;
import org.simantics.xml.sax.base.XMLElementWriter;
import org.simantics.xml.sax.base.XMLNSElementWriter;
import org.simantics.xml.sax.base.XMLNSNamedChildWriter;
import org.simantics.xml.sax.base.XMLParser;
import org.simantics.xml.sax.ontology.XMLResource;

public class XMLWriter {
    public static String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    public static String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private ReadGraph graph;
    private Map<Resource, XMLWriter> subWriters = new HashMap<Resource, XMLWriter>();
    private Map<Class<? extends XMLElementWriter>, XMLElementWriter> namedWriters = new HashMap<Class<? extends XMLElementWriter>, XMLElementWriter>();
    private Map<Resource, XMLElementWriter> writers = new HashMap<Resource, XMLElementWriter>();
    private String schemaURI;
    private String ontologyURI;
    private Resource ontology;
    private boolean includeBaseNamespace = true;
    private boolean useCompactEmptyElements = false;
    private boolean addElementNamespacePrefix = false;
    private ILogger logger;
    protected Map<String, String> nsPrefixes;

    public void setUseCompactEmptyElements(boolean compactEmptyElements) {
        this.useCompactEmptyElements = compactEmptyElements;
    }

    public void setIncludeBaseNamespace(boolean includeBaseNamespace) {
        this.includeBaseNamespace = includeBaseNamespace;
    }

    public void setAddElementNamespacePrefix(boolean addElementNamespacePrefix) {
        this.addElementNamespacePrefix = addElementNamespacePrefix;
    }

    public ReadGraph getGraph() {
        return this.graph;
    }

    public void setGraph(ReadGraph graph) throws DatabaseException {
        this.graph = graph;
        for (XMLWriter p : this.subWriters.values()) {
            p.setGraph(graph);
        }
        if (this.ontologyURI != null) {
            this.ontology = graph.getResource(this.ontologyURI);
        }
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void setSchemaURI(String schemaURI) {
        this.schemaURI = schemaURI;
    }

    public String getOntologyURI() {
        return this.ontologyURI;
    }

    public void setOntologyURI(String ontologyURI) {
        this.ontologyURI = ontologyURI;
    }

    public Resource getOntology() {
        return this.ontology;
    }

    public void add(XMLElementWriter writer) throws DatabaseException {
        Resource type = writer.getType(this.graph);
        if (type != null) {
            this.writers.put(type, writer);
        }
        this.namedWriters.put(writer.getClass(), writer);
    }

    public void add(XMLWriter writer) {
        this.subWriters.put(writer.getOntology(), writer);
    }

    public void configureWriter(XMLStreamWriter writer) throws XMLStreamException {
        if (this.nsPrefixes == null) {
            return;
        }
        for (Map.Entry<String, String> nsEntry : this.nsPrefixes.entrySet()) {
            String uri = nsEntry.getKey();
            String prefix = nsEntry.getValue();
            if (uri == null || prefix == null) {
                System.err.println("Skipping null uri/prefix in configureWriter!");
                continue;
            }
            writer.setPrefix(prefix, uri);
        }
    }

    public void writeNS(XMLStreamWriter writer) throws XMLStreamException {
        if (this.nsPrefixes == null) {
            return;
        }
        for (Map.Entry<String, String> nsEntry : this.nsPrefixes.entrySet()) {
            String uri = nsEntry.getKey();
            String prefix = nsEntry.getValue();
            if (uri == null || uri.isEmpty() || prefix == null || prefix.isEmpty()) {
                System.err.println("Skipping null uri/prefix in writeNS!");
                continue;
            }
            writer.writeNamespace(prefix, uri);
        }
    }

    public XMLWriter resolveDependencies(Session session) throws DatabaseException {
        HashMap<String, XMLWriter> map = new HashMap<String, XMLWriter>();
        map.put(this.schemaURI, this);
        this.addDependencies(session, map);
        if (this.nsPrefixes == null) {
            this.nsPrefixes = new HashMap<String, String>();
        }
        int i = 0;
        for (String ns : map.keySet()) {
            if (this.schemaURI == null || this.schemaURI.equals(ns) || this.nsPrefixes.containsKey(ns)) continue;
            this.nsPrefixes.put(ns, "ns" + i);
            ++i;
        }
        return this;
    }

    public void addDependencies(Session session, Map<String, XMLWriter> map) throws DatabaseException {
    }

    public void write(Resource root, XMLStreamWriter writer) throws DatabaseException, XMLStreamException {
        WriterElement element = new WriterElement(this, root);
        this.loadElement(element);
        this.write(element, writer);
    }

    public String getPrefixForSchema(String schema) {
        if (schema == null || this.nsPrefixes == null) {
            return null;
        }
        return this.nsPrefixes.get(schema);
    }

    public String getPrefixForSchema() {
        if (this.schemaURI == null || this.nsPrefixes == null) {
            return null;
        }
        return this.nsPrefixes.get(this.schemaURI);
    }

    protected void write(WriterElement instance, XMLStreamWriter writer) throws DatabaseException, XMLStreamException {
        XMLResource XML = XMLResource.getInstance((ReadGraph)this.graph);
        XMLElementWriter elementWriter = instance.getWriter();
        HashSet<Statement> childElements = new HashSet<Statement>();
        childElements.addAll(this.graph.getStatements(instance.getResource(), XML.hasElement));
        childElements.addAll(this.graph.getStatements(instance.getResource(), XML.hasComplexType));
        HashMap<Resource, WriterElement> elementMap = new HashMap<Resource, WriterElement>();
        for (Statement s : childElements) {
            WriterElement c = new WriterElement(this, instance, s);
            this.loadElement(c);
            elementMap.put(s.getObject(), c);
        }
        LinkedHashSet<Resource> sorted = new LinkedHashSet<Resource>();
        elementWriter.priorityChildren(this.graph, instance, sorted);
        if (this.graph.hasStatement(instance.getResource(), XML.hasOriginalElementList)) {
            Resource originalList = this.graph.getSingleObject(instance.getResource(), XML.hasOriginalElementList);
            List l = ListUtils.toList((ReadGraph)this.graph, (Resource)originalList);
            sorted.addAll(l);
        }
        elementWriter.children(this.graph, instance, sorted);
        boolean emptyElement = childElements.isEmpty() && this.useCompactEmptyElements;
        this.writeElementStart(instance, writer, emptyElement);
        if (instance.getParent() == null) {
            if (this.includeBaseNamespace) {
                if (this.schemaURI != null) {
                    writer.writeDefaultNamespace(this.schemaURI);
                }
                writer.writeNamespace("xsd", XML_SCHEMA_URI);
                writer.writeNamespace("xsi", XML_SCHEMA_INSTANCE_URI);
            }
            this.configureWriter(writer);
            this.writeNS(writer);
        }
        elementWriter.attributes(this.graph, instance, this.graph.getStatements(instance.getResource(), XML.hasAttribute), writer);
        if (this.graph.hasValue(instance.getResource())) {
            elementWriter.characters(this.graph, instance, writer);
        }
        if (!emptyElement) {
            this.writeChildElements(instance, writer, sorted, elementMap, childElements);
        }
        elementWriter.end(this.graph, instance, writer, emptyElement);
    }

    private void writeElementStart(WriterElement instance, XMLStreamWriter writer, boolean emptyElement) throws DatabaseException, XMLStreamException {
        XMLResource XML = XMLResource.getInstance((ReadGraph)this.graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        XMLElementWriter elementWriter = instance.getWriter();
        if (this.addElementNamespacePrefix) {
            XMLWriter subWriter;
            Resource type = null;
            Resource ontology = null;
            if (instance.getResource() != null) {
                Collection types = this.graph.getObjects(instance.getResource(), L0.InstanceOf);
                type = types.size() == 1 ? (Resource)types.iterator().next() : this.graph.getSingleType(instance.getResource(), XML.Entity);
                ontology = this.getOntology(type);
            }
            String schemaURI = this.getSchemaURI();
            String prefixForSchema = this.getPrefixForSchema();
            if (ontology != null && (subWriter = this.subWriters.get(ontology)) != null) {
                String schemaURISub = subWriter.getSchemaURI();
                String prefixForSchemaSub = subWriter.getPrefixForSchema();
                if ((prefixForSchemaSub == null || prefixForSchemaSub.isEmpty()) && schemaURISub != null && !schemaURISub.isEmpty()) {
                    prefixForSchemaSub = this.getPrefixForSchema(schemaURISub);
                }
                if (schemaURISub != null && !schemaURISub.isEmpty() && prefixForSchemaSub != null && !prefixForSchemaSub.isEmpty()) {
                    schemaURI = schemaURISub;
                    prefixForSchema = prefixForSchemaSub;
                }
            }
            if (schemaURI != null && prefixForSchema != null) {
                elementWriter.start(this.graph, instance, writer, prefixForSchema, schemaURI, this.includeBaseNamespace, emptyElement);
            } else {
                elementWriter.start(this.graph, instance, writer, this.includeBaseNamespace, emptyElement);
            }
        } else {
            elementWriter.start(this.graph, instance, writer, this.includeBaseNamespace, emptyElement);
        }
    }

    private void writeChildElements(WriterElement instance, XMLStreamWriter writer, LinkedHashSet<Resource> sorted, Map<Resource, WriterElement> elementMap, Set<Statement> childElements) throws DatabaseException, XMLStreamException {
        WriterElement child;
        HashSet<Resource> processed = new HashSet<Resource>();
        for (Resource r : sorted) {
            if (processed.contains(r)) continue;
            child = elementMap.get(r);
            if (child == null) {
                throw new DatabaseException("Trying to export unregonized resource " + NameUtils.getSafeName((ReadGraph)this.graph, (Resource)r) + " " + String.valueOf(r));
            }
            this.write(child, writer);
            processed.add(r);
        }
        for (Statement stm : childElements) {
            if (processed.contains(stm.getObject())) continue;
            child = elementMap.get(stm.getObject());
            if (child == null) {
                throw new DatabaseException("Trying to export unregonized resource " + NameUtils.getSafeName((ReadGraph)this.graph, (Resource)stm.getObject()) + " " + String.valueOf(stm.getObject()));
            }
            this.write(child, writer);
        }
    }

    private void loadElement(WriterElement child) throws DatabaseException {
        XMLElementWriter childWriter = null;
        if (child.getParent() != null && child.getParent().getWriter() instanceof XMLElementNamedChildWriter) {
            XMLElementNamedChildWriter namedParentWriter = (XMLElementNamedChildWriter)child.getParent().getWriter();
            Class<? extends XMLElementWriter> childWriterClass = namedParentWriter.getWriter(this.graph, this.writers, child);
            if (childWriterClass != null && (childWriter = this.writers.get(childWriterClass)) == null) {
                try {
                    Constructor<? extends XMLElementWriter> c = null;
                    try {
                        c = childWriterClass.getConstructor(ReadGraph.class);
                        childWriter = c.newInstance(this.graph);
                    }
                    catch (NoSuchMethodException e) {
                        c = childWriterClass.getConstructor(new Class[0]);
                        childWriter = c.newInstance(new Object[0]);
                    }
                    this.namedWriters.put(childWriterClass, childWriter);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    String err = "Error processing " + childWriterClass.getName() + " : element writers must have accessible constructor with ReadGraph parameter";
                    this.logger.log((IStatus)new Status(4, XMLParser.PLUGIN_ID, err, (Throwable)e));
                }
            }
        } else {
            Resource type = this.graph.getSingleType(child.getResource());
            childWriter = this.writers.get(type);
        }
        if (childWriter == null) {
            XMLResource XML = XMLResource.getInstance((ReadGraph)this.graph);
            Resource type = this.graph.getSingleType(child.getResource(), XML.Entity);
            Resource ontology = this.getOntology(type);
            if (ontology != null) {
                XMLWriter xmlWriter = this.writerForOntology(ontology);
                childWriter = this.getElementWriter(xmlWriter, type, true);
            }
            if (childWriter == null) {
                throw new DatabaseException("Cannot locate writer for " + NameUtils.getSafeName((ReadGraph)this.graph, (Resource)child.getResource()) + ", " + String.valueOf(child.getResource()));
            }
        }
        child.setWriter(childWriter);
    }

    private Resource getOntology(Resource type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        Resource r = type;
        while ((r = this.graph.getPossibleObject(r, L0.PartOf)) != null && !this.graph.isInstanceOf(r, L0.Ontology)) {
        }
        return r;
    }

    private XMLWriter writerForOntology(Resource ontology) {
        XMLWriter xmlWriter = this.subWriters.get(ontology);
        if (xmlWriter == null) {
            for (XMLWriter w : this.subWriters.values()) {
                xmlWriter = w.subWriters.get(ontology);
                if (xmlWriter != null) break;
            }
        }
        return xmlWriter;
    }

    private XMLElementWriter getElementWriter(XMLWriter xmlWriter, Resource type, boolean instance) {
        if (xmlWriter == null) {
            return null;
        }
        XMLElementWriter childWriter = xmlWriter.writers.get(type);
        if (childWriter != null && instance) {
            childWriter = childWriter instanceof XMLElementNamedChildWriter ? new XMLNSNamedChildWriter((XMLElementNamedChildWriter)childWriter, xmlWriter.schemaURI) : new XMLNSElementWriter(childWriter, xmlWriter.schemaURI);
        }
        return childWriter;
    }

    public XMLElementWriter getWriter(WriterElement child) throws DatabaseException {
        XMLResource XML = XMLResource.getInstance((ReadGraph)this.graph);
        Resource type = this.graph.getSingleType(child.getResource(), XML.Entity);
        Resource ontology = this.getOntology(type);
        if (ontology == null) {
            return null;
        }
        XMLWriter xmlWriter = this.writerForOntology(ontology);
        return this.getElementWriter(xmlWriter, type, false);
    }
}

