/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.util.Deque;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.xml.sax.base.ParserElement;
import org.simantics.xml.sax.base.XMLElementParserBase;

public class ValueElementParser
extends XMLElementParserBase {
    String name;
    Binding binding;
    String relationURI;

    public ValueElementParser(String name, String relationURI, Binding binding) {
        this.name = name;
        this.relationURI = relationURI;
        this.binding = binding;
    }

    @Override
    public String getElementId() {
        return this.name;
    }

    @Override
    public Resource create(WriteGraph graph, ParserElement element) throws DatabaseException {
        Resource res = graph.newResource();
        return res;
    }

    @Override
    public void configure(WriteGraph graph, Deque<ParserElement> parents, ParserElement element) throws DatabaseException {
    }

    @Override
    public boolean connectParent(WriteGraph graph, ParserElement parent, ParserElement element) throws DatabaseException {
        graph.claim(parent.getData(), graph.getResource(this.relationURI), element.getData());
        return true;
    }

    @Override
    public boolean connectChild(WriteGraph graph, ParserElement element, ParserElement child) throws DatabaseException {
        return false;
    }

    @Override
    public void configure(WriteGraph graph, ParserElement element, String string) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (this.binding == Bindings.STRING) {
            graph.claim(element.getData(), l0.InstanceOf, l0.String);
            graph.claimValue(element.getData(), (Object)string, this.binding);
        } else if (this.binding == Bindings.INTEGER) {
            graph.claim(element.getData(), l0.InstanceOf, l0.Integer);
            graph.claimValue(element.getData(), (Object)Integer.parseInt(string), this.binding);
        } else if (this.binding == Bindings.FLOAT) {
            graph.claim(element.getData(), l0.InstanceOf, l0.Float);
            graph.claimValue(element.getData(), (Object)Float.valueOf(Float.parseFloat(string)), this.binding);
        } else if (this.binding == Bindings.DOUBLE) {
            graph.claim(element.getData(), l0.InstanceOf, l0.Double);
            graph.claimValue(element.getData(), (Object)Double.parseDouble(string), this.binding);
        } else if (this.binding == Bindings.BOOLEAN) {
            graph.claim(element.getData(), l0.InstanceOf, l0.Boolean);
            graph.claimValue(element.getData(), (Object)Boolean.parseBoolean(string), this.binding);
        } else if (this.binding == Bindings.LONG) {
            graph.claim(element.getData(), l0.InstanceOf, l0.Long);
            graph.claimValue(element.getData(), (Object)Long.parseLong(string), this.binding);
        } else if (this.binding == Bindings.BYTE) {
            graph.claim(element.getData(), l0.InstanceOf, l0.Byte);
            graph.claimValue(element.getData(), (Object)Byte.parseByte(string), this.binding);
        } else {
            throw new DatabaseException("Unknown datatype " + String.valueOf(this.binding));
        }
    }
}

