/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.MapList;
import org.simantics.xml.sax.base.Attribute;
import org.simantics.xml.sax.base.XMLElementParser;
import org.simantics.xml.sax.base.XMLParser;
import org.xml.sax.Attributes;

public class ParserElement
implements Serializable {
    private static final long serialVersionUID = -5207502156942818875L;
    private String uri;
    private String localName;
    private String qName;
    Map<String, Attribute> attributes;
    MapList<Resource, ParserElement> lists;
    XMLElementParser elementParser;
    XMLParser xmlParser;
    Map<String, String> nsMap;
    private ParserElement parent;
    private Resource data;

    public ParserElement(String uri, String localName, String qName, Attributes attributes) {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        int attrCount = attributes.getLength();
        this.attributes = new HashMap<String, Attribute>(attrCount);
        int i = 0;
        while (i < attrCount) {
            this.attributes.put(attributes.getLocalName(i), new Attribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i)));
            ++i;
        }
        this.processNS();
    }

    public ParserElement(String uri, String localName, String qName, Collection<Attribute> attributes) {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.attributes = new HashMap<String, Attribute>(attributes.size());
        for (Attribute a : attributes) {
            this.attributes.put(a.localName, new Attribute(a.localName, a.qName, a.uri, a.value));
        }
        this.processNS();
    }

    public ParserElement(ParserElement parent, String uri, String localName, String qName, Attributes attributes) {
        this.parent = parent;
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        int attrCount = attributes.getLength();
        this.attributes = new HashMap<String, Attribute>(attrCount);
        int i = 0;
        while (i < attrCount) {
            this.attributes.put(attributes.getLocalName(i), new Attribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i)));
            ++i;
        }
        this.processNS();
    }

    public ParserElement(ParserElement parent, String uri, String localName, String qName, Collection<Attribute> attributes) {
        this.parent = parent;
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.attributes = new HashMap<String, Attribute>(attributes.size());
        for (Attribute a : attributes) {
            this.attributes.put(a.localName, new Attribute(a.localName, a.qName, a.uri, a.value));
        }
        this.processNS();
    }

    private void processNS() {
        this.nsMap = new HashMap<String, String>();
        for (Attribute a : this.attributes.values()) {
            String[] ns;
            if (!a.localName.startsWith("xmlns") || (ns = a.localName.split(":")).length != 2) continue;
            this.nsMap.put(ns[1], a.value);
        }
        HashMap<String, Attribute> newAttrs = new HashMap<String, Attribute>();
        for (Attribute a : this.attributes.values()) {
            String[] ns = a.localName.split(":");
            if (ns.length == 2) {
                if ("xmlns".equals(ns[0]) || "xml".equals(ns[0])) continue;
                String namespace = this.getNS(ns[0]);
                if (namespace != null) {
                    if (newAttrs.put(ns[1], new Attribute(ns[1], a.qName, namespace, a.value)) == null) continue;
                    throw new RuntimeException("XML parser internal error, overlapping attribute names " + ns[1]);
                }
                throw new RuntimeException("XML parser error, namespace " + ns[0] + " for attribute " + a.localName + " not defined.");
            }
            newAttrs.put(a.localName, a);
        }
        this.attributes = newAttrs;
        String[] nameNs = this.qName.split(":");
        if (nameNs.length == 2) {
            this.localName = nameNs[1];
            if (this.uri.length() == 0) {
                this.uri = this.getNS(nameNs[0]) + "/" + this.localName;
            }
        } else if (this.localName.length() == 0) {
            this.localName = this.qName;
        }
    }

    public String getNS(String key) {
        String ns = this.nsMap.get(key);
        if (ns == null && this.parent != null) {
            ns = this.parent.getNS(key);
        }
        return ns;
    }

    public String getUri() {
        return this.uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getQName() {
        return this.qName;
    }

    public QName getFullName() {
        if (this.uri.endsWith(this.localName)) {
            return new QName(this.uri.substring(0, this.uri.length() - this.localName.length() - 1), this.localName);
        }
        return new QName(this.uri, this.localName);
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes.values();
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setData(Resource data) {
        this.data = data;
    }

    public Resource getData() {
        return this.data;
    }

    public void setElementParser(XMLElementParser parser) {
        this.elementParser = parser;
    }

    public XMLElementParser getElementParser() {
        return this.elementParser;
    }

    public void setXMLParser(XMLParser parser) {
        this.xmlParser = parser;
    }

    public XMLParser getXMLParser() {
        return this.xmlParser;
    }

    public void registerListChild(Resource predicate, ParserElement child) {
        if (this.lists == null) {
            this.lists = new MapList();
        }
        this.lists.add((Object)predicate, (Object)child);
    }

    public void createLists(WriteGraph graph) throws DatabaseException {
        if (this.lists == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource predicate : this.lists.getKeys()) {
            ArrayList<Resource> children = new ArrayList<Resource>();
            for (ParserElement child : this.lists.getValues((Object)predicate)) {
                children.add(child.getData());
            }
            Resource list = this.xmlParser.createList(graph, children);
            graph.claim(this.getData(), predicate, list);
        }
    }

    public void claimLiteral(WriteGraph graph, Resource relation, Resource typ, Object value, Binding binding) throws DatabaseException {
        this.xmlParser.claimLiteral(graph, this, relation, typ, value, binding);
    }
}

