/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.db.Statement;

public class Path {
    private Resource begin;
    private Resource end;
    private List<Statement> statements = new ArrayList<Statement>(2);

    public Path(Statement s) {
        this.begin = s.getSubject();
        this.end = s.getObject();
        this.statements.add(s);
    }

    public Path(Path p) {
        this.begin = p.begin;
        this.end = p.end;
        this.statements.addAll(p.statements);
    }

    public Resource getBegin() {
        return this.begin;
    }

    public Resource getEnd() {
        return this.end;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public int getLength() {
        return this.statements.size();
    }

    public boolean add(Statement s) {
        if (!this.statements.get(this.statements.size() - 1).getObject().equals(s.getSubject())) {
            return false;
        }
        if (s.getObject().equals(this.begin)) {
            return false;
        }
        for (Statement stm : this.statements) {
            if (!stm.getObject().equals(s.getObject())) continue;
            return false;
        }
        this.end = s.getObject();
        this.statements.add(s);
        return true;
    }

    public static Collection<Path> expand(Path path, Collection<Statement> statements) {
        ArrayList<Path> result = new ArrayList<Path>(statements.size());
        for (Statement s : statements) {
            Path p = new Path(path);
            p.add(s);
            result.add(p);
        }
        return result;
    }

    public static Collection<Path> create(Collection<Statement> statements) {
        ArrayList<Path> result = new ArrayList<Path>(statements.size());
        for (Statement s : statements) {
            Path p = new Path(s);
            result.add(p);
        }
        return result;
    }

    public boolean equals(Object arg0) {
        if (!arg0.getClass().equals(this.getClass())) {
            return false;
        }
        Path other = (Path)arg0;
        if (!this.begin.equals(other.begin)) {
            return false;
        }
        if (!this.end.equals(other.end)) {
            return false;
        }
        if (this.statements.size() != other.statements.size()) {
            return false;
        }
        int i = 0;
        while (i < this.statements.size()) {
            if (!this.statements.get(i).getPredicate().equals(other.statements.get(i).getPredicate()) || !this.statements.get(i).getObject().equals(other.statements.get(i).getObject())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.begin.hashCode() + this.end.hashCode();
    }

    public String toString() {
        Object s = "";
        int i = 0;
        while (i < this.statements.size()) {
            s = (String)s + String.valueOf(this.statements.get(i).getSubject());
            s = (String)s + "<" + String.valueOf(this.statements.get(i).getPredicate()) + ">";
            if (i == this.statements.size() - 1) {
                s = (String)s + String.valueOf(this.statements.get(i).getObject());
            }
            ++i;
        }
        return s;
    }
}

