/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.layer0.Layer0;

public abstract class UpdateOp {
    private GraphChanges changes;
    private boolean selected = false;
    private boolean manualSelection = false;
    protected boolean applied = false;
    protected boolean visible = true;
    protected boolean enabled = true;
    private Collection<UpdateOp> parentOps = new ArrayList<UpdateOp>();
    private Collection<UpdateOp> subOps = new ArrayList<UpdateOp>();

    public UpdateOp(GraphChanges changes) {
        this.changes = changes;
    }

    public Collection<UpdateOp> getParentOps() {
        return this.parentOps;
    }

    public <T extends UpdateOp> Collection<T> getParentOpsWithClass(Class<T> cls) {
        ArrayList<UpdateOp> ops = new ArrayList<UpdateOp>(this.parentOps.size());
        for (UpdateOp op : this.parentOps) {
            if (!cls.isAssignableFrom(op.getClass())) continue;
            ops.add(op);
        }
        return ops;
    }

    public Collection<UpdateOp> getSubOps() {
        return this.subOps;
    }

    public <T extends UpdateOp> Collection<T> getSubOpsWithClass(Class<T> cls) {
        ArrayList<UpdateOp> ops = new ArrayList<UpdateOp>(this.subOps.size());
        for (UpdateOp op : this.subOps) {
            if (!cls.isAssignableFrom(op.getClass())) continue;
            ops.add(op);
        }
        return ops;
    }

    public void addParentOp(UpdateOp op) {
        assert (!op.equals(this));
        if (this.parentOps.contains(op)) {
            return;
        }
        this.parentOps.add(op);
    }

    public void addSubOp(UpdateOp op) {
        assert (!op.equals(this));
        if (this.subOps.contains(op)) {
            return;
        }
        this.subOps.add(op);
    }

    public void removeParentOp(UpdateOp op) {
        this.parentOps.remove(op);
    }

    public void removeSubOp(UpdateOp op) {
        this.subOps.remove(op);
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public abstract boolean isAdd();

    public abstract boolean isDelete();

    public boolean isChange() {
        return this.isAdd() || this.isDelete();
    }

    public boolean requiresOp(UpdateOp op) {
        return false;
    }

    public boolean selectOp(UpdateOp op, boolean select) {
        return this.requiresOp(op);
    }

    public boolean select(boolean select) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isChange()) {
            return false;
        }
        boolean b = this._select(select);
        if (b) {
            this.manualSelection = true;
        }
        return b;
    }

    private boolean _select(boolean select) {
        if (select == this.selected) {
            return true;
        }
        if (this.applied) {
            return false;
        }
        if (select) {
            this.selected = true;
            this.manualSelection = false;
            for (UpdateOp op : this.parentOps) {
                if (!this.selectOp(op, true)) continue;
                op._select(true);
            }
            for (UpdateOp op : this.subOps) {
                if (!this.selectOp(op, true)) continue;
                op._select(true);
            }
            return true;
        }
        this.selected = false;
        this.manualSelection = false;
        for (UpdateOp op : this.subOps) {
            if (this.selectOp(op, false)) {
                op._select(false);
                continue;
            }
            if (op.manualSelection) continue;
            op._select(false);
        }
        for (UpdateOp op : this.parentOps) {
            if (!this.selectOp(op, false)) continue;
            op._select(false);
        }
        return true;
    }

    public boolean selected() {
        if (!this.isChange()) {
            return false;
        }
        return this.selected;
    }

    public boolean applied() {
        return this.applied;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void apply(WriteGraph g) throws DatabaseException {
        if (this.applied) {
            return;
        }
        this._apply(g);
        this.applied = true;
    }

    protected abstract void _apply(WriteGraph var1) throws DatabaseException;

    public abstract Resource getResource();

    public abstract Statement getStatement();

    public abstract Resource getCreatedResource();

    public Resource getParentResource(ReadGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        return g.getPossibleObject(this.getResource(), l0.PartOf);
    }

    public String toString() {
        Object s = this.getClass().getSimpleName();
        if (this.selected) {
            s = (String)s + " selected";
        }
        if (this.enabled) {
            s = (String)s + " enabled";
        }
        if (this.visible) {
            s = (String)s + " visible";
        }
        if (this.applied) {
            s = (String)s + " applied";
        }
        return s;
    }
}

