/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ResourceIdentifiable;

public class ResourceSetIdentifiable
implements Identifiable {
    private Resource primary;
    private Set<Resource> resources = new HashSet<Resource>();

    public ResourceSetIdentifiable(Resource resource) {
        this.resources.add(resource);
        this.primary = resource;
    }

    public ResourceSetIdentifiable(Resource primary, Resource ... resource) {
        Resource[] resourceArray = resource;
        int n = resource.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.resources.add(r);
            ++n2;
        }
        this.resources.add(primary);
        this.primary = primary;
    }

    public ResourceSetIdentifiable(Resource primary, Collection<Resource> resource) {
        for (Resource r : resource) {
            this.resources.add(r);
        }
        this.resources.add(primary);
        this.primary = primary;
    }

    public ResourceSetIdentifiable(Collection<Resource> resource) {
        for (Resource r : resource) {
            this.resources.add(r);
        }
        this.primary = resource.iterator().next();
    }

    public Resource getPrimary() {
        return this.primary;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public int hashCode() {
        return this.resources.hashCode();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz.equals(Resource.class)) {
            return (T)this.primary;
        }
        if (clazz.equals(Resource[].class)) {
            return (T)this.resources.toArray(new Resource[this.resources.size()]);
        }
        if (clazz.equals(String.class)) {
            Object s = "";
            for (Resource r : this.resources) {
                s = (String)s + r.toString() + " ";
            }
            return (T)s;
        }
        return null;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ResourceSetIdentifiable other = (ResourceSetIdentifiable)arg0;
        return this.resources.equals(other.resources);
    }

    @Override
    public Identifiable merge(Identifiable other) {
        if (other instanceof ResourceIdentifiable) {
            ArrayList<Resource> coll = new ArrayList<Resource>();
            coll.addAll(this.resources);
            coll.add(((ResourceIdentifiable)other).getResource());
            ResourceSetIdentifiable i = new ResourceSetIdentifiable(this.primary, coll);
            return i;
        }
        if (other instanceof ResourceSetIdentifiable) {
            ArrayList<Resource> coll = new ArrayList<Resource>();
            coll.addAll(this.resources);
            coll.addAll(((ResourceSetIdentifiable)other).getResources());
            ResourceSetIdentifiable i = new ResourceSetIdentifiable(this.primary, coll);
            return i;
        }
        return null;
    }

    public String toString() {
        Object s = "(";
        for (Resource r : this.resources) {
            s = (String)s + r.toString() + " ";
        }
        s = ((String)s).substring(0, ((String)s).length() - 1) + ")";
        return s;
    }
}

