/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import org.simantics.interop.mapping.data.GraphNode;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class Link<T>
extends HintContext {
    private GraphNode<T> from;
    private GraphNode<T> to;
    private String name;
    private Link<T> inverseLink;
    private Link<T> mainLink;

    Link(GraphNode<T> from, String name, GraphNode<T> to) {
        this.from = from;
        this.to = to;
        this.name = name;
    }

    public GraphNode<T> from() {
        return this.from;
    }

    public GraphNode<T> to() {
        return this.to;
    }

    public String getName() {
        return this.name;
    }

    void setInverseLink(Link<T> inverseLink) {
        this.inverseLink = inverseLink;
    }

    void setMainLink(Link<T> mainLink) {
        this.mainLink = mainLink;
    }

    public String getInverseName() {
        if (this.inverseLink != null) {
            return this.inverseLink.getName();
        }
        if (this.mainLink != null) {
            return this.mainLink.getName();
        }
        return null;
    }

    public boolean hasInverse() {
        return this.inverseLink != null || this.mainLink != null;
    }

    public Link<T> getInverse() {
        if (this.inverseLink != null) {
            return this.inverseLink;
        }
        if (this.mainLink != null) {
            return this.mainLink;
        }
        return null;
    }

    public boolean isInverse() {
        return this.mainLink != null;
    }

    public boolean isMain() {
        return this.inverseLink != null;
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        Link other = (Link)((Object)obj);
        if (!this.from.equals(other.from)) {
            return false;
        }
        if (!this.to.equals(other.to)) {
            return false;
        }
        return GraphNode.equals(this.name, other.name);
    }

    public int hashCode() {
        return this.from.hashCode() * this.to.hashCode() + this.name.hashCode();
    }

    public void setHint(IHintContext.Key key, Object value) {
        if (value == null) {
            return;
        }
        super.setHint(key, value);
    }

    public String toString() {
        return this.name + "/" + this.getInverseName() + " -> " + this.to.toString();
    }
}

