/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser;

import org.apache.poi.ss.usermodel.Row;
import org.simantics.excel.poi.parser.CellStringDataResolver;

public class CellContentDataResolver
extends CellStringDataResolver {
    int column;
    int element;
    String separator;
    boolean cut = true;

    public CellContentDataResolver(int column, int element, String separator) {
        super(column);
        this.column = column;
        this.element = element;
        this.separator = separator;
    }

    public CellContentDataResolver(int column, int element, String separator, boolean cut) {
        super(column);
        this.column = column;
        this.element = element;
        this.separator = separator;
        this.cut = cut;
    }

    @Override
    public String getValue(Row row) {
        if (row == null) {
            return null;
        }
        return this.getSubString(row);
    }

    protected String getSubString(Row row) {
        String s = this.getCellStringValue(this.getCell(row, this.column));
        if (this.cut) {
            String[] vals = s.split(this.separator);
            if (vals.length > this.element) {
                return vals[this.element];
            }
        } else {
            int index = -1;
            int i = 0;
            while (i < this.element) {
                if ((index = s.indexOf(this.separator, index + 1)) == -1) {
                    return null;
                }
                ++i;
            }
            return s.substring(index + 1);
        }
        return null;
    }
}

