/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural;

import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class StructuralResource {
    private Resource resource;
    private List<Resource> context = new ArrayList<Resource>(1);
    private Resource typeResource = null;

    public StructuralResource(Resource resource) {
        assert (resource != null);
        this.resource = resource;
    }

    public StructuralResource(ReadGraph g, Resource resource, Resource context) throws DatabaseException {
        assert (resource != null);
        this.resource = resource;
        this.context.add(context);
        this.resolveType(g);
    }

    public StructuralResource(ReadGraph g, Resource resource, Resource ... context) throws DatabaseException {
        assert (resource != null);
        this.resource = resource;
        Resource[] resourceArray = context;
        int n = context.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.context.add(r);
            ++n2;
        }
        this.resolveType(g);
    }

    public StructuralResource(ReadGraph g, Resource resource, List<Resource> context) throws DatabaseException {
        assert (resource != null);
        this.resource = resource;
        for (Resource r : context) {
            this.context.add(r);
        }
        this.resolveType(g);
    }

    public StructuralResource(ReadGraph g, Resource resource, List<Resource> context, Resource context2) throws DatabaseException {
        assert (resource != null);
        this.resource = resource;
        for (Resource r : context) {
            this.context.add(r);
        }
        this.context.add(context2);
        this.resolveType(g);
    }

    private void resolveType(ReadGraph g) throws DatabaseException {
        if (this.context.contains(this.resource)) {
            Layer0 l0 = Layer0.getInstance((ReadGraph)g);
            this.typeResource = g.getSingleObject(this.resource, l0.InstanceOf);
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public List<Resource> getContext() {
        return this.context;
    }

    public Resource getTypeResource() {
        return this.typeResource;
    }

    public boolean isStructural() {
        return this.context.size() > 0;
    }

    public boolean isStructuralRoot() {
        return this.context.size() == 1 && this.context.get(0).equals(this.resource);
    }

    public boolean isStructuralInstance() {
        return this.typeResource != null;
    }

    public int hashCode() {
        int hashCode = this.resource.hashCode();
        for (Resource ctx : this.context) {
            hashCode += ctx.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        StructuralResource other = (StructuralResource)obj;
        if (!this.resource.equals(other.resource)) {
            return false;
        }
        if (this.context.size() != other.context.size()) {
            return false;
        }
        int i = 0;
        while (i < this.context.size()) {
            if (!this.context.get(i).equals(other.context.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String s = "Res: " + String.valueOf(this.resource) + " Context:";
        for (Resource ctx : this.context) {
            s = s + " " + String.valueOf(ctx);
        }
        if (this.typeResource != null) {
            s = s + " Type: " + String.valueOf(this.typeResource);
        }
        return s;
    }
}

