/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.annotations.NotNull;
import com.strobel.componentmodel.Key;
import com.strobel.componentmodel.UserDataStore;
import com.strobel.componentmodel.UserDataStoreBase;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Freezable;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.Region;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;
import com.strobel.decompiler.utilities.TreeTraversal;
import com.strobel.functions.Function;
import com.strobel.util.ContractUtils;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AstNode
extends Freezable
implements INode,
UserDataStore,
Cloneable {
    static final Role<AstNode> ROOT_ROLE = new Role<AstNode>("Root", AstNode.class);
    static final int ROLE_INDEX_MASK = 511;
    static final int FROZEN_BIT = 512;
    protected static final int AST_NODE_USED_FLAGS = 10;
    protected int flags = ROOT_ROLE.getIndex();
    private AstNode _parent;
    private AstNode _previousSibling;
    private AstNode _nextSibling;
    private AstNode _firstChild;
    private AstNode _lastChild;
    public static final AstNode NULL = new NullAstNode();
    private final UserDataStore _dataStore = new UserDataStoreBase();

    protected AstNode() {
        if (this.isNull()) {
            this.freeze();
        }
    }

    protected static boolean matchString(String pattern, String text) {
        return Pattern.matchString(pattern, text);
    }

    public static boolean isLoop(AstNode statement) {
        return statement instanceof ForStatement || statement instanceof ForEachStatement || statement instanceof WhileStatement || statement instanceof DoWhileStatement;
    }

    public static boolean isUnconditionalBranch(AstNode statement) {
        return statement instanceof GotoStatement || statement instanceof ReturnStatement || statement instanceof BreakStatement || statement instanceof ContinueStatement;
    }

    final void setRoleUnsafe(Role<?> role) {
        this.flags = this.flags & 0xFFFFFE00 | role.getIndex();
    }

    public abstract <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> var1, T var2);

    public AstNode clone() {
        try {
            AstNode clone = (AstNode)super.clone();
            clone._parent = null;
            clone._firstChild = null;
            clone._lastChild = null;
            clone._previousSibling = null;
            clone._nextSibling = null;
            clone.flags &= 0xFFFFFDFF;
            for (Key<?> key : Keys.ALL_KEYS) {
                AstNode.copyKey(this, clone, key);
            }
            AstNode current = this._firstChild;
            while (current != null) {
                clone.addChildUnsafe(current.clone(), current.getRole());
                current = current._nextSibling;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void copyUserDataFrom(AstNode source) {
        VerifyArgument.notNull((Object)source, (String)"source");
        for (Key<?> key : Keys.ALL_KEYS) {
            AstNode.copyKey(source, this, key);
        }
    }

    private static <T> void copyKey(AstNode source, AstNode target, Key<T> key) {
        target._dataStore.putUserDataIfAbsent(key, source._dataStore.getUserData(key));
    }

    public final AstNode getParent() {
        return this._parent;
    }

    public final AstNode getPreviousSibling() {
        return this._previousSibling;
    }

    public final AstNode getLastChild() {
        return this._lastChild;
    }

    @Override
    public final AstNode getFirstChild() {
        return this._firstChild;
    }

    @Override
    public final AstNode getNextSibling() {
        return this._nextSibling;
    }

    public final <T extends AstNode> T getPreviousSibling(Role<? extends T> role) {
        for (AstNode current = this._previousSibling; current != null; current = current.getPreviousSibling()) {
            if (current.getRole() != role) continue;
            return (T)current;
        }
        return null;
    }

    public final <T extends AstNode> T getNextSibling(Role<? extends T> role) {
        for (AstNode current = this._nextSibling; current != null; current = current.getNextSibling()) {
            if (current.getRole() != role) continue;
            return (T)current;
        }
        return null;
    }

    public final boolean hasChildren() {
        return this._firstChild != null;
    }

    public final AstNode getNextNode() {
        AstNode nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        AstNode parent = this.getParent();
        if (parent != null) {
            return parent.getNextNode();
        }
        return null;
    }

    public final AstNode getPreviousNode() {
        AstNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            return previousSibling;
        }
        AstNode parent = this.getParent();
        if (parent != null) {
            return parent.getPreviousNode();
        }
        return null;
    }

    public final Iterable<AstNode> getChildren() {
        return new Iterable<AstNode>(){

            @Override
            @NotNull
            public final Iterator<AstNode> iterator() {
                return new Iterator<AstNode>(){
                    AstNode next;
                    {
                        this.next = AstNode.this._firstChild;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public final AstNode next() {
                        AstNode result = this.next;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = result._nextSibling;
                        return result;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }

    public final boolean isAncestorOf(AstNode node) {
        return this.isAncestorOf(node, null);
    }

    public final boolean isAncestorOf(AstNode node, AstNode stopAt) {
        AstNode n = node;
        while (n != null) {
            if (n == this) {
                return true;
            }
            if (n == stopAt) break;
            n = n._parent;
        }
        return false;
    }

    public final boolean isDescendantOf(AstNode node) {
        return node != null && node.isAncestorOf(this);
    }

    public final <T extends AstNode> Iterable<T> getAncestors(@NotNull Class<T> type) {
        VerifyArgument.notNull(type, (String)"type");
        return CollectionUtilities.ofType(this.getAncestors(), type);
    }

    public final Iterable<AstNode> getAncestors() {
        return new Iterable<AstNode>(){

            @Override
            @NotNull
            public final Iterator<AstNode> iterator() {
                return new Iterator<AstNode>(){
                    AstNode next;
                    {
                        this.next = AstNode.this._parent;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public final AstNode next() {
                        AstNode result = this.next;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = result._parent;
                        return result;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }

    public final Iterable<AstNode> getAncestorsAndSelf() {
        return new Iterable<AstNode>(){

            @Override
            @NotNull
            public final Iterator<AstNode> iterator() {
                return new Iterator<AstNode>(){
                    AstNode next;
                    {
                        this.next = AstNode.this;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public final AstNode next() {
                        AstNode result = this.next;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = result._parent;
                        return result;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }

    public final Iterable<AstNode> getDescendants() {
        return TreeTraversal.preOrder(this.getChildren(), new Function<AstNode, Iterable<AstNode>>(){

            public Iterable<AstNode> apply(AstNode n) {
                return n.getChildren();
            }
        });
    }

    public final Iterable<AstNode> getDescendantsAndSelf() {
        return TreeTraversal.preOrder(this, new Function<AstNode, Iterable<AstNode>>(){

            public Iterable<AstNode> apply(AstNode n) {
                return n.getChildren();
            }
        });
    }

    @NotNull
    public final <T extends AstNode> T getChildByRole(Role<T> role) {
        VerifyArgument.notNull(role, (String)"role");
        int roleIndex = role.getIndex();
        AstNode current = this._firstChild;
        while (current != null) {
            if ((current.flags & 0x1FF) == roleIndex) {
                return (T)current;
            }
            current = current._nextSibling;
        }
        return (T)((AstNode)role.getNullObject());
    }

    @NotNull
    public final <T extends AstNode> AstNodeCollection<T> getChildrenByRole(Role<T> role) {
        return new AstNodeCollection<T>(this, role);
    }

    protected final <T extends AstNode> void setChildByRole(Role<T> role, T newChild) {
        T oldChild = this.getChildByRole(role);
        if (((AstNode)oldChild).isNull()) {
            this.addChild(newChild, role);
        } else {
            ((AstNode)oldChild).replaceWith(newChild);
        }
    }

    public final <T extends AstNode> T getParent(Class<T> nodeType) {
        for (AstNode node : this.getAncestors()) {
            if (!nodeType.isInstance(node)) continue;
            return (T)node;
        }
        return null;
    }

    public final <T extends AstNode> void addChild(T child, Role<? extends T> role) {
        VerifyArgument.notNull(role, (String)"role");
        if (child == null || child.isNull()) {
            return;
        }
        this.verifyNotFrozen();
        if (child._parent != null) {
            throw new IllegalArgumentException("Node belongs to another tree.");
        }
        if (child.isFrozen()) {
            throw new IllegalArgumentException("Cannot add a frozen node.");
        }
        this.addChildUnsafe(child, role);
    }

    final void addChildUnsafe(AstNode child, Role<?> role) {
        child._parent = this;
        child.setRoleUnsafe(role);
        if (this._firstChild == null) {
            this._lastChild = this._firstChild = child;
        } else {
            this._lastChild._nextSibling = child;
            child._previousSibling = this._lastChild;
            this._lastChild = child;
        }
    }

    @SafeVarargs
    public final <T extends AstNode> void insertChildrenBefore(AstNode nextSibling, Role<T> role, T ... children) {
        VerifyArgument.notNull(children, (String)"children");
        for (T child : children) {
            this.insertChildBefore(nextSibling, child, role);
        }
    }

    public final <T extends AstNode> void insertChildBefore(AstNode nextSibling, T child, Role<T> role) {
        VerifyArgument.notNull(role, (String)"role");
        if (nextSibling == null || nextSibling.isNull()) {
            this.addChild(child, role);
            return;
        }
        if (child == null || child.isNull()) {
            return;
        }
        this.verifyNotFrozen();
        if (child._parent != null) {
            throw new IllegalArgumentException("Node belongs to another tree.");
        }
        if (child.isFrozen()) {
            throw new IllegalArgumentException("Cannot add a frozen node.");
        }
        if (nextSibling._parent != this) {
            throw new IllegalArgumentException("Next sibling is not a child of this node.");
        }
        this.insertChildBeforeUnsafe(nextSibling, child, role);
    }

    @SafeVarargs
    public final <T extends AstNode> void insertChildrenAfter(AstNode nextSibling, Role<T> role, T ... children) {
        VerifyArgument.notNull(children, (String)"children");
        for (T child : children) {
            this.insertChildAfter(nextSibling, child, role);
        }
    }

    public final <T extends AstNode> void insertChildAfter(AstNode previousSibling, T child, Role<T> role) {
        this.insertChildBefore(previousSibling == null || previousSibling.isNull() ? this._firstChild : previousSibling._nextSibling, child, role);
    }

    final void insertChildBeforeUnsafe(AstNode nextSibling, AstNode child, Role<?> role) {
        child._parent = this;
        child.setRole(role);
        child._nextSibling = nextSibling;
        child._previousSibling = nextSibling._previousSibling;
        if (nextSibling._previousSibling != null) {
            assert (nextSibling._previousSibling._nextSibling == nextSibling);
            nextSibling._previousSibling._nextSibling = child;
        } else {
            assert (this._firstChild == nextSibling);
            this._firstChild = child;
        }
        nextSibling._previousSibling = child;
    }

    public final void remove() {
        if (this._parent == null) {
            return;
        }
        this.verifyNotFrozen();
        if (this._previousSibling != null) {
            assert (this._previousSibling._nextSibling == this);
            this._previousSibling._nextSibling = this._nextSibling;
        } else {
            assert (this._parent._firstChild == this);
            this._parent._firstChild = this._nextSibling;
        }
        if (this._nextSibling != null) {
            assert (this._nextSibling._previousSibling == this);
            this._nextSibling._previousSibling = this._previousSibling;
        } else {
            assert (this._parent._lastChild == this);
            this._parent._lastChild = this._previousSibling;
        }
        this._parent = null;
        this._previousSibling = null;
        this._nextSibling = null;
    }

    public final void replaceWith(AstNode newNode) {
        if (newNode == null || newNode.isNull()) {
            this.remove();
            return;
        }
        if (newNode == this) {
            return;
        }
        if (this._parent == null) {
            throw new IllegalStateException(this.isNull() ? "Cannot replace null nodes." : "Cannot replace the root node.");
        }
        this.verifyNotFrozen();
        Role<? extends AstNode> role = this.getRole();
        if (!role.isValid(newNode)) {
            throw new IllegalArgumentException(String.format("The new node '%s' is not valid for role '%s'.", newNode.getClass().getName(), role.toString()));
        }
        if (newNode._parent != null) {
            if (CollectionUtilities.contains(newNode.getAncestors(), (Object)this)) {
                newNode.remove();
            } else {
                throw new IllegalArgumentException("Node belongs to another tree.");
            }
        }
        if (newNode.isFrozen()) {
            throw new IllegalArgumentException("Node belongs to another tree.");
        }
        newNode._parent = this._parent;
        newNode.setRoleUnsafe(role);
        newNode._previousSibling = this._previousSibling;
        newNode._nextSibling = this._nextSibling;
        if (this._parent != null) {
            if (this._previousSibling != null) {
                assert (this._previousSibling._nextSibling == this);
                this._previousSibling._nextSibling = newNode;
            } else {
                assert (this._parent._firstChild == this);
                this._parent._firstChild = newNode;
            }
            if (this._nextSibling != null) {
                assert (this._nextSibling._previousSibling == this);
                this._nextSibling._previousSibling = newNode;
            } else {
                assert (this._parent._lastChild == this);
                this._parent._lastChild = newNode;
            }
            this._parent = null;
            this._previousSibling = null;
            this._nextSibling = null;
        }
    }

    public final <T extends AstNode> T replaceWith(Function<? super AstNode, ? extends T> replaceFunction) {
        VerifyArgument.notNull(replaceFunction, (String)"replaceFunction");
        if (this._parent == null) {
            throw new IllegalStateException(this.isNull() ? "Cannot replace null nodes." : "Cannot replace the root node.");
        }
        AstNode oldParent = this._parent;
        AstNode oldSuccessor = this._nextSibling;
        Role<? extends AstNode> oldRole = this.getRole();
        this.remove();
        AstNode replacement = (AstNode)replaceFunction.apply((Object)this);
        if (oldSuccessor != null && oldSuccessor._parent != oldParent) {
            throw new IllegalStateException("Replace function changed next sibling of node being replaced.");
        }
        if (replacement != null && !replacement.isNull()) {
            if (replacement.getParent() != null) {
                throw new IllegalStateException("replace function must return the root of a tree");
            }
            if (!oldRole.isValid(replacement)) {
                throw new IllegalStateException(String.format("The new node '%s' is not valid in the role %s.", replacement.getClass().getSimpleName(), oldRole));
            }
            if (oldSuccessor != null) {
                oldParent.insertChildBeforeUnsafe(oldSuccessor, replacement, oldRole);
            } else {
                oldParent.addChildUnsafe(replacement, oldRole);
            }
        }
        return (T)replacement;
    }

    protected void freezeCore() {
        AstNode child = this._firstChild;
        while (child != null) {
            child.freezeIfUnfrozen();
            child = child._nextSibling;
        }
        this.flags |= 0x200;
    }

    public abstract NodeType getNodeType();

    public boolean isReference() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public Role<? extends AstNode> getRole() {
        return Role.get(this.flags & 0x1FF);
    }

    public final void setRole(Role<?> role) {
        VerifyArgument.notNull(role, (String)"role");
        if (!role.isValid(this)) {
            throw new IllegalArgumentException("This node is not valid for the specified role.");
        }
        this.verifyNotFrozen();
        this.setRoleUnsafe(role);
    }

    @Override
    public abstract boolean matches(INode var1, Match var2);

    @Override
    public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
        return (position == null || position instanceof AstNode) && this.matches(position, match);
    }

    @Override
    public final Match match(INode other) {
        Match match = Match.createNew();
        return this.matches(other, match) ? match : Match.failure();
    }

    @Override
    public final boolean matches(INode other) {
        return this.matches(other, Match.createNew());
    }

    public static AstNode forPattern(Pattern pattern) {
        return new PatternPlaceholder((Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    public NamedNode withName(String name) {
        return new NamedNode(name, this);
    }

    public OptionalNode makeOptional() {
        return new OptionalNode(this);
    }

    public TextLocation getStartLocation() {
        AstNode child = this._firstChild;
        return child != null ? child.getStartLocation() : TextLocation.EMPTY;
    }

    public TextLocation getEndLocation() {
        AstNode child = this._lastChild;
        return child != null ? child.getEndLocation() : TextLocation.EMPTY;
    }

    public Region getRegion() {
        return new Region(this.getStartLocation(), this.getEndLocation());
    }

    public final boolean contains(int line, int column) {
        return this.contains(new TextLocation(line, column));
    }

    public final boolean contains(TextLocation location) {
        if (location == null || location.isEmpty()) {
            return false;
        }
        TextLocation startLocation = this.getStartLocation();
        TextLocation endLocation = this.getEndLocation();
        return startLocation != null && endLocation != null && location.compareTo(startLocation) >= 0 && location.compareTo(endLocation) < 0;
    }

    public final boolean isInside(int line, int column) {
        return this.isInside(new TextLocation(line, column));
    }

    public final boolean isInside(TextLocation location) {
        if (location == null || location.isEmpty()) {
            return false;
        }
        TextLocation startLocation = this.getStartLocation();
        TextLocation endLocation = this.getEndLocation();
        return startLocation != null && endLocation != null && location.compareTo(startLocation) >= 0 && location.compareTo(endLocation) <= 0;
    }

    public String getText() {
        return this.getText(null);
    }

    public String getText(JavaFormattingOptions options) {
        if (this.isNull()) {
            return "";
        }
        PlainTextOutput output = new PlainTextOutput();
        JavaOutputVisitor visitor = new JavaOutputVisitor(output, DecompilerSettings.javaDefaults());
        this.acceptVisitor(visitor, null);
        return ((Object)output).toString();
    }

    String debugToString() {
        if (this.isNull()) {
            return "Null";
        }
        String text = StringUtilities.trimRight((String)this.getText());
        return text.length() > 1000 ? text.substring(0, 97) + "..." : text;
    }

    public String toString() {
        return this.debugToString();
    }

    public final <T> T getUserData(Key<T> key) {
        return (T)this._dataStore.getUserData(key);
    }

    public final <T> void putUserData(Key<T> key, T value) {
        this._dataStore.putUserData(key, value);
    }

    public final <T> T putUserDataIfAbsent(Key<T> key, T value) {
        return (T)this._dataStore.putUserDataIfAbsent(key, value);
    }

    public final <T> boolean replace(Key<T> key, T oldValue, T newValue) {
        return this._dataStore.replace(key, oldValue, newValue);
    }

    private static final class PatternPlaceholder
    extends AstNode {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            this.child = child;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }
    }

    private static final class NullAstNode
    extends AstNode {
        private NullAstNode() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.UNKNOWN;
        }
    }
}

