/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;

public class RefCursors
extends SimpleProcProvider {
    static final BinDecoder BINARY_DECODER = new BinDecoder();
    static final TxtDecoder TEXT_DECODER = new TxtDecoder();

    public RefCursors() {
        super(null, (Type.Codec.Decoder<CharSequence>)TEXT_DECODER, null, (Type.Codec.Decoder<ByteBuf>)BINARY_DECODER, "refcursor");
    }

    private static Object convertOutput(Context context, ResultSet decoded, Class<?> targetClass, Object targetContext) {
        if (targetClass == ResultSet.class) {
            return decoded;
        }
        return null;
    }

    private static ResultSet resultSet(PGDirectConnection connection, String portalName) throws IOException {
        try {
            RequestExecutorHandlers.QueryResult result = new RequestExecutorHandlers.QueryResult(true);
            connection.getRequestExecutor().query(portalName, 0, result);
            result.await(180L, TimeUnit.SECONDS);
            ResultBatch batch = result.getBatch();
            PGStatement statement = connection.createStatement();
            statement.closeOnCompletion();
            return statement.createResultSet(batch.getFields(), batch.takeRows(), true, connection.getTypeMap());
        }
        catch (SQLException e) {
            throw new IOException("Failed to load refcursor", e);
        }
    }

    public static class TxtDecoder
    extends AutoConvertingTextDecoder<ResultSet> {
        TxtDecoder() {
            super((Context x$0, N x$1, Class<?> x$2, Object x$3) -> RefCursors.convertOutput(x$0, x$1, x$2, x$3));
            this.enableRespectMaxLength();
        }

        @Override
        public Class<ResultSet> getDefaultClass() {
            return ResultSet.class;
        }

        @Override
        protected ResultSet decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            String portalName = buffer.toString();
            PGDirectConnection connection = (PGDirectConnection)context.unwrap();
            return RefCursors.resultSet(connection, portalName);
        }
    }

    public static class BinDecoder
    extends AutoConvertingBinaryDecoder<ResultSet> {
        public BinDecoder() {
            super(null, (Context x$0, N x$1, Class<?> x$2, Object x$3) -> RefCursors.convertOutput(x$0, x$1, x$2, x$3));
        }

        @Override
        public Class<ResultSet> getDefaultClass() {
            return ResultSet.class;
        }

        @Override
        protected ResultSet decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int length = buffer.readableBytes();
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            String portalName = new String(bytes, StandardCharsets.UTF_8);
            PGDirectConnection connection = (PGDirectConnection)context.unwrap();
            return RefCursors.resultSet(connection, portalName);
        }
    }
}

