/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.TypeRef;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class TypeOid
implements TypeRef {
    public static final TypeOid INVALID = new TypeOid(0);
    private static final AtomicReferenceArray<TypeOid> fastCachedOids = new AtomicReferenceArray(4096);
    private int oid;

    public static TypeOid valueOf(int oid) {
        if (oid < fastCachedOids.length() && oid >= 0) {
            if (fastCachedOids.compareAndSet(oid, null, INVALID)) {
                TypeOid toid = new TypeOid(oid);
                fastCachedOids.set(oid, toid);
                return toid;
            }
            TypeOid toid = fastCachedOids.get(oid);
            if (toid == INVALID) {
                toid = new TypeOid(oid);
            }
            return toid;
        }
        return new TypeOid(oid);
    }

    private TypeOid(int oid) {
        this.oid = oid;
    }

    @Override
    public int getOid() {
        return this.oid;
    }

    public String toString() {
        return "->" + this.oid;
    }
}

