package org.simantics.utils.ui.widgets;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class DirectorySelectionWidget extends FileOrDirectorySelectionWidget{

	
	private int style;
	
	public DirectorySelectionWidget(Composite parent, String name, int style) {
		super(parent, name, style&~(SWT.OPEN|SWT.CLOSE));
		this.style = style & (SWT.OPEN|SWT.CLOSE);
	}

	@Override
	protected String[] openDialog() {
		DirectoryDialog dialog = new DirectoryDialog(getShell(),style);
		String name = dialog.open();
		if (name == null)
			return null;
		return new String[]{name};
	}
	
	@Override
	protected boolean isValid(File file) {
		return (file.exists() && file.isDirectory());
	}
}
