/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 29.12.2005
 * 
 */
package org.simantics.utils.ui.validators;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.jface.dialogs.IInputValidator;


/**
 * URI Validator
 * 
 * @author Toni Kalajainen 
 */
public class URIValidator implements IInputValidator {
    
    private final String supportedProtocols[];
    
    public URIValidator() { 
        supportedProtocols = null;
    }

    public URIValidator(String... supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }
    
    public String isValid(String newText) {
        try {
            URI u = new URI(newText);
            if (supportedProtocols==null)
                return null;
            for (String p : supportedProtocols)
                if (p.equals(u.getScheme()))
                    return null;
            return u.getScheme()+":// is not supported.";
        } catch (URISyntaxException e) {
            return e.getMessage();
        }
    }

}

