/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.session.SessionEventListenerAdapter;
import org.simantics.db.event.SessionEventListener;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SessionEventSupport;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.ProfileEntry;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ProfileObserverData;
import org.simantics.scenegraph.profile.impl.DebugPolicy;
import org.simantics.scenegraph.profile.impl.ProfileActivationListener;
import org.simantics.scenegraph.profile.request.RuntimeProfileActiveEntries;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileObserver
implements EvaluationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileObserver.class);
    private final Session session;
    private final Resource resource;
    private final IDisposable canvas;
    private final IThreadWorkQueue thread;
    private final Object diagram;
    private final Runnable notification;
    private final G2DSceneGraph sceneGraph;
    private volatile boolean dirty = true;
    private volatile boolean disposed = false;
    private boolean needSynchronizedUpdates = false;
    private List<Pair<Style, Object>> updates = new ArrayList<Pair<Style, Object>>();
    private boolean updateAll;
    private ProfileActivationListener activationListener;
    private Map<String, Object> constants = new HashMap<String, Object>();
    private Map<INode, Map<String, Object>> temporaryProperties = new HashMap<INode, Map<String, Object>>();
    private Map<INode, Map<String, Object>> properties = new HashMap<INode, Map<String, Object>>();
    private final SessionEventListenerAdapter transactionListener = new SessionEventListenerAdapter(){

        public void writeTransactionFinished() {
            if (ProfileObserver.this.isDisposed()) {
                ProfileObserver.this.dispose();
            }
            if (ProfileObserver.this.dirty) {
                ProfileObserver.this.perform();
            }
        }

        public void readTransactionFinished() {
            if (ProfileObserver.this.isDisposed()) {
                ProfileObserver.this.dispose();
            }
            if (ProfileObserver.this.dirty) {
                ProfileObserver.this.perform();
            }
        }
    };

    public ProfileObserver(Session session, Resource resource, IThreadWorkQueue thread, IDisposable canvas, G2DSceneGraph sceneGraph, Object diagram, Map<String, Object> constants, Runnable notification) {
        this.session = session;
        this.resource = resource;
        this.thread = thread;
        this.canvas = canvas;
        this.diagram = diagram;
        this.sceneGraph = sceneGraph;
        this.constants.putAll(constants);
        this.notification = notification;
        this.needSynchronizedUpdates = ((QueryControl)session.getService(QueryControl.class)).getAmountOfQueryThreads() > 1;
        this.attachSessionListener();
        if (DebugPolicy.DEBUG_PROFILE_OBSERVER_PERFORM) {
            System.out.println("ProfileObserver(" + String.valueOf(this) + ")");
        }
        if (sceneGraph != null) {
            sceneGraph.setPending((Object)this);
        }
    }

    private void attachSessionListener() {
        SessionEventSupport eventSupport = (SessionEventSupport)this.session.getService(SessionEventSupport.class);
        eventSupport.addListener((SessionEventListener)this.transactionListener);
    }

    private void detachSessionListener() {
        SessionEventSupport eventSupport = (SessionEventSupport)this.session.getService(SessionEventSupport.class);
        eventSupport.removeListener((SessionEventListener)this.transactionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProfileObserver profileObserver = this;
        synchronized (profileObserver) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        if (DebugPolicy.DEBUG_PROFILE_OBSERVER_PERFORM) {
            System.out.println("ProfileObserver.dispose(" + String.valueOf(this) + ")");
        }
        if (this.activationListener != null) {
            this.activationListener.cleanup();
            this.activationListener = null;
        }
        this.detachSessionListener();
    }

    @Override
    public boolean isActive(Style style, Object item) {
        return ProfileObserverData.getInstance().isActive(style, this.resource, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Style style, Object item) {
        if (DebugPolicy.DEBUG_PROFILE_OBSERVER_UPDATE) {
            System.out.println("Profile observer marked dirty for " + String.valueOf(style) + " " + String.valueOf(item));
        }
        if (this.needSynchronizedUpdates) {
            List<Pair<Style, Object>> list = this.updates;
            synchronized (list) {
                this.updates.add((Pair<Style, Object>)Pair.make((Object)style, (Object)item));
            }
        } else {
            this.updates.add((Pair<Style, Object>)Pair.make((Object)style, (Object)item));
        }
        this.dirty = true;
    }

    @Override
    public void update() {
        this.updateAll = true;
        this.dirty = true;
    }

    private void perform() {
        this.dirty = false;
        if (DebugPolicy.DEBUG_PROFILE_OBSERVER_UPDATE) {
            System.out.println("Profile observer detected a change.");
        }
        this.session.asyncRequest((Read)new RuntimeProfileActiveEntries(this.resource), (Procedure)new Procedure<Collection<ProfileEntry>>(){

            public void execute(final Collection<ProfileEntry> entries) {
                if (ProfileObserver.this.isDisposed()) {
                    return;
                }
                ThreadUtils.asyncExec((IThreadWorkQueue)ProfileObserver.this.thread, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long t0;
                        if (ProfileObserver.this.isDisposed()) {
                            return;
                        }
                        (this).ProfileObserver.this.temporaryProperties.clear();
                        long l = t0 = DebugPolicy.DEBUG_PROFILE_OBSERVER_PERFORM ? System.nanoTime() : 0L;
                        if ((this).ProfileObserver.this.updateAll) {
                            for (Object e : entries) {
                                if (DebugPolicy.DEBUG_PROFILE_OBSERVER_PERFORM) {
                                    System.out.println("Apply profile entry: " + String.valueOf(e));
                                }
                                e.apply(ProfileObserver.this);
                            }
                            (this).ProfileObserver.this.updateAll = false;
                            if ((this).ProfileObserver.this.needSynchronizedUpdates) {
                                Object e;
                                e = (this).ProfileObserver.this.updates;
                                synchronized (e) {
                                    (this).ProfileObserver.this.updates.clear();
                                }
                            } else {
                                (this).ProfileObserver.this.updates.clear();
                            }
                        } else {
                            ArrayList<Pair<Style, Object>> updatesCopy;
                            if ((this).ProfileObserver.this.needSynchronizedUpdates) {
                                List<Pair<Style, Object>> list = (this).ProfileObserver.this.updates;
                                synchronized (list) {
                                    updatesCopy = new ArrayList<Pair<Style, Object>>((this).ProfileObserver.this.updates);
                                    (this).ProfileObserver.this.updates.clear();
                                }
                            } else {
                                updatesCopy = new ArrayList<Pair<Style, Object>>((this).ProfileObserver.this.updates);
                                (this).ProfileObserver.this.updates.clear();
                            }
                            for (Pair pair : updatesCopy) {
                                Style style = (Style)pair.first;
                                Object item = pair.second;
                                style.apply2(item, ProfileObserver.this);
                            }
                        }
                        if (DebugPolicy.DEBUG_PROFILE_OBSERVER_PERFORM) {
                            long t1 = System.nanoTime();
                            System.out.println((double)(t1 - t0) / 1000000.0);
                        }
                        if ((this).ProfileObserver.this.dirty) {
                            (this).ProfileObserver.this.sceneGraph.setPending((Object)ProfileObserver.this);
                        } else {
                            (this).ProfileObserver.this.sceneGraph.clearPending((Object)ProfileObserver.this);
                        }
                        (this).ProfileObserver.this.notification.run();
                        if ((this).ProfileObserver.this.dirty) {
                            Simantics.async(() -> {
                                if (ProfileObserver.this.isDisposed()) {
                                    return;
                                }
                                if ((this).ProfileObserver.this.dirty) {
                                    ProfileObserver.this.perform();
                                }
                            }, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                LOGGER.error("RuntimeProfileActiveEntries request failed", t);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.disposed || this.canvas.isDisposed();
    }

    @Override
    public void exception(Throwable throwable) {
        LOGGER.error("Exception occurred during diagram profile observation", throwable);
    }

    @Override
    public <T> T getTemporaryProperty(INode element, String key) {
        Map<String, Object> map = this.temporaryProperties.get(element);
        Object t = map == null ? null : map.get(key);
        return (T)t;
    }

    @Override
    public <T> void setTemporaryProperty(INode element, String key, T value) {
        Map<String, Object> map = this.temporaryProperties.get(element);
        if (map == null) {
            if (value == null) {
                return;
            }
            map = new HashMap<String, Object>(8);
            this.temporaryProperties.put(element, map);
        }
        if (value == null) {
            map.remove(key);
            if (map.isEmpty()) {
                this.temporaryProperties.remove(element);
            }
        } else {
            map.put(key, value);
        }
    }

    @Override
    public <T> T getProperty(INode element, String key) {
        Map<String, Object> map = this.properties.get(element);
        Object t = map == null ? null : map.get(key);
        return (T)t;
    }

    @Override
    public <T> T setProperty(INode element, String key, T value) {
        Object result = null;
        Map<String, Object> map = this.properties.get(element);
        if (map == null) {
            if (value == null) {
                return null;
            }
            map = new HashMap<String, Object>(8);
            this.properties.put(element, map);
        }
        if (value == null) {
            result = map.remove(key);
            if (map.isEmpty()) {
                this.properties.remove(element);
            }
        } else {
            result = map.put(key, value);
        }
        return (T)result;
    }

    @Override
    public <T> T getConstant(String key) {
        return (T)this.constants.get(key);
    }

    public String toString() {
        return "ProfileObserver[" + this.resource.getResourceId() + "]";
    }

    public void listen(AsyncRequestProcessor processor, IDisposable disposable) {
        this.activationListener = new ProfileActivationListener(this.resource, this, disposable);
        processor.asyncRequest((Read)new RuntimeProfileActiveEntries(this.resource), (AsyncListener)this.activationListener);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public G2DSceneGraph getSceneGraph() {
        return this.sceneGraph;
    }
}

