/*******************************************************************************
 *  Copyright (c) 2023 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web.serializer;

import java.awt.Color;
import java.io.IOException;
import java.util.Locale;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * @author Jussi Koskela
 * @since 1.57.0
 */
public class ColorSerializer extends StdSerializer<Color> {
	private static final long serialVersionUID = -2748535131278907540L;

	public ColorSerializer() {
		this(null);
	}

	public ColorSerializer(Class<Color> t) {
		super(t);
	}

	@Override
	public void serialize(Color value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		jgen.writeString("rgba(" + value.getRed() + "," + value.getGreen() + "," + value.getBlue() + ","
				+ String.format(Locale.ENGLISH, "%.2f", value.getAlpha() / 255.0) + ")");
	}
}