/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/**
 * @author Tuukka Lehtonen
 */
public final class IssuePreferenceUtil {

    public static final String PLUGIN_ID = "org.simantics.issues";

    public static IssuePreferences getDefaultPreferences() {
        return getPreferences(DefaultScope.INSTANCE);
    }

    /**
     * @return
     */
    public static IssuePreferences getPreferences() {
        return getPreferences(InstanceScope.INSTANCE);
    }

    /**
     * @return
     */
    public static IssuePreferences getPreferences(IScopeContext context) {
        Preferences node = context.getNode(PLUGIN_ID);
        boolean enabled = node.getBoolean(IssuePreferences.P_ISSUES_ENABLED, IssuePreferences.DEFAULT_ISSUES_ENABLED);
        int maxIssuesToWrite = node.getInt(IssuePreferences.P_MAX_BATCH_ISSUES_TO_WRITE, IssuePreferences.DEFAULT_MAX_BATCH_ISSUES_TO_WRITE);
        return new IssuePreferences(enabled, maxIssuesToWrite);
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    public static void setPreferences(IssuePreferences commons) {
        _setPreferences(InstanceScope.INSTANCE, commons);
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    public static void flushPreferences(IssuePreferences commons) throws BackingStoreException {
        Preferences p = _setPreferences(InstanceScope.INSTANCE, commons);
        p.flush();
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    public static void setPreferences(IScopeContext context, IssuePreferences prefs) {
        _setPreferences(context, prefs);
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    private static IEclipsePreferences _setPreferences(IScopeContext context, IssuePreferences prefs) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        node.putBoolean(IssuePreferences.P_ISSUES_ENABLED, prefs.enabled);
        node.putInt(IssuePreferences.P_MAX_BATCH_ISSUES_TO_WRITE, prefs.maxBatchIssuesToWrite);
        return node;
    }

}
