/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.simantics.compressions.impl.Buffers;
import org.simantics.fastlz.FastLZJava;
import org.simantics.fastlz.impl.FastLZConfig;
import org.simantics.fastlz.impl.FastLZInputStream;
import org.simantics.fastlz.impl.FastLZOutputStream;
import org.simantics.fastlz.impl.OS;
import org.simantics.fastlz.java.FastLZJavaInputStream;
import org.simantics.fastlz.java.FastLZJavaOutputStream;

public class FastLZ {
    private static boolean nativeInitialized = false;

    static {
        if (!FastLZ.isNativeDisabled() && FastLZConfig.attemptStaticInitialization) {
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            String libName = OS.resolveLibName();
            URL libURL = FastLZ.class.getResource("/" + libName);
            if (libURL != null) {
                if ("file".equals(libURL.getProtocol())) {
                    try {
                        File path = new File(URLDecoder.decode(libURL.getPath(), "UTF-8"));
                        FastLZ.initialize(path);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else if ("jar".equals(libURL.getProtocol())) {
                    try {
                        File libFile = OS.extractLib(libURL, libName);
                        FastLZ.initialize(libFile);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.err.println("Unsupported URL protocol '" + String.valueOf(libURL) + "' for FastLZ native library file '" + libName + "' for os '" + osName + "' and architecture '" + osArch + "'");
                }
            } else {
                FastLZ.initialize(null);
            }
        }
    }

    public static boolean isNativeInitialized() {
        return nativeInitialized;
    }

    private static boolean isNativeDisabled() {
        return "false".equalsIgnoreCase(System.getProperty("fastlz.native", "true"));
    }

    public static synchronized void initialize(File path) {
        if (nativeInitialized || FastLZ.isNativeDisabled()) {
            return;
        }
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        Object lib = "fastlz";
        try {
            if (path == null) {
                lib = (String)lib + OS.formOsArchSuffix();
                System.loadLibrary((String)lib);
            } else {
                if (path.isDirectory()) {
                    lib = System.mapLibraryName((String)lib + OS.formOsArchSuffix());
                    lib = new File(path, (String)lib).toString();
                } else if (path.isFile()) {
                    lib = path.toString();
                } else {
                    throw new IllegalArgumentException("Invalid path for FastLZ library: " + String.valueOf(path));
                }
                try {
                    System.load((String)lib);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    Object fallback = "fastlz";
                    fallback = (String)fallback + OS.formOsArchSuffix();
                    System.loadLibrary((String)fallback);
                }
            }
            nativeInitialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Couldn't load library '" + (String)lib + "' for os '" + osName + "' and architecture '" + osArch + "'");
            e.printStackTrace();
        }
    }

    public static int compressBound(int inputSize) {
        return Math.max(66, inputSize + inputSize / 20 + 1);
    }

    static native int compress(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4);

    static native int decompress(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5);

    public static int compressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset) {
        if (output.isReadOnly()) {
            throw new IllegalArgumentException("read-only output buffer");
        }
        if (FastLZ.isNativeInitialized() && input.isDirect() && output.isDirect()) {
            return FastLZ.compress(input, inputOffset, length, output, outputOffset);
        }
        byte[] inarr = Buffers.getInputArray((ByteBuffer)input);
        byte[] outarr = Buffers.getOutputArray((ByteBuffer)output);
        int result = FastLZJava.compress(inarr, inputOffset, length, outarr, outputOffset);
        Buffers.writeOutput((ByteBuffer)output, (byte[])outarr);
        return result;
    }

    public static int decompressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset, int maxout) {
        if (output.isReadOnly()) {
            throw new IllegalArgumentException("read-only output buffer");
        }
        if (FastLZ.isNativeInitialized() && input.isDirect() && output.isDirect()) {
            return FastLZ.decompress(input, inputOffset, length, output, outputOffset, maxout);
        }
        byte[] inarr = Buffers.getInputArray((ByteBuffer)input);
        byte[] outarr = Buffers.getOutputArray((ByteBuffer)output);
        int result = FastLZJava.decompress(inarr, inputOffset, length, outarr, outputOffset, maxout);
        Buffers.writeOutput((ByteBuffer)output, (byte[])outarr);
        return result;
    }

    public static InputStream read(File file) throws FileNotFoundException {
        return nativeInitialized ? new FastLZInputStream(file) : new FastLZJavaInputStream(file);
    }

    public static InputStream read(InputStream input) {
        return nativeInitialized ? new FastLZInputStream(input) : new FastLZJavaInputStream(input);
    }

    public static OutputStream write(File file) throws FileNotFoundException {
        return nativeInitialized ? new FastLZOutputStream(file) : new FastLZJavaOutputStream(file);
    }

    public static OutputStream write(OutputStream output) {
        return nativeInitialized ? new FastLZOutputStream(output) : new FastLZJavaOutputStream(output);
    }

    public static synchronized native int decompressCluster(ByteBuffer var0, int var1, int var2, Object[] var3);
}

