/*******************************************************************************
 * Copyright (c) 2019, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.document.server.ConsoleSCLReportingHandler;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.io.IConsole;
import org.simantics.document.server.io.IConsoleSupport;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class URIDocumentRequest extends UnaryRead<String, List<JSONObject>> {

	public URIDocumentRequest(String var) {
		super(var);
	}

	@Override
	public List<JSONObject> perform(ReadGraph graph) throws DatabaseException {

		graph.setSynchronous(true);

		Variable var = Variables.getPossibleVariable(graph, parameter);
		if(var == null) {
			Variables.getPossibleVariable(graph, parameter);
			return Collections.emptyList();
		}

		IConsole console = null;
		IConsoleSupport cs = Simantics.getSession().peekService(IConsoleSupport.class);
		if (cs != null) {
			Variable root = ProxyVariables.proxyVariableRoot(graph, var);
			if (root == null)
				return Collections.emptyList();
			Variable session = root.getParent(graph);
			String guid = session.getName(graph);
			console = cs.getConsole(guid);
		}

		SCLContext sclContext = SCLContext.getCurrent();
		SCLReportingHandler printer = (console != null) ? new ConsoleSCLReportingHandler(console)
				: (SCLReportingHandler) sclContext.get(SCLReportingHandler.REPORTING_HANDLER);
		Object oldPrinter = sclContext.put(SCLReportingHandler.REPORTING_HANDLER, printer);

		try {
			List<JSONObject> result = new ArrayList<>(graph.syncRequest(new DocumentRequest(var)));
			Collections.sort(result, COMPARATOR);
			return result;
		} finally {
			sclContext.put(SCLReportingHandler.REPORTING_HANDLER, oldPrinter);
		}

	}

	private static final Comparator<JSONObject> COMPARATOR = (o1, o2) -> o1.id.compareTo(o2.id);

}