/*******************************************************************************
 * Copyright (c) 2019, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.request;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableChildren;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class NodesRequest extends VariableRead<Set<Variable>> {

    public NodesRequest(Variable var) {
        super(var);
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {

        ITask task = DocumentRequest.PROFILE ? ThreadLogger.task(this) : null;

        StructuralResource2.getInstance(graph);
        if(variable == null)
            return Collections.emptySet();

        Collection<Variable> children = graph.syncRequest(new VariableChildren(variable));

        Set<Variable> nodes = graph.syncRequest(new CollectNodesRequest2(children));

        if(DocumentRequest.PROFILE)
            task.finish();

        return nodes;

    }

}