/*******************************************************************************
 * Copyright (c) 2019, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.request;

import java.util.Collection;
import java.util.Set;

import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;

public class CollectNodesRequest2 extends UnaryAsyncRead<Collection<Variable>, Set<Variable>> {

    public CollectNodesRequest2(Collection<Variable> nodes) {
        super(nodes);
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<Set<Variable>> procedure) {
        Set<Variable> rs = new UnifiedSet<>(Math.max(8, parameter.size() * 2));
        for(Variable node : parameter) {
            graph.asyncRequest(new NodesRequest2(node), new AsyncProcedure<Set<Variable>> () {
                @Override
                public void execute(AsyncReadGraph graph, Set<Variable> result) {
                    synchronized(rs) {
                        rs.addAll(result);
                    }
                }
                @Override
                public void exception(AsyncReadGraph graph, Throwable throwable) {
                }
            });
        }
        procedure.execute(graph, rs);
    }

}